/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.writer;

import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.AbstractInputStreamContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.client.http.ByteArrayContent;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.Storage;
import com.google.cloud.hadoop.repackaged.gcs.com.google.api.services.storage.model.StorageObject;
import com.google.cloud.hadoop.repackaged.gcs.com.google.cloud.hadoop.gcsio.StorageResourceId;
import com.google.inject.Inject;
import io.trino.filesystem.Location;
import io.trino.plugin.deltalake.GcsStorageFactory;
import io.trino.plugin.deltalake.transactionlog.writer.TransactionLogSynchronizer;
import io.trino.spi.connector.ConnectorSession;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Objects;

public class GcsTransactionLogSynchronizer
implements TransactionLogSynchronizer {
    private final GcsStorageFactory gcsStorageFactory;

    @Inject
    public GcsTransactionLogSynchronizer(GcsStorageFactory gcsStorageFactory) {
        this.gcsStorageFactory = Objects.requireNonNull(gcsStorageFactory, "gcsStorageFactory is null");
    }

    @Override
    public void write(ConnectorSession session, String clusterId, Location newLogEntryPath, byte[] entryContents) {
        Storage storage = this.gcsStorageFactory.create(session, newLogEntryPath.toString());
        try {
            GcsTransactionLogSynchronizer.createStorageObjectExclusively(newLogEntryPath.toString(), entryContents, storage);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    @Override
    public boolean isUnsafe() {
        return false;
    }

    private static void createStorageObjectExclusively(String blobPath, byte[] content, Storage storage) throws IOException {
        StorageResourceId storageResourceId = StorageResourceId.fromStringPath((String)blobPath);
        Storage.Objects.Insert insert = storage.objects().insert(storageResourceId.getBucketName(), new StorageObject().setName(storageResourceId.getObjectName()), (AbstractInputStreamContent)new ByteArrayContent("application/json", content));
        insert.setIfGenerationMatch(Long.valueOf(0L));
        insert.getMediaHttpUploader().setDirectUploadEnabled(true);
        insert.execute();
    }
}

