/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.transactionlog.checkpoint;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.MoreCollectors;
import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoOutputFile;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogUtil;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointBuilder;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntries;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointEntryIterator;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointSchemaManager;
import io.trino.plugin.deltalake.transactionlog.checkpoint.CheckpointWriter;
import io.trino.plugin.deltalake.transactionlog.checkpoint.LastCheckpoint;
import io.trino.plugin.hive.FileFormatDataSourceStats;
import io.trino.plugin.hive.NodeVersion;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.type.TypeManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class CheckpointWriterManager {
    private final TypeManager typeManager;
    private final CheckpointSchemaManager checkpointSchemaManager;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final String trinoVersion;
    private final TransactionLogAccess transactionLogAccess;
    private final FileFormatDataSourceStats fileFormatDataSourceStats;
    private final JsonCodec<LastCheckpoint> lastCheckpointCodec;

    @Inject
    public CheckpointWriterManager(TypeManager typeManager, CheckpointSchemaManager checkpointSchemaManager, TrinoFileSystemFactory fileSystemFactory, NodeVersion nodeVersion, TransactionLogAccess transactionLogAccess, FileFormatDataSourceStats fileFormatDataSourceStats, JsonCodec<LastCheckpoint> lastCheckpointCodec) {
        this.typeManager = Objects.requireNonNull(typeManager, "typeManager is null");
        this.checkpointSchemaManager = Objects.requireNonNull(checkpointSchemaManager, "checkpointSchemaManager is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.trinoVersion = nodeVersion.toString();
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.fileFormatDataSourceStats = Objects.requireNonNull(fileFormatDataSourceStats, "fileFormatDataSourceStats is null");
        this.lastCheckpointCodec = Objects.requireNonNull(lastCheckpointCodec, "lastCheckpointCodec is null");
    }

    public void writeCheckpoint(ConnectorSession session, TableSnapshot snapshot) {
        try {
            SchemaTableName table = snapshot.getTable();
            long newCheckpointVersion = snapshot.getVersion();
            snapshot.getLastCheckpointVersion().ifPresent(lastCheckpoint -> Preconditions.checkArgument((newCheckpointVersion > lastCheckpoint ? 1 : 0) != 0, (String)"written checkpoint %s for table %s must be greater than last checkpoint version %s", (Object)newCheckpointVersion, (Object)table, (Object)lastCheckpoint));
            CheckpointBuilder checkpointBuilder = new CheckpointBuilder();
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            Optional checkpointMetadataLogEntry = (Optional)snapshot.getCheckpointTransactionLogEntries(session, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)CheckpointEntryIterator.EntryType.METADATA)), this.checkpointSchemaManager, this.typeManager, fileSystem, this.fileFormatDataSourceStats).collect(MoreCollectors.toOptional());
            if (checkpointMetadataLogEntry.isPresent()) {
                this.transactionLogAccess.getMetadataEntry(snapshot, session);
                Preconditions.checkState((((DeltaLakeTransactionLogEntry)checkpointMetadataLogEntry.get()).getMetaData() != null ? 1 : 0) != 0, (Object)"metaData not present in log entry");
                checkpointBuilder.addLogEntry((DeltaLakeTransactionLogEntry)checkpointMetadataLogEntry.get());
                snapshot.getCheckpointTransactionLogEntries(session, (Set<CheckpointEntryIterator.EntryType>)ImmutableSet.of((Object)((Object)CheckpointEntryIterator.EntryType.PROTOCOL), (Object)((Object)CheckpointEntryIterator.EntryType.TRANSACTION), (Object)((Object)CheckpointEntryIterator.EntryType.ADD), (Object)((Object)CheckpointEntryIterator.EntryType.REMOVE), (Object)((Object)CheckpointEntryIterator.EntryType.COMMIT)), this.checkpointSchemaManager, this.typeManager, fileSystem, this.fileFormatDataSourceStats).forEach(checkpointBuilder::addLogEntry);
            }
            snapshot.getJsonTransactionLogEntries().forEach(checkpointBuilder::addLogEntry);
            Location transactionLogDir = Location.of((String)TransactionLogUtil.getTransactionLogDir(snapshot.getTableLocation()));
            Location targetFile = transactionLogDir.appendPath("%020d.checkpoint.parquet".formatted(newCheckpointVersion));
            CheckpointWriter checkpointWriter = new CheckpointWriter(this.typeManager, this.checkpointSchemaManager, this.trinoVersion);
            CheckpointEntries checkpointEntries = checkpointBuilder.build();
            TrinoOutputFile checkpointFile = this.fileSystemFactory.create(session).newOutputFile(targetFile);
            checkpointWriter.write(checkpointEntries, checkpointFile);
            LastCheckpoint newLastCheckpoint = new LastCheckpoint(newCheckpointVersion, checkpointEntries.size(), Optional.empty());
            Location checkpointPath = transactionLogDir.appendPath("_last_checkpoint");
            TrinoOutputFile outputFile = fileSystem.newOutputFile(checkpointPath);
            try (OutputStream outputStream = outputFile.createOrOverwrite();){
                outputStream.write(this.lastCheckpointCodec.toJsonBytes((Object)newLastCheckpoint));
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

