/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.statistics;

import com.google.inject.Inject;
import io.airlift.json.JsonCodec;
import io.trino.filesystem.Location;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.filesystem.TrinoInputFile;
import io.trino.filesystem.TrinoInputStream;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.statistics.ExtendedStatistics;
import io.trino.plugin.deltalake.statistics.ExtendedStatisticsAccess;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.SchemaTableName;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Optional;

public class MetaDirStatisticsAccess
implements ExtendedStatisticsAccess {
    private static final String STATISTICS_META_DIR = "_delta_log/_trino_meta";
    private static final String STATISTICS_FILE = "extended_stats.json";
    private static final String STARBURST_META_DIR = "_delta_log/_starburst_meta";
    private static final String STARBURST_STATISTICS_FILE = "extendeded_stats.json";
    private final TrinoFileSystemFactory fileSystemFactory;
    private final JsonCodec<ExtendedStatistics> statisticsCodec;

    @Inject
    public MetaDirStatisticsAccess(TrinoFileSystemFactory fileSystemFactory, JsonCodec<ExtendedStatistics> statisticsCodec) {
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.statisticsCodec = Objects.requireNonNull(statisticsCodec, "statisticsCodec is null");
    }

    @Override
    public Optional<ExtendedStatistics> readExtendedStatistics(ConnectorSession session, SchemaTableName schemaTableName, String tableLocation) {
        Location location = Location.of((String)tableLocation);
        return this.readExtendedStatistics(session, location, STATISTICS_META_DIR, STATISTICS_FILE).or(() -> this.readExtendedStatistics(session, location, STARBURST_META_DIR, STARBURST_STATISTICS_FILE));
    }

    private Optional<ExtendedStatistics> readExtendedStatistics(ConnectorSession session, Location tableLocation, String statisticsDirectory, String statisticsFile) {
        Optional<ExtendedStatistics> optional;
        block11: {
            Location statisticsPath = tableLocation.appendPath(statisticsDirectory).appendPath(statisticsFile);
            TrinoInputFile inputFile = this.fileSystemFactory.create(session).newInputFile(statisticsPath);
            TrinoInputStream inputStream = inputFile.newStream();
            try {
                optional = Optional.of((ExtendedStatistics)this.statisticsCodec.fromJson(inputStream.readAllBytes()));
                if (inputStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (FileNotFoundException e) {
                        return Optional.empty();
                    }
                }
                catch (IOException e) {
                    throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INTERNAL_ERROR, String.format("failed to read statistics with table location %s", tableLocation), (Throwable)e);
                }
            }
            inputStream.close();
        }
        return optional;
    }

    @Override
    public void updateExtendedStatistics(ConnectorSession session, SchemaTableName schemaTableName, String tableLocation, ExtendedStatistics statistics) {
        try {
            Location statisticsPath = Location.of((String)tableLocation).appendPath(STATISTICS_META_DIR).appendPath(STATISTICS_FILE);
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            try (OutputStream outputStream = fileSystem.newOutputFile(statisticsPath).createOrOverwrite();){
                outputStream.write(this.statisticsCodec.toJsonBytes((Object)statistics));
            }
            Location starburstStatisticsPath = Location.of((String)tableLocation).appendPath(STARBURST_META_DIR).appendPath(STARBURST_STATISTICS_FILE);
            if (fileSystem.newInputFile(starburstStatisticsPath).exists()) {
                fileSystem.deleteFile(starburstStatisticsPath);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, "Failed to store statistics with table location: " + tableLocation, (Throwable)e);
        }
    }

    @Override
    public void deleteExtendedStatistics(ConnectorSession session, SchemaTableName schemaTableName, String tableLocation) {
        Location statisticsPath = Location.of((String)tableLocation).appendPath(STATISTICS_META_DIR).appendPath(STATISTICS_FILE);
        try {
            TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
            if (fileSystem.newInputFile(statisticsPath).exists()) {
                fileSystem.deleteFile(statisticsPath);
            }
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_FILESYSTEM_ERROR, "Error deleting statistics file: " + statisticsPath, (Throwable)e);
        }
    }
}

