/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.procedure;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import com.google.inject.Provider;
import io.trino.plugin.deltalake.statistics.CachingExtendedStatisticsAccess;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.hive.metastore.cache.CachingHiveMetastore;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.StandardErrorCode;
import io.trino.spi.TrinoException;
import io.trino.spi.classloader.ThreadContextClassLoader;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.type.Type;
import io.trino.spi.type.VarcharType;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FlushMetadataCacheProcedure
implements Provider<Procedure> {
    private static final String PROCEDURE_NAME = "flush_metadata_cache";
    private static final String PARAM_SCHEMA_NAME = "SCHEMA_NAME";
    private static final String PARAM_TABLE_NAME = "TABLE_NAME";
    private static final MethodHandle FLUSH_METADATA_CACHE;
    private final Optional<CachingHiveMetastore> cachingHiveMetastore;
    private final TransactionLogAccess transactionLogAccess;
    private final CachingExtendedStatisticsAccess extendedStatisticsAccess;

    @Inject
    public FlushMetadataCacheProcedure(Optional<CachingHiveMetastore> cachingHiveMetastore, TransactionLogAccess transactionLogAccess, CachingExtendedStatisticsAccess extendedStatisticsAccess) {
        this.cachingHiveMetastore = Objects.requireNonNull(cachingHiveMetastore, "cachingHiveMetastore is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.extendedStatisticsAccess = Objects.requireNonNull(extendedStatisticsAccess, "extendedStatisticsAccess is null");
    }

    public Procedure get() {
        return new Procedure("system", PROCEDURE_NAME, (List)ImmutableList.of((Object)new Procedure.Argument(PARAM_SCHEMA_NAME, (Type)VarcharType.VARCHAR, false, null), (Object)new Procedure.Argument(PARAM_TABLE_NAME, (Type)VarcharType.VARCHAR, false, null)), FLUSH_METADATA_CACHE.bindTo(this), true);
    }

    public void flushMetadataCache(String schemaName, String tableName) {
        try (ThreadContextClassLoader ignored = new ThreadContextClassLoader(this.getClass().getClassLoader());){
            this.doFlushMetadataCache(Optional.ofNullable(schemaName), Optional.ofNullable(tableName));
        }
    }

    private void doFlushMetadataCache(Optional<String> schemaName, Optional<String> tableName) {
        if (schemaName.isEmpty() && tableName.isEmpty()) {
            this.cachingHiveMetastore.ifPresent(CachingHiveMetastore::flushCache);
            this.transactionLogAccess.flushCache();
            this.extendedStatisticsAccess.invalidateCache();
        } else if (schemaName.isPresent() && tableName.isPresent()) {
            SchemaTableName schemaTableName = new SchemaTableName(schemaName.get(), tableName.get());
            this.cachingHiveMetastore.ifPresent(cachingMetastore -> cachingMetastore.invalidateTable((String)schemaName.get(), (String)tableName.get()));
            this.transactionLogAccess.invalidateCache(schemaTableName, Optional.empty());
            this.extendedStatisticsAccess.invalidateCache(schemaTableName, Optional.empty());
        } else {
            throw new TrinoException((ErrorCodeSupplier)StandardErrorCode.INVALID_PROCEDURE_ARGUMENT, "Illegal parameter set passed");
        }
    }

    static {
        try {
            FLUSH_METADATA_CACHE = MethodHandles.lookup().unreflect(FlushMetadataCacheProcedure.class.getMethod("flushMetadataCache", String.class, String.class));
        }
        catch (ReflectiveOperationException e) {
            throw new AssertionError((Object)e);
        }
    }
}

