/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.functions.tablechanges;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.functions.tablechanges.TableChangesFileType;
import io.trino.spi.HostAddress;
import io.trino.spi.SplitWeight;
import io.trino.spi.connector.ConnectorSplit;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public record TableChangesSplit(String path, long fileSize, Map<String, Optional<String>> partitionKeys, long currentVersionCommitTimestamp, TableChangesFileType fileType, long currentVersion) implements ConnectorSplit
{
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(TableChangesSplit.class);

    @JsonIgnore
    public boolean isRemotelyAccessible() {
        return true;
    }

    @JsonIgnore
    public List<HostAddress> getAddresses() {
        return ImmutableList.of();
    }

    @JsonIgnore
    public Object getInfo() {
        return ImmutableMap.builder().put((Object)"path", (Object)this.path).put((Object)"length", (Object)this.fileSize).buildOrThrow();
    }

    @JsonIgnore
    public SplitWeight getSplitWeight() {
        return SplitWeight.standard();
    }

    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf((String)this.path) + SizeOf.estimatedSizeOf(this.partitionKeys, SizeOf::estimatedSizeOf, value -> SizeOf.sizeOf((Optional)value, SizeOf::estimatedSizeOf));
    }
}

