/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake.expression;

import com.google.common.base.MoreObjects;
import io.trino.plugin.deltalake.expression.SparkExpression;
import io.trino.plugin.deltalake.expression.SparkExpressionTreeVisitor;
import java.util.Objects;

public class BetweenPredicate
extends SparkExpression {
    private final Operator operator;
    private final SparkExpression value;
    private final SparkExpression min;
    private final SparkExpression max;

    public BetweenPredicate(Operator operator, SparkExpression value, SparkExpression min, SparkExpression max) {
        this.operator = Objects.requireNonNull(operator, "operator is null");
        this.value = Objects.requireNonNull(value, "value is null");
        this.min = Objects.requireNonNull(min, "min is null");
        this.max = Objects.requireNonNull(max, "max is null");
    }

    public Operator getOperator() {
        return this.operator;
    }

    public SparkExpression getValue() {
        return this.value;
    }

    public SparkExpression getMin() {
        return this.min;
    }

    public SparkExpression getMax() {
        return this.max;
    }

    @Override
    <R, C> R accept(SparkExpressionTreeVisitor<R, C> visitor, C context) {
        return visitor.visitBetweenExpression(this, context);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BetweenPredicate that = (BetweenPredicate)o;
        return this.operator == that.operator && Objects.equals(this.value, that.value) && Objects.equals(this.min, that.min) && Objects.equals(this.max, that.max);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.operator, this.value, this.min, this.max});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("operator", (Object)this.operator).add("value", (Object)this.value).add("min", (Object)this.min).add("max", (Object)this.max).toString();
    }

    public static enum Operator {
        BETWEEN("BETWEEN"),
        NOT_BETWEEN("NOT BETWEEN");

        private final String value;

        private Operator(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }
    }
}

