/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.MoreCollectors;
import io.trino.filesystem.TrinoFileSystem;
import io.trino.filesystem.TrinoFileSystemFactory;
import io.trino.plugin.deltalake.DeltaLakeErrorCode;
import io.trino.plugin.deltalake.DeltaLakeTableName;
import io.trino.plugin.deltalake.transactionlog.CommitInfoEntry;
import io.trino.plugin.deltalake.transactionlog.DeltaLakeTransactionLogEntry;
import io.trino.plugin.deltalake.transactionlog.TableSnapshot;
import io.trino.plugin.deltalake.transactionlog.TransactionLogAccess;
import io.trino.plugin.deltalake.transactionlog.checkpoint.TransactionLogTail;
import io.trino.plugin.deltalake.util.PageListBuilder;
import io.trino.spi.ErrorCodeSupplier;
import io.trino.spi.Page;
import io.trino.spi.TrinoException;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.connector.ConnectorPageSource;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorTableMetadata;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.EmptyPageSource;
import io.trino.spi.connector.FixedPageSource;
import io.trino.spi.connector.SchemaTableName;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.predicate.Domain;
import io.trino.spi.predicate.Range;
import io.trino.spi.predicate.TupleDomain;
import io.trino.spi.type.BigintType;
import io.trino.spi.type.BooleanType;
import io.trino.spi.type.TimeZoneKey;
import io.trino.spi.type.TimestampWithTimeZoneType;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeManager;
import io.trino.spi.type.TypeSignature;
import io.trino.spi.type.VarcharType;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;

public class DeltaLakeHistoryTable
implements SystemTable {
    private final SchemaTableName tableName;
    private final String tableLocation;
    private final TrinoFileSystemFactory fileSystemFactory;
    private final TransactionLogAccess transactionLogAccess;
    private final ConnectorTableMetadata tableMetadata;

    public DeltaLakeHistoryTable(SchemaTableName tableName, String tableLocation, TrinoFileSystemFactory fileSystemFactory, TransactionLogAccess transactionLogAccess, TypeManager typeManager) {
        Objects.requireNonNull(typeManager, "typeManager is null");
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.tableLocation = Objects.requireNonNull(tableLocation, "tableLocation is null");
        this.fileSystemFactory = Objects.requireNonNull(fileSystemFactory, "fileSystemFactory is null");
        this.transactionLogAccess = Objects.requireNonNull(transactionLogAccess, "transactionLogAccess is null");
        this.tableMetadata = new ConnectorTableMetadata(Objects.requireNonNull(tableName, "tableName is null"), (List)ImmutableList.builder().add((Object)new ColumnMetadata("version", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("timestamp", (Type)TimestampWithTimeZoneType.TIMESTAMP_TZ_MILLIS)).add((Object)new ColumnMetadata("user_id", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("user_name", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("operation", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("operation_parameters", typeManager.getType(TypeSignature.mapType((TypeSignature)VarcharType.VARCHAR.getTypeSignature(), (TypeSignature)VarcharType.VARCHAR.getTypeSignature())))).add((Object)new ColumnMetadata("cluster_id", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("read_version", (Type)BigintType.BIGINT)).add((Object)new ColumnMetadata("isolation_level", (Type)VarcharType.VARCHAR)).add((Object)new ColumnMetadata("is_blind_append", (Type)BooleanType.BOOLEAN)).build());
    }

    public SystemTable.Distribution getDistribution() {
        return SystemTable.Distribution.SINGLE_COORDINATOR;
    }

    public ConnectorTableMetadata getTableMetadata() {
        return this.tableMetadata;
    }

    public ConnectorPageSource pageSource(ConnectorTransactionHandle transactionHandle, ConnectorSession session, TupleDomain<Integer> constraint) {
        Map domains;
        try {
            SchemaTableName baseTableName = new SchemaTableName(this.tableName.getSchemaName(), DeltaLakeTableName.tableNameFrom(this.tableName.getTableName()));
            TableSnapshot tableSnapshot = this.transactionLogAccess.loadSnapshot(baseTableName, this.tableLocation, session);
            this.transactionLogAccess.getMetadataEntry(tableSnapshot, session);
        }
        catch (IOException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Unable to load table metadata from location: " + this.tableLocation, (Throwable)e);
        }
        int versionColumnIndex = (Integer)IntStream.range(0, this.tableMetadata.getColumns().size()).filter(i -> ((ColumnMetadata)this.tableMetadata.getColumns().get(i)).getName().equals("version")).boxed().collect(MoreCollectors.onlyElement());
        Optional<Long> startVersionExclusive = Optional.empty();
        Optional<Long> endVersionInclusive = Optional.empty();
        if (constraint.getDomains().isPresent() && (domains = (Map)constraint.getDomains().get()).containsKey(versionColumnIndex)) {
            Domain versionDomain = (Domain)domains.get(versionColumnIndex);
            Range range = versionDomain.getValues().getRanges().getSpan();
            if (range.isSingleValue()) {
                long value = (Long)range.getSingleValue();
                startVersionExclusive = Optional.of(value - 1L);
                endVersionInclusive = Optional.of(value);
            } else {
                Optional<Long> highValue;
                Optional<Long> lowValue = range.getLowValue().map(Long.class::cast);
                if (lowValue.isPresent()) {
                    startVersionExclusive = Optional.of(lowValue.get() - (long)(range.isLowInclusive() ? 1 : 0));
                }
                if ((highValue = range.getHighValue().map(Long.class::cast)).isPresent()) {
                    endVersionInclusive = Optional.of(highValue.get() - (long)(range.isHighInclusive() ? 0 : 1));
                }
            }
        }
        if (startVersionExclusive.isPresent() && endVersionInclusive.isPresent() && (Long)startVersionExclusive.get() >= (Long)endVersionInclusive.get()) {
            return new EmptyPageSource();
        }
        TrinoFileSystem fileSystem = this.fileSystemFactory.create(session);
        try {
            List commitInfoEntries = (List)TransactionLogTail.loadNewTail(fileSystem, this.tableLocation, startVersionExclusive, endVersionInclusive).getFileEntries().stream().map(DeltaLakeTransactionLogEntry::getCommitInfo).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
            return new FixedPageSource(this.buildPages(session, commitInfoEntries));
        }
        catch (TrinoException e) {
            throw e;
        }
        catch (IOException | RuntimeException e) {
            throw new TrinoException((ErrorCodeSupplier)DeltaLakeErrorCode.DELTA_LAKE_INVALID_SCHEMA, "Error getting commit info entries from " + this.tableLocation, (Throwable)e);
        }
    }

    private List<Page> buildPages(ConnectorSession session, List<CommitInfoEntry> commitInfoEntries) {
        PageListBuilder pagesBuilder = PageListBuilder.forTable(this.tableMetadata);
        TimeZoneKey timeZoneKey = session.getTimeZoneKey();
        commitInfoEntries.forEach(commitInfoEntry -> {
            pagesBuilder.beginRow();
            pagesBuilder.appendBigint(commitInfoEntry.getVersion());
            pagesBuilder.appendTimestampTzMillis(commitInfoEntry.getTimestamp(), timeZoneKey);
            DeltaLakeHistoryTable.write(commitInfoEntry.getUserId(), pagesBuilder);
            DeltaLakeHistoryTable.write(commitInfoEntry.getUserName(), pagesBuilder);
            DeltaLakeHistoryTable.write(commitInfoEntry.getOperation(), pagesBuilder);
            if (commitInfoEntry.getOperationParameters() == null) {
                pagesBuilder.appendNull();
            } else {
                pagesBuilder.appendVarcharVarcharMap(commitInfoEntry.getOperationParameters());
            }
            DeltaLakeHistoryTable.write(commitInfoEntry.getClusterId(), pagesBuilder);
            pagesBuilder.appendBigint(commitInfoEntry.getReadVersion());
            DeltaLakeHistoryTable.write(commitInfoEntry.getIsolationLevel(), pagesBuilder);
            commitInfoEntry.isBlindAppend().ifPresentOrElse(pagesBuilder::appendBoolean, pagesBuilder::appendNull);
            pagesBuilder.endRow();
        });
        return pagesBuilder.build();
    }

    private static void write(String value, PageListBuilder pagesBuilder) {
        if (value == null) {
            pagesBuilder.appendNull();
        } else {
            pagesBuilder.appendVarchar(value);
        }
    }
}

