/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Injector;
import io.airlift.bootstrap.LifeCycleManager;
import io.trino.plugin.base.classloader.ClassLoaderSafeConnectorMetadata;
import io.trino.plugin.base.session.SessionPropertiesProvider;
import io.trino.plugin.deltalake.DeltaLakeMetadata;
import io.trino.plugin.deltalake.DeltaLakeTransactionManager;
import io.trino.plugin.hive.HiveTransactionHandle;
import io.trino.spi.connector.Connector;
import io.trino.spi.connector.ConnectorAccessControl;
import io.trino.spi.connector.ConnectorCapabilities;
import io.trino.spi.connector.ConnectorMetadata;
import io.trino.spi.connector.ConnectorNodePartitioningProvider;
import io.trino.spi.connector.ConnectorPageSinkProvider;
import io.trino.spi.connector.ConnectorPageSourceProvider;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.connector.ConnectorSplitManager;
import io.trino.spi.connector.ConnectorTransactionHandle;
import io.trino.spi.connector.SystemTable;
import io.trino.spi.connector.TableProcedureMetadata;
import io.trino.spi.eventlistener.EventListener;
import io.trino.spi.function.FunctionProvider;
import io.trino.spi.function.table.ConnectorTableFunction;
import io.trino.spi.procedure.Procedure;
import io.trino.spi.session.PropertyMetadata;
import io.trino.spi.transaction.IsolationLevel;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class DeltaLakeConnector
implements Connector {
    private final Injector injector;
    private final LifeCycleManager lifeCycleManager;
    private final ConnectorSplitManager splitManager;
    private final ConnectorPageSourceProvider pageSourceProvider;
    private final ConnectorPageSinkProvider pageSinkProvider;
    private final ConnectorNodePartitioningProvider nodePartitioningProvider;
    private final Set<SystemTable> systemTables;
    private final Set<Procedure> procedures;
    private final Set<TableProcedureMetadata> tableProcedures;
    private final List<PropertyMetadata<?>> sessionProperties;
    private final List<PropertyMetadata<?>> schemaProperties;
    private final List<PropertyMetadata<?>> tableProperties;
    private final List<PropertyMetadata<?>> analyzeProperties;
    private final Optional<ConnectorAccessControl> accessControl;
    private final Set<EventListener> eventListeners;
    private final DeltaLakeTransactionManager transactionManager;
    private final Set<ConnectorTableFunction> tableFunctions;
    private final FunctionProvider functionProvider;

    public DeltaLakeConnector(Injector injector, LifeCycleManager lifeCycleManager, ConnectorSplitManager splitManager, ConnectorPageSourceProvider pageSourceProvider, ConnectorPageSinkProvider pageSinkProvider, ConnectorNodePartitioningProvider nodePartitioningProvider, Set<SystemTable> systemTables, Set<Procedure> procedures, Set<TableProcedureMetadata> tableProcedures, Set<SessionPropertiesProvider> sessionPropertiesProviders, List<PropertyMetadata<?>> schemaProperties, List<PropertyMetadata<?>> tableProperties, List<PropertyMetadata<?>> analyzeProperties, Optional<ConnectorAccessControl> accessControl, Set<EventListener> eventListeners, DeltaLakeTransactionManager transactionManager, Set<ConnectorTableFunction> tableFunctions, FunctionProvider functionProvider) {
        this.injector = Objects.requireNonNull(injector, "injector is null");
        this.lifeCycleManager = Objects.requireNonNull(lifeCycleManager, "lifeCycleManager is null");
        this.splitManager = Objects.requireNonNull(splitManager, "splitManager is null");
        this.pageSourceProvider = Objects.requireNonNull(pageSourceProvider, "pageSourceProvider is null");
        this.pageSinkProvider = Objects.requireNonNull(pageSinkProvider, "pageSinkProvider is null");
        this.nodePartitioningProvider = Objects.requireNonNull(nodePartitioningProvider, "nodePartitioningProvider is null");
        this.systemTables = ImmutableSet.copyOf((Collection)Objects.requireNonNull(systemTables, "systemTables is null"));
        this.procedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(procedures, "procedures is null"));
        this.tableProcedures = ImmutableSet.copyOf((Collection)Objects.requireNonNull(tableProcedures, "tableProcedures is null"));
        this.sessionProperties = (List)sessionPropertiesProviders.stream().map(SessionPropertiesProvider::getSessionProperties).flatMap(Collection::stream).collect(ImmutableList.toImmutableList());
        this.schemaProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(schemaProperties, "schemaProperties is null"));
        this.tableProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(tableProperties, "tableProperties is null"));
        this.analyzeProperties = ImmutableList.copyOf((Collection)Objects.requireNonNull(analyzeProperties, "analyzeProperties is null"));
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.eventListeners = ImmutableSet.copyOf((Collection)Objects.requireNonNull(eventListeners, "eventListeners is null"));
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.tableFunctions = ImmutableSet.copyOf((Collection)Objects.requireNonNull(tableFunctions, "tableFunctions is null"));
        this.functionProvider = Objects.requireNonNull(functionProvider, "functionProvider is null");
    }

    public ConnectorMetadata getMetadata(ConnectorSession session, ConnectorTransactionHandle transaction) {
        DeltaLakeMetadata metadata = this.transactionManager.get(transaction, session.getIdentity());
        return new ClassLoaderSafeConnectorMetadata((ConnectorMetadata)metadata, this.getClass().getClassLoader());
    }

    public ConnectorSplitManager getSplitManager() {
        return this.splitManager;
    }

    public ConnectorPageSourceProvider getPageSourceProvider() {
        return this.pageSourceProvider;
    }

    public ConnectorPageSinkProvider getPageSinkProvider() {
        return this.pageSinkProvider;
    }

    public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
        return this.nodePartitioningProvider;
    }

    public Set<SystemTable> getSystemTables() {
        return this.systemTables;
    }

    public Set<Procedure> getProcedures() {
        return this.procedures;
    }

    public Set<TableProcedureMetadata> getTableProcedures() {
        return this.tableProcedures;
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public List<PropertyMetadata<?>> getSchemaProperties() {
        return this.schemaProperties;
    }

    public List<PropertyMetadata<?>> getTableProperties() {
        return this.tableProperties;
    }

    public List<PropertyMetadata<?>> getAnalyzeProperties() {
        return this.analyzeProperties;
    }

    public ConnectorAccessControl getAccessControl() {
        return this.accessControl.orElseThrow(UnsupportedOperationException::new);
    }

    public Iterable<EventListener> getEventListeners() {
        return this.eventListeners;
    }

    public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly, boolean autoCommit) {
        IsolationLevel.checkConnectorSupports((IsolationLevel)IsolationLevel.READ_COMMITTED, (IsolationLevel)isolationLevel);
        HiveTransactionHandle transaction = new HiveTransactionHandle(true);
        this.transactionManager.begin((ConnectorTransactionHandle)transaction);
        return transaction;
    }

    public void commit(ConnectorTransactionHandle transaction) {
        this.transactionManager.commit(transaction);
    }

    public void rollback(ConnectorTransactionHandle transaction) {
        this.transactionManager.rollback(transaction);
    }

    public final void shutdown() {
        this.lifeCycleManager.stop();
    }

    public Set<ConnectorCapabilities> getCapabilities() {
        return Sets.immutableEnumSet((Enum)ConnectorCapabilities.NOT_NULL_COLUMN_CONSTRAINT, (Enum[])new ConnectorCapabilities[0]);
    }

    public Set<ConnectorTableFunction> getTableFunctions() {
        return this.tableFunctions;
    }

    public Optional<FunctionProvider> getFunctionProvider() {
        return Optional.of(this.functionProvider);
    }

    @VisibleForTesting
    public Injector getInjector() {
        return this.injector;
    }
}

