/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.deltalake;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.SizeOf;
import io.trino.plugin.deltalake.DeltaHiveTypeTranslator;
import io.trino.plugin.hive.HiveColumnProjectionInfo;
import io.trino.spi.type.Type;
import java.util.List;
import java.util.Objects;

public class DeltaLakeColumnProjectionInfo {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DeltaLakeColumnProjectionInfo.class);
    private final Type type;
    private final List<Integer> dereferenceIndices;
    private final List<String> dereferencePhysicalNames;

    @JsonCreator
    public DeltaLakeColumnProjectionInfo(@JsonProperty(value="type") Type type, @JsonProperty(value="dereferenceIndices") List<Integer> dereferenceIndices, @JsonProperty(value="dereferencePhysicalNames") List<String> dereferencePhysicalNames) {
        this.type = Objects.requireNonNull(type, "type is null");
        Objects.requireNonNull(dereferenceIndices, "dereferenceIndices is null");
        Objects.requireNonNull(dereferencePhysicalNames, "dereferencePhysicalNames is null");
        Preconditions.checkArgument((dereferenceIndices.size() > 0 ? 1 : 0) != 0, (Object)"dereferenceIndices should not be empty");
        Preconditions.checkArgument((dereferencePhysicalNames.size() > 0 ? 1 : 0) != 0, (Object)"dereferencePhysicalNames should not be empty");
        Preconditions.checkArgument((dereferenceIndices.size() == dereferencePhysicalNames.size() ? 1 : 0) != 0, (Object)"dereferenceIndices and dereferencePhysicalNames should have the same sizes");
        this.dereferenceIndices = ImmutableList.copyOf(dereferenceIndices);
        this.dereferencePhysicalNames = ImmutableList.copyOf(dereferencePhysicalNames);
    }

    @JsonProperty
    public Type getType() {
        return this.type;
    }

    @JsonProperty
    public List<Integer> getDereferenceIndices() {
        return this.dereferenceIndices;
    }

    @JsonProperty
    public List<String> getDereferencePhysicalNames() {
        return this.dereferencePhysicalNames;
    }

    @JsonIgnore
    public String getPartialName() {
        return String.join((CharSequence)"#", this.dereferencePhysicalNames);
    }

    @JsonIgnore
    public long getRetainedSizeInBytes() {
        return (long)INSTANCE_SIZE + SizeOf.estimatedSizeOf(this.dereferenceIndices, SizeOf::sizeOf) + SizeOf.estimatedSizeOf(this.dereferencePhysicalNames, SizeOf::estimatedSizeOf);
    }

    public HiveColumnProjectionInfo toHiveColumnProjectionInfo() {
        return new HiveColumnProjectionInfo(this.dereferenceIndices, this.dereferencePhysicalNames, DeltaHiveTypeTranslator.toHiveType(this.type), this.type);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeltaLakeColumnProjectionInfo that = (DeltaLakeColumnProjectionInfo)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.dereferenceIndices, that.dereferenceIndices) && Objects.equals(this.dereferencePhysicalNames, that.dereferencePhysicalNames);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.dereferenceIndices, this.dereferencePhysicalNames);
    }

    public String toString() {
        return this.getPartialName() + ":" + this.type.getDisplayName();
    }
}

