/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.datastax.oss.driver.api.core.metadata.token.Token;
import com.datastax.oss.driver.internal.core.metadata.token.RandomToken;
import com.google.common.base.Preconditions;
import io.trino.plugin.cassandra.TokenRing;
import java.math.BigInteger;

public final class RandomPartitionerTokenRing
implements TokenRing {
    public static final RandomPartitionerTokenRing INSTANCE = new RandomPartitionerTokenRing();
    private static final BigInteger MIN_TOKEN = BigInteger.valueOf(-1L);
    private static final BigInteger MAX_TOKEN = BigInteger.valueOf(2L).pow(127);
    private static final BigInteger TOTAL_TOKEN_COUNT = MAX_TOKEN.subtract(MIN_TOKEN);

    private RandomPartitionerTokenRing() {
    }

    @Override
    public double getRingFraction(Token start, Token end) {
        return this.getTokenCountInRange(start, end).doubleValue() / TOTAL_TOKEN_COUNT.doubleValue();
    }

    @Override
    public BigInteger getTokenCountInRange(Token startToken, Token endToken) {
        BigInteger start = ((RandomToken)startToken).getValue();
        RandomPartitionerTokenRing.checkTokenBounds(start);
        BigInteger end = ((RandomToken)endToken).getValue();
        RandomPartitionerTokenRing.checkTokenBounds(end);
        if (start.equals(end)) {
            if (start.equals(MIN_TOKEN)) {
                return TOTAL_TOKEN_COUNT;
            }
            return BigInteger.ZERO;
        }
        BigInteger result = end.subtract(start);
        if (end.compareTo(start) <= 0) {
            result = result.add(TOTAL_TOKEN_COUNT);
        }
        return result;
    }

    private static void checkTokenBounds(BigInteger token) {
        Preconditions.checkArgument((token.compareTo(MIN_TOKEN) >= 0 ? 1 : 0) != 0, (String)"token [%s] must be greater or equal than %s", (Object)token, (Object)MIN_TOKEN);
        Preconditions.checkArgument((token.compareTo(MAX_TOKEN) <= 0 ? 1 : 0) != 0, (String)"token [%s] must be less or equal than %s", (Object)token, (Object)MAX_TOKEN);
    }
}

