/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import io.trino.plugin.cassandra.CassandraClientConfig;
import io.trino.spi.connector.ConnectorSession;
import io.trino.spi.session.PropertyMetadata;
import java.util.List;
import java.util.Optional;

public final class CassandraSessionProperties {
    private static final String SPLITS_PER_NODE = "splits_per_node";
    private final List<PropertyMetadata<?>> sessionProperties;

    @Inject
    public CassandraSessionProperties(CassandraClientConfig cassandraClientConfig) {
        this.sessionProperties = ImmutableList.of((Object)PropertyMetadata.longProperty((String)SPLITS_PER_NODE, (String)"Number of splits per node. By default, the values from the system.size_estimates table are used. Only override when connecting to Cassandra versions < 2.1.5.", (Long)cassandraClientConfig.getSplitsPerNode().orElse(null), (boolean)false));
    }

    public List<PropertyMetadata<?>> getSessionProperties() {
        return this.sessionProperties;
    }

    public static Optional<Long> getSplitsPerNode(ConnectorSession session) {
        return Optional.ofNullable((Long)session.getProperty(SPLITS_PER_NODE, Long.class));
    }
}

