/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.cassandra;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.trino.plugin.cassandra.CassandraType;
import io.trino.plugin.cassandra.util.CassandraCqlUtils;
import io.trino.spi.connector.ColumnHandle;
import io.trino.spi.connector.ColumnMetadata;
import io.trino.spi.type.Type;
import java.util.Objects;

public class CassandraColumnHandle
implements ColumnHandle {
    private final String name;
    private final int ordinalPosition;
    private final CassandraType cassandraType;
    private final boolean partitionKey;
    private final boolean clusteringKey;
    private final boolean indexed;
    private final boolean hidden;

    @JsonCreator
    public CassandraColumnHandle(@JsonProperty(value="name") String name, @JsonProperty(value="ordinalPosition") int ordinalPosition, @JsonProperty(value="cassandraType") CassandraType cassandraType, @JsonProperty(value="partitionKey") boolean partitionKey, @JsonProperty(value="clusteringKey") boolean clusteringKey, @JsonProperty(value="indexed") boolean indexed, @JsonProperty(value="hidden") boolean hidden) {
        this.name = Objects.requireNonNull(name, "name is null");
        Preconditions.checkArgument((ordinalPosition >= 0 ? 1 : 0) != 0, (Object)"ordinalPosition is negative");
        this.ordinalPosition = ordinalPosition;
        this.cassandraType = Objects.requireNonNull(cassandraType, "cassandraType is null");
        this.partitionKey = partitionKey;
        this.clusteringKey = clusteringKey;
        this.indexed = indexed;
        this.hidden = hidden;
    }

    @JsonProperty
    public String getName() {
        return this.name;
    }

    @JsonProperty
    public int getOrdinalPosition() {
        return this.ordinalPosition;
    }

    @JsonProperty
    public CassandraType getCassandraType() {
        return this.cassandraType;
    }

    @JsonProperty
    public boolean isPartitionKey() {
        return this.partitionKey;
    }

    @JsonProperty
    public boolean isClusteringKey() {
        return this.clusteringKey;
    }

    @JsonProperty
    public boolean isIndexed() {
        return this.indexed;
    }

    @JsonProperty
    public boolean isHidden() {
        return this.hidden;
    }

    public ColumnMetadata getColumnMetadata() {
        return ColumnMetadata.builder().setName(CassandraCqlUtils.cqlNameToSqlName(this.name)).setType(this.cassandraType.getTrinoType()).setHidden(this.hidden).build();
    }

    public Type getType() {
        return this.cassandraType.getTrinoType();
    }

    public int hashCode() {
        return Objects.hash(this.name, this.ordinalPosition, this.cassandraType, this.partitionKey, this.clusteringKey, this.indexed, this.hidden);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        CassandraColumnHandle other = (CassandraColumnHandle)obj;
        return Objects.equals(this.name, other.name) && Objects.equals(this.ordinalPosition, other.ordinalPosition) && Objects.equals(this.cassandraType, other.cassandraType) && Objects.equals(this.partitionKey, other.partitionKey) && Objects.equals(this.clusteringKey, other.clusteringKey) && Objects.equals(this.indexed, other.indexed) && Objects.equals(this.hidden, other.hidden);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("ordinalPosition", this.ordinalPosition).add("cassandraType", (Object)this.cassandraType).add("partitionKey", this.partitionKey).add("clusteringKey", this.clusteringKey).add("indexed", this.indexed).add("hidden", this.hidden).toString();
    }
}

