/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.type;

import com.google.common.base.Preconditions;
import java.util.Locale;

public class Decimal {
    public static final Decimal ZERO = new Decimal(0L, 2);
    public static final Decimal ONE_HALF = new Decimal(50L, 2);
    public static final Decimal NINE_PERCENT = new Decimal(9L, 2);
    public static final Decimal ONE_HUNDRED = new Decimal(10000L, 2);
    public static final Decimal ONE = new Decimal(100L, 2);
    private final int precision;
    private final long number;

    public Decimal(long number, int precision) {
        Preconditions.checkArgument((precision >= 0 ? 1 : 0) != 0, (Object)"precision must be greater than or equal to zero");
        this.precision = precision;
        this.number = number;
    }

    public static Decimal parseDecimal(String decimalString) {
        int precision;
        long number;
        int decimalPointIndex = decimalString.indexOf(46);
        if (decimalPointIndex == -1) {
            number = Integer.parseInt(decimalString);
            precision = 0;
        } else {
            String fractional = decimalString.substring(decimalPointIndex + 1);
            precision = fractional.length();
            number = Integer.parseInt(decimalString.substring(0, decimalPointIndex) + fractional);
        }
        return new Decimal(number, precision);
    }

    public static Decimal add(Decimal decimal1, Decimal decimal2) {
        int precision = decimal1.precision > decimal2.precision ? decimal1.precision : decimal2.precision;
        long number = decimal1.number + decimal2.number;
        return new Decimal(number, precision);
    }

    public static Decimal subtract(Decimal decimal1, Decimal decimal2) {
        int precision = decimal1.precision > decimal2.precision ? decimal1.precision : decimal2.precision;
        long number = decimal1.number - decimal2.number;
        return new Decimal(number, precision);
    }

    public static Decimal multiply(Decimal decimal1, Decimal decimal2) {
        int precision = decimal1.precision > decimal2.precision ? decimal1.precision : decimal2.precision;
        long number = decimal1.number * decimal2.number;
        for (int i = decimal1.precision + decimal2.precision; i > precision; --i) {
            number /= 10L;
        }
        return new Decimal(number, precision);
    }

    public static Decimal divide(Decimal decimal1, Decimal decimal2) {
        int i;
        float f1 = decimal1.number;
        int precision = decimal1.precision > decimal2.precision ? decimal1.precision : decimal2.precision;
        for (i = decimal1.precision; i < precision; ++i) {
            f1 = (float)((double)f1 * 10.0);
        }
        for (i = 0; i < precision; ++i) {
            f1 = (float)((double)f1 * 10.0);
        }
        float f2 = decimal2.number;
        for (int i2 = decimal2.precision; i2 < precision; ++i2) {
            f2 = (float)((double)f2 * 10.0);
        }
        int number = (int)(f1 / f2);
        return new Decimal(number, precision);
    }

    public static Decimal negate(Decimal decimal) {
        return new Decimal(decimal.number * -1L, decimal.precision);
    }

    public static Decimal fromInteger(int from) {
        return new Decimal(from, 0);
    }

    public int getPrecision() {
        return this.precision;
    }

    public long getNumber() {
        return this.number;
    }

    public String toString() {
        double temp = this.number;
        for (int i = 0; i < this.precision; ++i) {
            temp /= 10.0;
        }
        return String.format(Locale.ENGLISH, "%." + this.precision + "f", temp);
    }
}

