/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.JoinKeyUtils;
import io.trino.tpcds.Nulls;
import io.trino.tpcds.Scaling;
import io.trino.tpcds.Session;
import io.trino.tpcds.SlowlyChangingDimensionUtils;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.WebPageUseDistribution;
import io.trino.tpcds.generator.WebPageGeneratorColumn;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.WebPageRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import io.trino.tpcds.type.Date;
import java.util.Optional;

public class WebPageRowGenerator
extends AbstractRowGenerator {
    private static final int WP_AUTOGEN_PERCENT = 30;
    private Optional<WebPageRow> previousRow = Optional.empty();

    public WebPageRowGenerator() {
        super(Table.WEB_PAGE);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        boolean wpAutogenFlag;
        Scaling scaling = session.getScaling();
        long nullBitMap = Nulls.createNullBitMap(Table.WEB_PAGE, this.getRandomNumberStream(WebPageGeneratorColumn.WP_NULLS));
        long wpPageSk = rowNumber;
        SlowlyChangingDimensionUtils.SlowlyChangingDimensionKey slowlyChangingDimensionKey = SlowlyChangingDimensionUtils.computeScdKey(Table.WEB_PAGE, rowNumber);
        String wpPageId = slowlyChangingDimensionKey.getBusinessKey();
        long wpRecStartDateId = slowlyChangingDimensionKey.getStartDate();
        long wpRecStartEndDateId = slowlyChangingDimensionKey.getEndDate();
        boolean isNewKey = slowlyChangingDimensionKey.isNewBusinessKey();
        int fieldChangeFlags = (int)this.getRandomNumberStream(WebPageGeneratorColumn.WP_SCD).nextRandom();
        long wpCreationDateSk = JoinKeyUtils.generateJoinKey(WebPageGeneratorColumn.WP_CREATION_DATE_SK, this.getRandomNumberStream(WebPageGeneratorColumn.WP_CREATION_DATE_SK), Table.DATE_DIM, rowNumber, scaling);
        if (this.previousRow.isPresent()) {
            wpCreationDateSk = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewKey, this.previousRow.get().getWpCreationDateSk(), wpCreationDateSk);
        }
        fieldChangeFlags >>= 1;
        int lastAccess = RandomValueGenerator.generateUniformRandomInt(0, 100, this.getRandomNumberStream(WebPageGeneratorColumn.WP_ACCESS_DATE_SK));
        long wpAccessDateSk = Date.JULIAN_TODAYS_DATE - lastAccess;
        if (this.previousRow.isPresent()) {
            wpAccessDateSk = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewKey, this.previousRow.get().getWpAccessDateSk(), wpAccessDateSk);
        }
        fieldChangeFlags >>= 1;
        int randomInt = RandomValueGenerator.generateUniformRandomInt(0, 99, this.getRandomNumberStream(WebPageGeneratorColumn.WP_AUTOGEN_FLAG));
        boolean bl = wpAutogenFlag = randomInt < 30;
        if (this.previousRow.isPresent()) {
            wpAutogenFlag = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewKey, this.previousRow.get().getWpAutogenFlag(), wpAutogenFlag);
        }
        fieldChangeFlags >>= 1;
        long wpCustomersk = JoinKeyUtils.generateJoinKey(WebPageGeneratorColumn.WP_CUSTOMER_SK, this.getRandomNumberStream(WebPageGeneratorColumn.WP_CUSTOMER_SK), Table.CUSTOMER, 1L, scaling);
        if (this.previousRow.isPresent()) {
            wpCustomersk = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewKey, this.previousRow.get().getWpCustomerSk(), wpCustomersk);
        }
        fieldChangeFlags >>= 1;
        String wpUrl = RandomValueGenerator.generateRandomUrl(this.getRandomNumberStream(WebPageGeneratorColumn.WP_URL));
        fieldChangeFlags >>= 1;
        String wpType = WebPageUseDistribution.pickRandomWebPageUseType(this.getRandomNumberStream(WebPageGeneratorColumn.WP_TYPE));
        fieldChangeFlags >>= 1;
        int wpLinkCount = RandomValueGenerator.generateUniformRandomInt(2, 25, this.getRandomNumberStream(WebPageGeneratorColumn.WP_LINK_COUNT));
        if (this.previousRow.isPresent()) {
            wpLinkCount = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewKey, this.previousRow.get().getWpLinkCount(), wpLinkCount);
        }
        fieldChangeFlags >>= 1;
        int wpImageCount = RandomValueGenerator.generateUniformRandomInt(1, 7, this.getRandomNumberStream(WebPageGeneratorColumn.WP_IMAGE_COUNT));
        if (this.previousRow.isPresent()) {
            wpImageCount = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewKey, this.previousRow.get().getWpImageCount(), wpImageCount);
        }
        fieldChangeFlags >>= 1;
        int wpMaxAdCount = RandomValueGenerator.generateUniformRandomInt(0, 4, this.getRandomNumberStream(WebPageGeneratorColumn.WP_MAX_AD_COUNT));
        if (this.previousRow.isPresent()) {
            wpMaxAdCount = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewKey, this.previousRow.get().getWpMaxAdCount(), wpMaxAdCount);
        }
        fieldChangeFlags >>= 1;
        int wpCharCount = RandomValueGenerator.generateUniformRandomInt(wpLinkCount * 125 + wpImageCount * 50, wpLinkCount * 300 + wpImageCount * 150, this.getRandomNumberStream(WebPageGeneratorColumn.WP_CHAR_COUNT));
        if (this.previousRow.isPresent()) {
            wpCharCount = SlowlyChangingDimensionUtils.getValueForSlowlyChangingDimension(fieldChangeFlags, isNewKey, this.previousRow.get().getWpCharCount(), wpCharCount);
        }
        this.previousRow = Optional.of(new WebPageRow(nullBitMap, wpPageSk, wpPageId, wpRecStartDateId, wpRecStartEndDateId, wpCreationDateSk, wpAccessDateSk, wpAutogenFlag, wpCustomersk, wpUrl, wpType, wpCharCount, wpLinkCount, wpImageCount, wpMaxAdCount));
        return new RowGeneratorResult(new WebPageRow(nullBitMap, wpPageSk, wpPageId, wpRecStartDateId, wpRecStartEndDateId, wpCreationDateSk, wpAccessDateSk, wpAutogenFlag, wpAutogenFlag ? wpCustomersk : -1L, wpUrl, wpType, wpCharCount, wpLinkCount, wpImageCount, wpMaxAdCount));
    }
}

