/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.BusinessKeyGenerator;
import io.trino.tpcds.JoinKeyUtils;
import io.trino.tpcds.Nulls;
import io.trino.tpcds.Scaling;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.AddressDistributions;
import io.trino.tpcds.distribution.NamesDistributions;
import io.trino.tpcds.generator.CustomerGeneratorColumn;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.CustomerRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import io.trino.tpcds.type.Date;

public class CustomerRowGenerator
extends AbstractRowGenerator {
    public CustomerRowGenerator() {
        super(Table.CUSTOMER);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        int cPreferredPercent;
        long cCustomerSk = rowNumber;
        String cCustomerId = BusinessKeyGenerator.makeBusinessKey(rowNumber);
        int randomInt = RandomValueGenerator.generateUniformRandomInt(1, 100, this.getRandomNumberStream(CustomerGeneratorColumn.C_PREFERRED_CUST_FLAG));
        boolean cPreferredCustFlag = randomInt < (cPreferredPercent = 50);
        Scaling scaling = session.getScaling();
        long cCurrentHdemoSk = JoinKeyUtils.generateJoinKey(CustomerGeneratorColumn.C_CURRENT_HDEMO_SK, this.getRandomNumberStream(CustomerGeneratorColumn.C_CURRENT_HDEMO_SK), Table.HOUSEHOLD_DEMOGRAPHICS, 1L, scaling);
        long cCurrentCdemoSk = JoinKeyUtils.generateJoinKey(CustomerGeneratorColumn.C_CURRENT_CDEMO_SK, this.getRandomNumberStream(CustomerGeneratorColumn.C_CURRENT_CDEMO_SK), Table.CUSTOMER_DEMOGRAPHICS, 1L, scaling);
        long cCurrentAddrSk = JoinKeyUtils.generateJoinKey(CustomerGeneratorColumn.C_CURRENT_ADDR_SK, this.getRandomNumberStream(CustomerGeneratorColumn.C_CURRENT_ADDR_SK), Table.CUSTOMER_ADDRESS, cCustomerSk, scaling);
        int nameIndex = NamesDistributions.pickRandomIndex(NamesDistributions.FirstNamesWeights.GENERAL_FREQUENCY, this.getRandomNumberStream(CustomerGeneratorColumn.C_FIRST_NAME));
        String cFirstName = NamesDistributions.getFirstNameFromIndex(nameIndex);
        String cLastName = NamesDistributions.pickRandomLastName(this.getRandomNumberStream(CustomerGeneratorColumn.C_LAST_NAME));
        int femaleNameWeight = NamesDistributions.getWeightForIndex(nameIndex, NamesDistributions.FirstNamesWeights.FEMALE_FREQUENCY);
        String cSalutation = NamesDistributions.pickRandomSalutation(femaleNameWeight == 0 ? NamesDistributions.SalutationsWeights.MALE : NamesDistributions.SalutationsWeights.FEMALE, this.getRandomNumberStream(CustomerGeneratorColumn.C_SALUTATION));
        Date maxBirthday = new Date(1992, 12, 31);
        Date minBirthday = new Date(1924, 1, 1);
        Date oneYearAgo = Date.fromJulianDays(Date.JULIAN_TODAYS_DATE - 365);
        Date tenYearsAgo = Date.fromJulianDays(Date.JULIAN_TODAYS_DATE - 3650);
        Date today = Date.fromJulianDays(Date.JULIAN_TODAYS_DATE);
        Date birthday = RandomValueGenerator.generateUniformRandomDate(minBirthday, maxBirthday, this.getRandomNumberStream(CustomerGeneratorColumn.C_BIRTH_DAY));
        int cBirthDay = birthday.getDay();
        int cBirthMonth = birthday.getMonth();
        int cBirthYear = birthday.getYear();
        String cEmailAddress = RandomValueGenerator.generateRandomEmail(cFirstName, cLastName, this.getRandomNumberStream(CustomerGeneratorColumn.C_EMAIL_ADDRESS));
        Date lastReviewDate = RandomValueGenerator.generateUniformRandomDate(oneYearAgo, today, this.getRandomNumberStream(CustomerGeneratorColumn.C_LAST_REVIEW_DATE));
        int cLastReviewDate = Date.toJulianDays(lastReviewDate);
        Date firstSalesDate = RandomValueGenerator.generateUniformRandomDate(tenYearsAgo, today, this.getRandomNumberStream(CustomerGeneratorColumn.C_FIRST_SALES_DATE_ID));
        int cFirstSalesDateId = Date.toJulianDays(firstSalesDate);
        int cFirstShiptoDateId = cFirstSalesDateId + 30;
        String cBirthCountry = AddressDistributions.pickRandomCountry(this.getRandomNumberStream(CustomerGeneratorColumn.C_BIRTH_COUNTRY));
        return new RowGeneratorResult(new CustomerRow(cCustomerSk, cCustomerId, cCurrentCdemoSk, cCurrentHdemoSk, cCurrentAddrSk, cFirstShiptoDateId, cFirstSalesDateId, cSalutation, cFirstName, cLastName, cPreferredCustFlag, cBirthDay, cBirthMonth, cBirthYear, cBirthCountry, cEmailAddress, cLastReviewDate, Nulls.createNullBitMap(Table.CUSTOMER, this.getRandomNumberStream(CustomerGeneratorColumn.C_NULLS))));
    }
}

