/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import io.trino.tpcds.BusinessKeyGenerator;
import io.trino.tpcds.Nulls;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.distribution.LocationTypesDistribution;
import io.trino.tpcds.generator.CustomerAddressGeneratorColumn;
import io.trino.tpcds.row.CustomerAddressRow;
import io.trino.tpcds.row.generator.AbstractRowGenerator;
import io.trino.tpcds.row.generator.RowGenerator;
import io.trino.tpcds.row.generator.RowGeneratorResult;
import io.trino.tpcds.type.Address;

public class CustomerAddressRowGenerator
extends AbstractRowGenerator {
    public CustomerAddressRowGenerator() {
        super(Table.CUSTOMER_ADDRESS);
    }

    @Override
    public RowGeneratorResult generateRowAndChildRows(long rowNumber, Session session, RowGenerator parentRowGenerator, RowGenerator childRowGenerator) {
        long nullBitMap = Nulls.createNullBitMap(Table.CUSTOMER_ADDRESS, this.getRandomNumberStream(CustomerAddressGeneratorColumn.CA_NULLS));
        long caAddrSk = rowNumber;
        String caAddrId = BusinessKeyGenerator.makeBusinessKey(rowNumber);
        Address caAddr = Address.makeAddressForColumn(Table.CUSTOMER_ADDRESS, this.getRandomNumberStream(CustomerAddressGeneratorColumn.CA_ADDRESS), session.getScaling());
        String caLocationType = LocationTypesDistribution.pickRandomLocationType(this.getRandomNumberStream(CustomerAddressGeneratorColumn.CA_LOCATION_TYPE), LocationTypesDistribution.LocationTypeWeights.UNIFORM);
        return new RowGeneratorResult(new CustomerAddressRow(nullBitMap, caAddrSk, caAddrId, caAddr, caLocationType));
    }
}

