/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row.generator;

import com.google.common.collect.ImmutableMap;
import io.trino.tpcds.Table;
import io.trino.tpcds.generator.GeneratorColumn;
import io.trino.tpcds.random.RandomNumberStream;
import io.trino.tpcds.random.RandomNumberStreamImpl;
import io.trino.tpcds.random.RandomValueGenerator;
import io.trino.tpcds.row.generator.RowGenerator;

public abstract class AbstractRowGenerator
implements RowGenerator {
    private final ImmutableMap<GeneratorColumn, RandomNumberStream> randomNumberStreamMap;

    public AbstractRowGenerator(Table table) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (GeneratorColumn column : table.getGeneratorColumns()) {
            mapBuilder.put((Object)column, (Object)new RandomNumberStreamImpl(column.getGlobalColumnNumber(), column.getSeedsPerRow()));
        }
        this.randomNumberStreamMap = mapBuilder.build();
    }

    @Override
    public void consumeRemainingSeedsForRow() {
        for (RandomNumberStream randomNumberStream : this.randomNumberStreamMap.values()) {
            while (randomNumberStream.getSeedsUsed() < randomNumberStream.getSeedsPerRow()) {
                RandomValueGenerator.generateUniformRandomInt(1, 100, randomNumberStream);
            }
            randomNumberStream.resetSeedsUsed();
        }
    }

    @Override
    public void skipRowsUntilStartingRowNumber(long startingRowNumber) {
        for (RandomNumberStream randomNumberStream : this.randomNumberStreamMap.values()) {
            randomNumberStream.skipRows((int)startingRowNumber - 1);
        }
    }

    public RandomNumberStream getRandomNumberStream(GeneratorColumn column) {
        return (RandomNumberStream)this.randomNumberStreamMap.get((Object)column);
    }
}

