/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row;

import com.google.common.collect.Lists;
import io.trino.tpcds.generator.WebSiteGeneratorColumn;
import io.trino.tpcds.row.TableRowWithNulls;
import io.trino.tpcds.type.Address;
import io.trino.tpcds.type.Decimal;
import java.util.List;

public class WebSiteRow
extends TableRowWithNulls {
    private final long webSiteSk;
    private final String webSiteId;
    private final long webRecStartDateId;
    private final long webRecEndDateId;
    private final String webName;
    private final long webOpenDate;
    private final long webCloseDate;
    private final String webClass;
    private final String webManager;
    private final int webMarketId;
    private final String webMarketClass;
    private final String webMarketDesc;
    private final String webMarketManager;
    private final int webCompanyId;
    private final String webCompanyName;
    private final Address webAddress;
    private final Decimal webTaxPercentage;

    public WebSiteRow(long nullBitMap, long webSiteSk, String webSiteId, long webRecStartDateId, long webRecEndDateId, String webName, long webOpenDate, long webCloseDate, String webClass, String webManager, int webMarketId, String webMarketClass, String webMarketDesc, String webMarketManager, int webCompanyId, String webCompanyName, Address webAddress, Decimal webTaxPercentage) {
        super(nullBitMap, WebSiteGeneratorColumn.WEB_SITE_SK);
        this.webSiteSk = webSiteSk;
        this.webSiteId = webSiteId;
        this.webRecStartDateId = webRecStartDateId;
        this.webRecEndDateId = webRecEndDateId;
        this.webName = webName;
        this.webOpenDate = webOpenDate;
        this.webCloseDate = webCloseDate;
        this.webClass = webClass;
        this.webManager = webManager;
        this.webMarketId = webMarketId;
        this.webMarketClass = webMarketClass;
        this.webMarketDesc = webMarketDesc;
        this.webMarketManager = webMarketManager;
        this.webCompanyId = webCompanyId;
        this.webCompanyName = webCompanyName;
        this.webAddress = webAddress;
        this.webTaxPercentage = webTaxPercentage;
    }

    public String getWebName() {
        return this.webName;
    }

    public long getWebOpenDate() {
        return this.webOpenDate;
    }

    public long getWebCloseDate() {
        return this.webCloseDate;
    }

    public String getWebClass() {
        return this.webClass;
    }

    public String getWebManager() {
        return this.webManager;
    }

    public int getWebMarketId() {
        return this.webMarketId;
    }

    public String getWebMarketClass() {
        return this.webMarketClass;
    }

    public String getWebMarketDesc() {
        return this.webMarketDesc;
    }

    public String getWebMarketManager() {
        return this.webMarketManager;
    }

    public int getWebCompanyId() {
        return this.webCompanyId;
    }

    public String getWebCompanyName() {
        return this.webCompanyName;
    }

    public Address getWebAddress() {
        return this.webAddress;
    }

    public Decimal getWebTaxPercentage() {
        return this.webTaxPercentage;
    }

    @Override
    public List<String> getValues() {
        return Lists.newArrayList((Object[])new String[]{this.getStringOrNullForKey(this.webSiteSk, WebSiteGeneratorColumn.WEB_SITE_SK), this.getStringOrNull(this.webSiteId, WebSiteGeneratorColumn.WEB_SITE_ID), this.getDateStringOrNullFromJulianDays(this.webRecStartDateId, WebSiteGeneratorColumn.WEB_REC_START_DATE_ID), this.getDateStringOrNullFromJulianDays(this.webRecEndDateId, WebSiteGeneratorColumn.WEB_REC_END_DATE_ID), this.getStringOrNull(this.webName, WebSiteGeneratorColumn.WEB_NAME), this.getStringOrNullForKey(this.webOpenDate, WebSiteGeneratorColumn.WEB_OPEN_DATE), this.getStringOrNullForKey(this.webCloseDate, WebSiteGeneratorColumn.WEB_CLOSE_DATE), this.getStringOrNull(this.webClass, WebSiteGeneratorColumn.WEB_CLASS), this.getStringOrNull(this.webManager, WebSiteGeneratorColumn.WEB_MANAGER), this.getStringOrNull(this.webMarketId, WebSiteGeneratorColumn.WEB_MARKET_ID), this.getStringOrNull(this.webMarketClass, WebSiteGeneratorColumn.WEB_MARKET_CLASS), this.getStringOrNull(this.webMarketDesc, WebSiteGeneratorColumn.WEB_MARKET_DESC), this.getStringOrNull(this.webMarketManager, WebSiteGeneratorColumn.WEB_MARKET_MANAGER), this.getStringOrNull(this.webCompanyId, WebSiteGeneratorColumn.WEB_COMPANY_ID), this.getStringOrNull(this.webCompanyName, WebSiteGeneratorColumn.WEB_COMPANY_NAME), this.getStringOrNull(this.webAddress.getStreetNumber(), WebSiteGeneratorColumn.WEB_ADDRESS_STREET_NUM), this.getStringOrNull(this.webAddress.getStreetName(), WebSiteGeneratorColumn.WEB_ADDRESS_STREET_NAME1), this.getStringOrNull(this.webAddress.getStreetType(), WebSiteGeneratorColumn.WEB_ADDRESS_STREET_TYPE), this.getStringOrNull(this.webAddress.getSuiteNumber(), WebSiteGeneratorColumn.WEB_ADDRESS_SUITE_NUM), this.getStringOrNull(this.webAddress.getCity(), WebSiteGeneratorColumn.WEB_ADDRESS_CITY), this.getStringOrNull(this.webAddress.getCounty(), WebSiteGeneratorColumn.WEB_ADDRESS_COUNTY), this.getStringOrNull(this.webAddress.getState(), WebSiteGeneratorColumn.WEB_ADDRESS_STATE), this.getStringOrNull(String.format("%05d", this.webAddress.getZip()), WebSiteGeneratorColumn.WEB_ADDRESS_ZIP), this.getStringOrNull(this.webAddress.getCountry(), WebSiteGeneratorColumn.WEB_ADDRESS_COUNTRY), this.getStringOrNull(this.webAddress.getGmtOffset(), WebSiteGeneratorColumn.WEB_ADDRESS_GMT_OFFSET), this.getStringOrNull(this.webTaxPercentage, WebSiteGeneratorColumn.WEB_TAX_PERCENTAGE)});
    }
}

