/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row;

import com.google.common.collect.Lists;
import io.trino.tpcds.generator.WarehouseGeneratorColumn;
import io.trino.tpcds.row.TableRowWithNulls;
import io.trino.tpcds.type.Address;
import java.util.List;

public class WarehouseRow
extends TableRowWithNulls {
    private final long wWarehouseSk;
    private final String wWarehouseId;
    private final String wWarehouseName;
    private final int wWarehouseSqFt;
    private final Address wAddress;

    public WarehouseRow(long nullBitMap, long wWarehouseSk, String wWarehouseId, String wWarehouseName, int wWarehouseSqFt, Address wAddress) {
        super(nullBitMap, WarehouseGeneratorColumn.W_WAREHOUSE_SK);
        this.wWarehouseSk = wWarehouseSk;
        this.wWarehouseId = wWarehouseId;
        this.wWarehouseName = wWarehouseName;
        this.wWarehouseSqFt = wWarehouseSqFt;
        this.wAddress = wAddress;
    }

    @Override
    public List<String> getValues() {
        return Lists.newArrayList((Object[])new String[]{this.getStringOrNullForKey(this.wWarehouseSk, WarehouseGeneratorColumn.W_WAREHOUSE_SK), this.getStringOrNull(this.wWarehouseId, WarehouseGeneratorColumn.W_WAREHOUSE_ID), this.getStringOrNull(this.wWarehouseName, WarehouseGeneratorColumn.W_WAREHOUSE_NAME), this.getStringOrNull(this.wWarehouseSqFt, WarehouseGeneratorColumn.W_WAREHOUSE_SQ_FT), this.getStringOrNull(this.wAddress.getStreetNumber(), WarehouseGeneratorColumn.W_ADDRESS_STREET_NUM), this.getStringOrNull(this.wAddress.getStreetName(), WarehouseGeneratorColumn.W_ADDRESS_STREET_NAME1), this.getStringOrNull(this.wAddress.getStreetType(), WarehouseGeneratorColumn.W_ADDRESS_STREET_TYPE), this.getStringOrNull(this.wAddress.getSuiteNumber(), WarehouseGeneratorColumn.W_ADDRESS_SUITE_NUM), this.getStringOrNull(this.wAddress.getCity(), WarehouseGeneratorColumn.W_ADDRESS_CITY), this.getStringOrNull(this.wAddress.getCounty(), WarehouseGeneratorColumn.W_ADDRESS_COUNTY), this.getStringOrNull(this.wAddress.getState(), WarehouseGeneratorColumn.W_ADDRESS_STATE), this.getStringOrNull(String.format("%05d", this.wAddress.getZip()), WarehouseGeneratorColumn.W_ADDRESS_ZIP), this.getStringOrNull(this.wAddress.getCountry(), WarehouseGeneratorColumn.W_ADDRESS_COUNTRY), this.getStringOrNull(this.wAddress.getGmtOffset(), WarehouseGeneratorColumn.W_ADDRESS_GMT_OFFSET)});
    }
}

