/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row;

import com.google.common.collect.Lists;
import io.trino.tpcds.generator.DateDimGeneratorColumn;
import io.trino.tpcds.row.TableRowWithNulls;
import java.util.List;

public class DateDimRow
extends TableRowWithNulls {
    private final long dDateSk;
    private final String dDateId;
    private final int dMonthSeq;
    private final int dWeekSeq;
    private final int dQuarterSeq;
    private final int dYear;
    private final int dDow;
    private final int dMoy;
    private final int dDom;
    private final int dQoy;
    private final int dFyYear;
    private final int dFyQuarterSeq;
    private final int dFyWeekSeq;
    private final String dDayName;
    private final boolean dHoliday;
    private final boolean dWeekend;
    private final boolean dFollowingHoliday;
    private final int dFirstDom;
    private final int dLastDom;
    private final int dSameDayLy;
    private final int dSameDayLq;
    private final boolean dCurrentDay;
    private final boolean dCurrentWeek;
    private final boolean dCurrentMonth;
    private final boolean dCurrentQuarter;
    private final boolean dCurrentYear;

    public DateDimRow(long nullBitMap, long dDateSk, String dDateId, int dMonthSeq, int dWeekSeq, int dQuarterSeq, int dYear, int dDow, int dMoy, int dDom, int dQoy, int dFyYear, int dFyQuarterSeq, int dFyWeekSeq, String dDayName, boolean dHoliday, boolean dWeekend, boolean dFollowingHoliday, int dFirstDom, int dLastDom, int dSameDayLy, int dSameDayLq, boolean dCurrentDay, boolean dCurrentWeek, boolean dCurrentMonth, boolean dCurrentQuarter, boolean dCurrentYear) {
        super(nullBitMap, DateDimGeneratorColumn.D_DATE_SK);
        this.dDateSk = dDateSk;
        this.dDateId = dDateId;
        this.dMonthSeq = dMonthSeq;
        this.dWeekSeq = dWeekSeq;
        this.dQuarterSeq = dQuarterSeq;
        this.dYear = dYear;
        this.dDow = dDow;
        this.dMoy = dMoy;
        this.dDom = dDom;
        this.dQoy = dQoy;
        this.dFyYear = dFyYear;
        this.dFyQuarterSeq = dFyQuarterSeq;
        this.dFyWeekSeq = dFyWeekSeq;
        this.dDayName = dDayName;
        this.dHoliday = dHoliday;
        this.dWeekend = dWeekend;
        this.dFollowingHoliday = dFollowingHoliday;
        this.dFirstDom = dFirstDom;
        this.dLastDom = dLastDom;
        this.dSameDayLy = dSameDayLy;
        this.dSameDayLq = dSameDayLq;
        this.dCurrentDay = dCurrentDay;
        this.dCurrentWeek = dCurrentWeek;
        this.dCurrentMonth = dCurrentMonth;
        this.dCurrentQuarter = dCurrentQuarter;
        this.dCurrentYear = dCurrentYear;
    }

    @Override
    public List<String> getValues() {
        return Lists.newArrayList((Object[])new String[]{this.getStringOrNullForKey(this.dDateSk, DateDimGeneratorColumn.D_DATE_SK), this.getStringOrNull(this.dDateId, DateDimGeneratorColumn.D_DATE_ID), this.getDateStringOrNullFromJulianDays(this.dDateSk, DateDimGeneratorColumn.D_DATE_SK), this.getStringOrNull(this.dMonthSeq, DateDimGeneratorColumn.D_MONTH_SEQ), this.getStringOrNull(this.dWeekSeq, DateDimGeneratorColumn.D_WEEK_SEQ), this.getStringOrNull(this.dQuarterSeq, DateDimGeneratorColumn.D_QUARTER_SEQ), this.getStringOrNull(this.dYear, DateDimGeneratorColumn.D_YEAR), this.getStringOrNull(this.dDow, DateDimGeneratorColumn.D_DOW), this.getStringOrNull(this.dMoy, DateDimGeneratorColumn.D_MOY), this.getStringOrNull(this.dDom, DateDimGeneratorColumn.D_DOM), this.getStringOrNull(this.dQoy, DateDimGeneratorColumn.D_QOY), this.getStringOrNull(this.dFyYear, DateDimGeneratorColumn.D_FY_YEAR), this.getStringOrNull(this.dFyQuarterSeq, DateDimGeneratorColumn.D_FY_QUARTER_SEQ), this.getStringOrNull(this.dFyWeekSeq, DateDimGeneratorColumn.D_FY_WEEK_SEQ), this.getStringOrNull(this.dDayName, DateDimGeneratorColumn.D_DAY_NAME), this.getStringOrNull(String.format("%4dQ%d", this.dYear, this.dQoy), DateDimGeneratorColumn.D_QUARTER_NAME), this.getStringOrNullForBoolean(this.dHoliday, DateDimGeneratorColumn.D_HOLIDAY), this.getStringOrNullForBoolean(this.dWeekend, DateDimGeneratorColumn.D_WEEKEND), this.getStringOrNullForBoolean(this.dFollowingHoliday, DateDimGeneratorColumn.D_FOLLOWING_HOLIDAY), this.getStringOrNull(this.dFirstDom, DateDimGeneratorColumn.D_FIRST_DOM), this.getStringOrNull(this.dLastDom, DateDimGeneratorColumn.D_LAST_DOM), this.getStringOrNull(this.dSameDayLy, DateDimGeneratorColumn.D_SAME_DAY_LY), this.getStringOrNull(this.dSameDayLq, DateDimGeneratorColumn.D_SAME_DAY_LQ), this.getStringOrNullForBoolean(this.dCurrentDay, DateDimGeneratorColumn.D_CURRENT_DAY), this.getStringOrNullForBoolean(this.dCurrentWeek, DateDimGeneratorColumn.D_CURRENT_WEEK), this.getStringOrNullForBoolean(this.dCurrentMonth, DateDimGeneratorColumn.D_CURRENT_MONTH), this.getStringOrNullForBoolean(this.dCurrentQuarter, DateDimGeneratorColumn.D_CURRENT_QUARTER), this.getStringOrNullForBoolean(this.dCurrentYear, DateDimGeneratorColumn.D_CURRENT_YEAR)});
    }
}

