/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.row;

import com.google.common.collect.Lists;
import io.trino.tpcds.generator.CallCenterGeneratorColumn;
import io.trino.tpcds.row.TableRowWithNulls;
import io.trino.tpcds.type.Address;
import io.trino.tpcds.type.Decimal;
import java.util.List;

public class CallCenterRow
extends TableRowWithNulls {
    private final long ccCallCenterSk;
    private final String ccCallCenterId;
    private final long ccRecStartDateId;
    private final long ccRecEndDateId;
    private final long ccClosedDateId;
    private final long ccOpenDateId;
    private final String ccName;
    private final String ccClass;
    private final int ccEmployees;
    private final int ccSqFt;
    private final String ccHours;
    private final String ccManager;
    private final int ccMarketId;
    private final String ccMarketClass;
    private final String ccMarketDesc;
    private final String ccMarketManager;
    private final int ccDivisionId;
    private final String ccDivisionName;
    private final int ccCompany;
    private final String ccCompanyName;
    private final Address ccAddress;
    private final Decimal ccTaxPercentage;

    private CallCenterRow(long ccCallCenterSk, String ccCallCenterId, long ccRecStartDateId, long ccRecEndDateId, long ccClosedDateId, long ccOpenDateId, String ccName, String ccClass, int ccEmployees, int ccSqFt, String ccHours, String ccManager, int ccMarketId, String ccMarketClass, String ccMarketDesc, String ccMarketManager, int ccDivisionId, String ccDivisionName, int ccCompany, String ccCompanyName, Address ccAddress, Decimal ccTaxPercentage, long nullBitMap) {
        super(nullBitMap, CallCenterGeneratorColumn.CC_CALL_CENTER_SK);
        this.ccCallCenterSk = ccCallCenterSk;
        this.ccCallCenterId = ccCallCenterId;
        this.ccRecStartDateId = ccRecStartDateId;
        this.ccRecEndDateId = ccRecEndDateId;
        this.ccClosedDateId = ccClosedDateId;
        this.ccOpenDateId = ccOpenDateId;
        this.ccName = ccName;
        this.ccClass = ccClass;
        this.ccEmployees = ccEmployees;
        this.ccSqFt = ccSqFt;
        this.ccHours = ccHours;
        this.ccManager = ccManager;
        this.ccMarketId = ccMarketId;
        this.ccMarketClass = ccMarketClass;
        this.ccMarketDesc = ccMarketDesc;
        this.ccMarketManager = ccMarketManager;
        this.ccDivisionId = ccDivisionId;
        this.ccDivisionName = ccDivisionName;
        this.ccCompany = ccCompany;
        this.ccCompanyName = ccCompanyName;
        this.ccAddress = ccAddress;
        this.ccTaxPercentage = ccTaxPercentage;
    }

    public long getCcCallCenterSk() {
        return this.ccCallCenterSk;
    }

    public String getCcCallCenterId() {
        return this.ccCallCenterId;
    }

    public long getCcRecStartDateId() {
        return this.ccRecStartDateId;
    }

    public long getCcRecEndDateId() {
        return this.ccRecEndDateId;
    }

    public long getCcClosedDateId() {
        return this.ccClosedDateId;
    }

    public long getCcOpenDateId() {
        return this.ccOpenDateId;
    }

    public String getCcName() {
        return this.ccName;
    }

    public String getCcClass() {
        return this.ccClass;
    }

    public int getCcEmployees() {
        return this.ccEmployees;
    }

    public int getCcSqFt() {
        return this.ccSqFt;
    }

    public String getCcHours() {
        return this.ccHours;
    }

    public String getCcManager() {
        return this.ccManager;
    }

    public int getCcMarketId() {
        return this.ccMarketId;
    }

    public String getCcMarketClass() {
        return this.ccMarketClass;
    }

    public String getCcMarketDesc() {
        return this.ccMarketDesc;
    }

    public String getCcMarketManager() {
        return this.ccMarketManager;
    }

    public int getCcDivisionId() {
        return this.ccDivisionId;
    }

    public String getCcDivisionName() {
        return this.ccDivisionName;
    }

    public int getCcCompany() {
        return this.ccCompany;
    }

    public String getCcCompanyName() {
        return this.ccCompanyName;
    }

    public Address getCcAddress() {
        return this.ccAddress;
    }

    public Decimal getCcTaxPercentage() {
        return this.ccTaxPercentage;
    }

    @Override
    public List<String> getValues() {
        return Lists.newArrayList((Object[])new String[]{this.getStringOrNullForKey(this.ccCallCenterSk, CallCenterGeneratorColumn.CC_CALL_CENTER_SK), this.getStringOrNull(this.ccCallCenterId, CallCenterGeneratorColumn.CC_CALL_CENTER_ID), this.getDateStringOrNullFromJulianDays(this.ccRecStartDateId, CallCenterGeneratorColumn.CC_REC_START_DATE_ID), this.getDateStringOrNullFromJulianDays(this.ccRecEndDateId, CallCenterGeneratorColumn.CC_REC_END_DATE_ID), this.getStringOrNullForKey(this.ccClosedDateId, CallCenterGeneratorColumn.CC_CLOSED_DATE_ID), this.getStringOrNullForKey(this.ccOpenDateId, CallCenterGeneratorColumn.CC_OPEN_DATE_ID), this.getStringOrNull(this.ccName, CallCenterGeneratorColumn.CC_NAME), this.getStringOrNull(this.ccClass, CallCenterGeneratorColumn.CC_CLASS), this.getStringOrNull(this.ccEmployees, CallCenterGeneratorColumn.CC_EMPLOYEES), this.getStringOrNull(this.ccSqFt, CallCenterGeneratorColumn.CC_SQ_FT), this.getStringOrNull(this.ccHours, CallCenterGeneratorColumn.CC_HOURS), this.getStringOrNull(this.ccManager, CallCenterGeneratorColumn.CC_MANAGER), this.getStringOrNull(this.ccMarketId, CallCenterGeneratorColumn.CC_MARKET_ID), this.getStringOrNull(this.ccMarketClass, CallCenterGeneratorColumn.CC_MARKET_CLASS), this.getStringOrNull(this.ccMarketDesc, CallCenterGeneratorColumn.CC_MARKET_DESC), this.getStringOrNull(this.ccMarketManager, CallCenterGeneratorColumn.CC_MARKET_MANAGER), this.getStringOrNull(this.ccDivisionId, CallCenterGeneratorColumn.CC_DIVISION), this.getStringOrNull(this.ccDivisionName, CallCenterGeneratorColumn.CC_DIVISION_NAME), this.getStringOrNull(this.ccCompany, CallCenterGeneratorColumn.CC_COMPANY), this.getStringOrNull(this.ccCompanyName, CallCenterGeneratorColumn.CC_COMPANY_NAME), this.getStringOrNull(this.ccAddress.getStreetNumber(), CallCenterGeneratorColumn.CC_STREET_NUMBER), this.getStringOrNull(this.ccAddress.getStreetName(), CallCenterGeneratorColumn.CC_STREET_NAME), this.getStringOrNull(this.ccAddress.getStreetType(), CallCenterGeneratorColumn.CC_STREET_TYPE), this.getStringOrNull(this.ccAddress.getSuiteNumber(), CallCenterGeneratorColumn.CC_SUITE_NUMBER), this.getStringOrNull(this.ccAddress.getCity(), CallCenterGeneratorColumn.CC_CITY), this.getStringOrNull(this.ccAddress.getCounty(), CallCenterGeneratorColumn.CC_ADDRESS), this.getStringOrNull(this.ccAddress.getState(), CallCenterGeneratorColumn.CC_STATE), this.getStringOrNull(String.format("%05d", this.ccAddress.getZip()), CallCenterGeneratorColumn.CC_ZIP), this.getStringOrNull(this.ccAddress.getCountry(), CallCenterGeneratorColumn.CC_COUNTRY), this.getStringOrNull(this.ccAddress.getGmtOffset(), CallCenterGeneratorColumn.CC_GMT_OFFSET), this.getStringOrNull(this.ccTaxPercentage, CallCenterGeneratorColumn.CC_TAX_PERCENTAGE)});
    }

    public static class Builder {
        private long ccCallCenterSk;
        private String ccCallCenterId;
        private long ccRecStartDateId;
        private long ccRecEndDateId;
        private long ccClosedDateId;
        private long ccOpenDateId;
        private String ccName;
        private String ccClass;
        private int ccEmployees;
        private int ccSqFt;
        private String ccHours;
        private String ccManager;
        private int ccMarketId;
        private String ccMarketClass;
        private String ccMarketDesc;
        private String ccMarketManager;
        private int ccDivisionId;
        private String ccDivisionName;
        private int ccCompany;
        private String ccCompanyName;
        private Address ccAddress;
        private Decimal ccTaxPercentage;
        private long nullBitMap;

        public Builder setCcCallCenterSk(long ccCallCenterSk) {
            this.ccCallCenterSk = ccCallCenterSk;
            return this;
        }

        public Builder setCcCallCenterId(String ccCallCenterId) {
            this.ccCallCenterId = ccCallCenterId;
            return this;
        }

        public Builder setCcRecStartDateId(long ccRecStartDateId) {
            this.ccRecStartDateId = ccRecStartDateId;
            return this;
        }

        public Builder setCcRecEndDateId(long ccRecEndDateId) {
            this.ccRecEndDateId = ccRecEndDateId;
            return this;
        }

        public Builder setCcClosedDateId(long ccClosedDateId) {
            this.ccClosedDateId = ccClosedDateId;
            return this;
        }

        public Builder setCcOpenDateId(long ccOpenDateId) {
            this.ccOpenDateId = ccOpenDateId;
            return this;
        }

        public Builder setCcName(String ccName) {
            this.ccName = ccName;
            return this;
        }

        public Builder setCcClass(String ccClass) {
            this.ccClass = ccClass;
            return this;
        }

        public Builder setCcEmployees(int ccEmployees) {
            this.ccEmployees = ccEmployees;
            return this;
        }

        public Builder setCcSqFt(int ccSqFt) {
            this.ccSqFt = ccSqFt;
            return this;
        }

        public Builder setCcHours(String ccHours) {
            this.ccHours = ccHours;
            return this;
        }

        public Builder setCcManager(String ccManager) {
            this.ccManager = ccManager;
            return this;
        }

        public Builder setCcMarketId(int ccMarketId) {
            this.ccMarketId = ccMarketId;
            return this;
        }

        public Builder setCcMarketClass(String ccMarketClass) {
            this.ccMarketClass = ccMarketClass;
            return this;
        }

        public Builder setCcMarketDesc(String ccMarketDesc) {
            this.ccMarketDesc = ccMarketDesc;
            return this;
        }

        public Builder setCcMarketManager(String ccMarketManager) {
            this.ccMarketManager = ccMarketManager;
            return this;
        }

        public Builder setCcDivisionId(int ccDivisionId) {
            this.ccDivisionId = ccDivisionId;
            return this;
        }

        public Builder setCcDivisionName(String ccDivisionName) {
            this.ccDivisionName = ccDivisionName;
            return this;
        }

        public Builder setCcCompany(int ccCompany) {
            this.ccCompany = ccCompany;
            return this;
        }

        public Builder setCcCompanyName(String ccCompanyName) {
            this.ccCompanyName = ccCompanyName;
            return this;
        }

        public Builder setCcAddress(Address ccAddress) {
            this.ccAddress = ccAddress;
            return this;
        }

        public Builder setCcTaxPercentage(Decimal ccTaxPercentage) {
            this.ccTaxPercentage = ccTaxPercentage;
            return this;
        }

        public CallCenterRow build() {
            return new CallCenterRow(this.ccCallCenterSk, this.ccCallCenterId, this.ccRecStartDateId, this.ccRecEndDateId, this.ccClosedDateId, this.ccOpenDateId, this.ccName, this.ccClass, this.ccEmployees, this.ccSqFt, this.ccHours, this.ccManager, this.ccMarketId, this.ccMarketClass, this.ccMarketDesc, this.ccMarketManager, this.ccDivisionId, this.ccDivisionName, this.ccCompany, this.ccCompanyName, this.ccAddress, this.ccTaxPercentage, this.nullBitMap);
        }

        public void setNullBitMap(long nullBitMap) {
            this.nullBitMap = nullBitMap;
        }
    }
}

