/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds.random;

import com.google.common.base.Preconditions;
import io.trino.tpcds.random.RandomNumberStream;

public class RandomNumberStreamImpl
implements RandomNumberStream {
    private static final int DEFAULT_SEED_BASE = 19620718;
    private static final int MULTIPLIER = 16807;
    private static final int QUOTIENT = 127773;
    private static final int REMAINDER = 2836;
    private long seed;
    private final long initialSeed;
    private int seedsUsed;
    private final int seedsPerRow;

    public RandomNumberStreamImpl(int seedsPerRow) {
        Preconditions.checkArgument((seedsPerRow >= 0 ? 1 : 0) != 0, (Object)"seedsPerRow must be >=0");
        this.initialSeed = 3L;
        this.seed = 3L;
        this.seedsPerRow = seedsPerRow;
    }

    public RandomNumberStreamImpl(int globalColumnNumber, int seedsPerRow) {
        this(globalColumnNumber, 19620718, seedsPerRow);
    }

    public RandomNumberStreamImpl(int globalColumnNumber, int seedBase, int seedsPerRow) {
        Preconditions.checkArgument((seedsPerRow >= 0 ? 1 : 0) != 0, (Object)"seedsPerRow must be >=0");
        this.seed = this.initialSeed = (long)(seedBase + globalColumnNumber * 2687714);
        this.seedsPerRow = seedsPerRow;
    }

    @Override
    public long nextRandom() {
        long nextSeed = this.seed;
        long modResult = nextSeed % 127773L;
        long divisionResult = nextSeed / 127773L;
        if ((nextSeed = 16807L * modResult - divisionResult * 2836L) < 0L) {
            nextSeed += Integer.MAX_VALUE;
        }
        this.seed = nextSeed;
        ++this.seedsUsed;
        return this.seed;
    }

    @Override
    public double nextRandomDouble() {
        return (double)this.nextRandom() / 2.147483647E9;
    }

    @Override
    public void skipRows(long numberOfRows) {
        long nextSeed = this.initialSeed;
        long multiplier = 16807L;
        for (long numberOfValuesToSkip = numberOfRows * (long)this.seedsPerRow; numberOfValuesToSkip > 0L; numberOfValuesToSkip /= 2L) {
            if (numberOfValuesToSkip % 2L != 0L) {
                nextSeed = multiplier * nextSeed % Integer.MAX_VALUE;
            }
            multiplier = multiplier * multiplier % Integer.MAX_VALUE;
        }
        this.seed = nextSeed;
        this.seedsUsed = 0;
    }

    @Override
    public void resetSeed() {
        this.seed = this.initialSeed;
        this.seedsUsed = 0;
    }

    @Override
    public int getSeedsUsed() {
        return this.seedsUsed;
    }

    @Override
    public void resetSeedsUsed() {
        this.seedsUsed = 0;
    }

    @Override
    public int getSeedsPerRow() {
        return this.seedsPerRow;
    }
}

