/*
 * Decompiled with CFR 0.152.
 */
package io.trino.tpcds;

import com.google.common.collect.ImmutableList;
import io.airlift.airline.Command;
import io.airlift.airline.HelpOption;
import io.airlift.airline.SingleCommand;
import io.trino.tpcds.Options;
import io.trino.tpcds.Session;
import io.trino.tpcds.Table;
import io.trino.tpcds.TableGenerator;
import java.util.List;
import javax.inject.Inject;

@Command(name="dsdgen", description="data generator for TPC-DS")
public class Driver {
    @Inject
    public HelpOption helpOption;
    @Inject
    public Options options = new Options();

    public static void main(String[] args) {
        Driver driver = (Driver)SingleCommand.singleCommand(Driver.class).parse(args);
        driver.run();
    }

    private void run() {
        if (this.helpOption.showHelpIfRequested()) {
            return;
        }
        Session session = this.options.toSession();
        ImmutableList tablesToGenerate = session.generateOnlyOneTable() ? ImmutableList.of((Object)((Object)session.getOnlyTableToGenerate())) : Table.getBaseTables();
        int i = 1;
        while (i <= session.getParallelism()) {
            int chunkNumber = i++;
            new Thread(() -> Driver.lambda$run$0(session, chunkNumber, (List)tablesToGenerate)).start();
        }
    }

    private static /* synthetic */ void lambda$run$0(Session session, int chunkNumber, List tablesToGenerate) {
        TableGenerator tableGenerator = new TableGenerator(session.withChunkNumber(chunkNumber));
        tablesToGenerate.forEach(tableGenerator::generateTable);
    }
}

