/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model.types;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.JsonUnwrapped;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.Content;
import org.projectnessie.model.types.GenericContent;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@Generated(from="GenericContent", generator="Immutables")
@Immutable
public final class ImmutableGenericContent
extends GenericContent {
    private final Content.Type type;
    @Nullable
    private final String id;
    @Nullable
    private final Map<String, Object> attributes;

    private ImmutableGenericContent(Content.Type type, @Nullable String id, @Nullable Map<String, ? extends Object> attributes) {
        this.type = Objects.requireNonNull(type, "type");
        this.id = id;
        this.attributes = attributes == null ? null : ImmutableGenericContent.createUnmodifiableMap(true, false, attributes);
    }

    private ImmutableGenericContent(ImmutableGenericContent original, Content.Type type, @Nullable String id, @Nullable Map<String, Object> attributes) {
        this.type = type;
        this.id = id;
        this.attributes = attributes;
    }

    @Override
    @JsonProperty(value="type")
    public Content.Type getType() {
        return this.type;
    }

    @Override
    @JsonProperty(value="id")
    @Nullable
    public String getId() {
        return this.id;
    }

    @Override
    @JsonProperty(value="attributes")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonUnwrapped
    @Nullable
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public final ImmutableGenericContent withType(Content.Type value) {
        if (this.type == value) {
            return this;
        }
        Content.Type newValue = Objects.requireNonNull(value, "type");
        return new ImmutableGenericContent(this, newValue, this.id, this.attributes);
    }

    public final ImmutableGenericContent withId(@Nullable String value) {
        if (Objects.equals(this.id, value)) {
            return this;
        }
        return new ImmutableGenericContent(this, this.type, value, this.attributes);
    }

    public final ImmutableGenericContent withAttributes(@Nullable Map<String, ? extends Object> entries) {
        if (this.attributes == entries) {
            return this;
        }
        Map<String, Object> newValue = entries == null ? null : ImmutableGenericContent.createUnmodifiableMap(true, false, entries);
        return new ImmutableGenericContent(this, this.type, this.id, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGenericContent && this.equalTo(0, (ImmutableGenericContent)another);
    }

    private boolean equalTo(int synthetic, ImmutableGenericContent another) {
        return this.type.equals(another.type) && Objects.equals(this.id, another.id) && Objects.equals(this.attributes, another.attributes);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.type.hashCode();
        h += (h << 5) + Objects.hashCode(this.id);
        h += (h << 5) + Objects.hashCode(this.attributes);
        return h;
    }

    public String toString() {
        return "GenericContent{type=" + this.type + ", id=" + this.id + ", attributes=" + this.attributes + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableGenericContent fromJson(Json json) {
        Builder builder = ImmutableGenericContent.builder();
        if (json.type != null) {
            builder.type(json.type);
        }
        if (json.id != null) {
            builder.id(json.id);
        }
        if (json.attributes != null) {
            builder.putAllAttributes(json.attributes);
        }
        return builder.build();
    }

    public static ImmutableGenericContent of(Content.Type type, @Nullable String id, @Nullable Map<String, ? extends Object> attributes) {
        return new ImmutableGenericContent(type, id, attributes);
    }

    public static ImmutableGenericContent copyOf(GenericContent instance) {
        if (instance instanceof ImmutableGenericContent) {
            return (ImmutableGenericContent)instance;
        }
        return ImmutableGenericContent.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Generated(from="GenericContent", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_TYPE = 1L;
        private long initBits = 1L;
        @javax.annotation.Nullable
        private Content.Type type;
        @javax.annotation.Nullable
        private String id;
        private Map<String, Object> attributes = null;

        private Builder() {
        }

        public final Builder from(Content instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(GenericContent instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Map<String, Object> attributesValue;
            Content instance;
            if (object instanceof Content) {
                instance = (Content)object;
                this.type(instance.getType());
                String idValue = instance.getId();
                if (idValue != null) {
                    this.id(idValue);
                }
            }
            if (object instanceof GenericContent && (attributesValue = ((GenericContent)(instance = (GenericContent)object)).getAttributes()) != null) {
                this.putAllAttributes(attributesValue);
            }
        }

        @JsonProperty(value="type")
        public final Builder type(Content.Type type) {
            this.type = Objects.requireNonNull(type, "type");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="id")
        public final Builder id(@Nullable String id) {
            this.id = id;
            return this;
        }

        public final Builder putAttributes(String key, Object value) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>();
            }
            this.attributes.put(Objects.requireNonNull(key, "attributes key"), value == null ? Objects.requireNonNull(value, "attributes value for key: " + key) : value);
            return this;
        }

        public final Builder putAttributes(Map.Entry<String, ? extends Object> entry) {
            Object v;
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>();
            }
            String k = entry.getKey();
            this.attributes.put(Objects.requireNonNull(k, "attributes key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "attributes value for key: " + k) : v);
            return this;
        }

        @JsonProperty(value="attributes")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonUnwrapped
        public final Builder attributes(@Nullable Map<String, ? extends Object> entries) {
            if (entries == null) {
                this.attributes = null;
                return this;
            }
            this.attributes = new LinkedHashMap<String, Object>();
            return this.putAllAttributes(entries);
        }

        public final Builder putAllAttributes(Map<String, ? extends Object> entries) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, Object>();
            }
            for (Map.Entry<String, ? extends Object> e : entries.entrySet()) {
                Object v;
                String k = e.getKey();
                this.attributes.put(Objects.requireNonNull(k, "attributes key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "attributes value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableGenericContent build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGenericContent(null, this.type, this.id, this.attributes == null ? null : ImmutableGenericContent.createUnmodifiableMap(false, false, this.attributes));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("type");
            }
            return "Cannot build GenericContent, some of required attributes are not set " + attributes;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Deprecated
    @JsonDeserialize
    @JsonTypeInfo(use=JsonTypeInfo.Id.NONE)
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="GenericContent", generator="Immutables")
    static final class Json
    extends GenericContent {
        @javax.annotation.Nullable
        Content.Type type;
        @javax.annotation.Nullable
        String id;
        @javax.annotation.Nullable
        Map<String, Object> attributes = null;

        Json() {
        }

        @JsonProperty(value="type")
        public void setType(Content.Type type) {
            this.type = type;
        }

        @JsonProperty(value="id")
        public void setId(@Nullable String id) {
            this.id = id;
        }

        @JsonProperty(value="attributes")
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonUnwrapped
        public void setAttributes(@Nullable Map<String, Object> attributes) {
            this.attributes = attributes;
        }

        @Override
        public Content.Type getType() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getId() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, Object> getAttributes() {
            throw new UnsupportedOperationException();
        }
    }
}

