/*
 * Decompiled with CFR 0.152.
 */
package org.projectnessie.model;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonView;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import jakarta.annotation.Nullable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.projectnessie.model.CommitMeta;
import org.projectnessie.model.NessieConfiguration;
import org.projectnessie.model.ser.Views;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
@ParametersAreNonnullByDefault
@Generated(from="NessieConfiguration", generator="Immutables")
@Immutable
public final class ImmutableNessieConfiguration
extends NessieConfiguration {
    @Nullable
    private final String defaultBranch;
    private final int minSupportedApiVersion;
    private final int maxSupportedApiVersion;
    private final int actualApiVersion;
    @Nullable
    private final String specVersion;
    @Nullable
    private final String noAncestorHash;
    @Nullable
    private final Instant repositoryCreationTimestamp;
    @Nullable
    private final Instant oldestPossibleCommitTimestamp;
    private final Map<String, String> additionalProperties;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableNessieConfiguration(Builder builder) {
        this.defaultBranch = builder.defaultBranch;
        this.maxSupportedApiVersion = builder.maxSupportedApiVersion;
        this.specVersion = builder.specVersion;
        this.noAncestorHash = builder.noAncestorHash;
        this.repositoryCreationTimestamp = builder.repositoryCreationTimestamp;
        this.oldestPossibleCommitTimestamp = builder.oldestPossibleCommitTimestamp;
        this.additionalProperties = ImmutableNessieConfiguration.createUnmodifiableMap(false, false, builder.additionalProperties);
        if (builder.minSupportedApiVersionIsSet()) {
            this.initShim.minSupportedApiVersion(builder.minSupportedApiVersion);
        }
        if (builder.actualApiVersionIsSet()) {
            this.initShim.actualApiVersion(builder.actualApiVersion);
        }
        this.minSupportedApiVersion = this.initShim.getMinSupportedApiVersion();
        this.actualApiVersion = this.initShim.getActualApiVersion();
        this.initShim = null;
    }

    private ImmutableNessieConfiguration(@Nullable String defaultBranch, int minSupportedApiVersion, int maxSupportedApiVersion, int actualApiVersion, @Nullable String specVersion, @Nullable String noAncestorHash, @Nullable Instant repositoryCreationTimestamp, @Nullable Instant oldestPossibleCommitTimestamp, Map<String, String> additionalProperties) {
        this.defaultBranch = defaultBranch;
        this.minSupportedApiVersion = minSupportedApiVersion;
        this.maxSupportedApiVersion = maxSupportedApiVersion;
        this.actualApiVersion = actualApiVersion;
        this.specVersion = specVersion;
        this.noAncestorHash = noAncestorHash;
        this.repositoryCreationTimestamp = repositoryCreationTimestamp;
        this.oldestPossibleCommitTimestamp = oldestPossibleCommitTimestamp;
        this.additionalProperties = additionalProperties;
        this.initShim = null;
    }

    @Override
    @JsonProperty(value="defaultBranch")
    @Nullable
    public String getDefaultBranch() {
        return this.defaultBranch;
    }

    @Override
    @JsonProperty(value="minSupportedApiVersion")
    @JsonView(value={Views.V2.class})
    public int getMinSupportedApiVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getMinSupportedApiVersion() : this.minSupportedApiVersion;
    }

    @Override
    @JsonProperty(value="maxSupportedApiVersion")
    public int getMaxSupportedApiVersion() {
        return this.maxSupportedApiVersion;
    }

    @Override
    @JsonProperty(value="actualApiVersion")
    @JsonView(value={Views.V2.class})
    public int getActualApiVersion() {
        InitShim shim = this.initShim;
        return shim != null ? shim.getActualApiVersion() : this.actualApiVersion;
    }

    @Override
    @JsonProperty(value="specVersion")
    @JsonView(value={Views.V2.class})
    @Nullable
    public String getSpecVersion() {
        return this.specVersion;
    }

    @Override
    @JsonProperty(value="noAncestorHash")
    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @Nullable
    public String getNoAncestorHash() {
        return this.noAncestorHash;
    }

    @Override
    @JsonProperty(value="repositoryCreationTimestamp")
    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
    @Nullable
    public Instant getRepositoryCreationTimestamp() {
        return this.repositoryCreationTimestamp;
    }

    @Override
    @JsonProperty(value="oldestPossibleCommitTimestamp")
    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonSerialize(using=CommitMeta.InstantSerializer.class)
    @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
    @Nullable
    public Instant getOldestPossibleCommitTimestamp() {
        return this.oldestPossibleCommitTimestamp;
    }

    @Override
    @JsonProperty(value="additionalProperties")
    @JsonView(value={Views.V2.class})
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public Map<String, String> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public final ImmutableNessieConfiguration withDefaultBranch(@Nullable String value) {
        if (Objects.equals(this.defaultBranch, value)) {
            return this;
        }
        return new ImmutableNessieConfiguration(value, this.minSupportedApiVersion, this.maxSupportedApiVersion, this.actualApiVersion, this.specVersion, this.noAncestorHash, this.repositoryCreationTimestamp, this.oldestPossibleCommitTimestamp, this.additionalProperties);
    }

    public final ImmutableNessieConfiguration withMinSupportedApiVersion(int value) {
        if (this.minSupportedApiVersion == value) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, value, this.maxSupportedApiVersion, this.actualApiVersion, this.specVersion, this.noAncestorHash, this.repositoryCreationTimestamp, this.oldestPossibleCommitTimestamp, this.additionalProperties);
    }

    public final ImmutableNessieConfiguration withMaxSupportedApiVersion(int value) {
        if (this.maxSupportedApiVersion == value) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, this.minSupportedApiVersion, value, this.actualApiVersion, this.specVersion, this.noAncestorHash, this.repositoryCreationTimestamp, this.oldestPossibleCommitTimestamp, this.additionalProperties);
    }

    public final ImmutableNessieConfiguration withActualApiVersion(int value) {
        if (this.actualApiVersion == value) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, this.minSupportedApiVersion, this.maxSupportedApiVersion, value, this.specVersion, this.noAncestorHash, this.repositoryCreationTimestamp, this.oldestPossibleCommitTimestamp, this.additionalProperties);
    }

    public final ImmutableNessieConfiguration withSpecVersion(@Nullable String value) {
        if (Objects.equals(this.specVersion, value)) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, this.minSupportedApiVersion, this.maxSupportedApiVersion, this.actualApiVersion, value, this.noAncestorHash, this.repositoryCreationTimestamp, this.oldestPossibleCommitTimestamp, this.additionalProperties);
    }

    public final ImmutableNessieConfiguration withNoAncestorHash(@Nullable String value) {
        if (Objects.equals(this.noAncestorHash, value)) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, this.minSupportedApiVersion, this.maxSupportedApiVersion, this.actualApiVersion, this.specVersion, value, this.repositoryCreationTimestamp, this.oldestPossibleCommitTimestamp, this.additionalProperties);
    }

    public final ImmutableNessieConfiguration withRepositoryCreationTimestamp(@Nullable Instant value) {
        if (this.repositoryCreationTimestamp == value) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, this.minSupportedApiVersion, this.maxSupportedApiVersion, this.actualApiVersion, this.specVersion, this.noAncestorHash, value, this.oldestPossibleCommitTimestamp, this.additionalProperties);
    }

    public final ImmutableNessieConfiguration withOldestPossibleCommitTimestamp(@Nullable Instant value) {
        if (this.oldestPossibleCommitTimestamp == value) {
            return this;
        }
        return new ImmutableNessieConfiguration(this.defaultBranch, this.minSupportedApiVersion, this.maxSupportedApiVersion, this.actualApiVersion, this.specVersion, this.noAncestorHash, this.repositoryCreationTimestamp, value, this.additionalProperties);
    }

    public final ImmutableNessieConfiguration withAdditionalProperties(Map<String, ? extends String> entries) {
        if (this.additionalProperties == entries) {
            return this;
        }
        Map<String, String> newValue = ImmutableNessieConfiguration.createUnmodifiableMap(true, false, entries);
        return new ImmutableNessieConfiguration(this.defaultBranch, this.minSupportedApiVersion, this.maxSupportedApiVersion, this.actualApiVersion, this.specVersion, this.noAncestorHash, this.repositoryCreationTimestamp, this.oldestPossibleCommitTimestamp, newValue);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableNessieConfiguration && this.equalTo(0, (ImmutableNessieConfiguration)another);
    }

    private boolean equalTo(int synthetic, ImmutableNessieConfiguration another) {
        return Objects.equals(this.defaultBranch, another.defaultBranch) && this.minSupportedApiVersion == another.minSupportedApiVersion && this.maxSupportedApiVersion == another.maxSupportedApiVersion && this.actualApiVersion == another.actualApiVersion && Objects.equals(this.specVersion, another.specVersion) && Objects.equals(this.noAncestorHash, another.noAncestorHash) && Objects.equals(this.repositoryCreationTimestamp, another.repositoryCreationTimestamp) && Objects.equals(this.oldestPossibleCommitTimestamp, another.oldestPossibleCommitTimestamp) && this.additionalProperties.equals(another.additionalProperties);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.defaultBranch);
        h += (h << 5) + this.minSupportedApiVersion;
        h += (h << 5) + this.maxSupportedApiVersion;
        h += (h << 5) + this.actualApiVersion;
        h += (h << 5) + Objects.hashCode(this.specVersion);
        h += (h << 5) + Objects.hashCode(this.noAncestorHash);
        h += (h << 5) + Objects.hashCode(this.repositoryCreationTimestamp);
        h += (h << 5) + Objects.hashCode(this.oldestPossibleCommitTimestamp);
        h += (h << 5) + this.additionalProperties.hashCode();
        return h;
    }

    public String toString() {
        return "NessieConfiguration{defaultBranch=" + this.defaultBranch + ", minSupportedApiVersion=" + this.minSupportedApiVersion + ", maxSupportedApiVersion=" + this.maxSupportedApiVersion + ", actualApiVersion=" + this.actualApiVersion + ", specVersion=" + this.specVersion + ", noAncestorHash=" + this.noAncestorHash + ", repositoryCreationTimestamp=" + this.repositoryCreationTimestamp + ", oldestPossibleCommitTimestamp=" + this.oldestPossibleCommitTimestamp + ", additionalProperties=" + this.additionalProperties + "}";
    }

    @Deprecated
    @JsonCreator(mode=JsonCreator.Mode.DELEGATING)
    static ImmutableNessieConfiguration fromJson(Json json) {
        Builder builder = ImmutableNessieConfiguration.builder();
        if (json.defaultBranch != null) {
            builder.defaultBranch(json.defaultBranch);
        }
        if (json.minSupportedApiVersionIsSet) {
            builder.minSupportedApiVersion(json.minSupportedApiVersion);
        }
        if (json.maxSupportedApiVersionIsSet) {
            builder.maxSupportedApiVersion(json.maxSupportedApiVersion);
        }
        if (json.actualApiVersionIsSet) {
            builder.actualApiVersion(json.actualApiVersion);
        }
        if (json.specVersion != null) {
            builder.specVersion(json.specVersion);
        }
        if (json.noAncestorHash != null) {
            builder.noAncestorHash(json.noAncestorHash);
        }
        if (json.repositoryCreationTimestamp != null) {
            builder.repositoryCreationTimestamp(json.repositoryCreationTimestamp);
        }
        if (json.oldestPossibleCommitTimestamp != null) {
            builder.oldestPossibleCommitTimestamp(json.oldestPossibleCommitTimestamp);
        }
        if (json.additionalProperties != null) {
            builder.putAllAdditionalProperties(json.additionalProperties);
        }
        return builder.build();
    }

    public static ImmutableNessieConfiguration copyOf(NessieConfiguration instance) {
        if (instance instanceof ImmutableNessieConfiguration) {
            return (ImmutableNessieConfiguration)instance;
        }
        return ImmutableNessieConfiguration.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <K, V> Map<K, V> createUnmodifiableMap(boolean checkNulls, boolean skipNulls, Map<? extends K, ? extends V> map) {
        switch (map.size()) {
            case 0: {
                return Collections.emptyMap();
            }
            case 1: {
                Map.Entry<K, V> e = map.entrySet().iterator().next();
                K k = e.getKey();
                V v = e.getValue();
                if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                if (skipNulls && (k == null || v == null)) {
                    return Collections.emptyMap();
                }
                return Collections.singletonMap(k, v);
            }
        }
        LinkedHashMap<K, V> linkedMap = new LinkedHashMap<K, V>(map.size());
        if (skipNulls || checkNulls) {
            for (Map.Entry<K, V> e : map.entrySet()) {
                K k = e.getKey();
                V v = e.getValue();
                if (skipNulls) {
                    if (k == null || v == null) {
                        continue;
                    }
                } else if (checkNulls) {
                    Objects.requireNonNull(k, "key");
                    if (v == null) {
                        Objects.requireNonNull(v, "value for key: " + k);
                    }
                }
                linkedMap.put(k, v);
            }
        } else {
            linkedMap.putAll(map);
        }
        return Collections.unmodifiableMap(linkedMap);
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Generated(from="NessieConfiguration", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_MAX_SUPPORTED_API_VERSION = 1L;
        private static final long OPT_BIT_MIN_SUPPORTED_API_VERSION = 1L;
        private static final long OPT_BIT_ACTUAL_API_VERSION = 2L;
        private long initBits = 1L;
        private long optBits;
        @javax.annotation.Nullable
        private String defaultBranch;
        private int minSupportedApiVersion;
        private int maxSupportedApiVersion;
        private int actualApiVersion;
        @javax.annotation.Nullable
        private String specVersion;
        @javax.annotation.Nullable
        private String noAncestorHash;
        @javax.annotation.Nullable
        private Instant repositoryCreationTimestamp;
        @javax.annotation.Nullable
        private Instant oldestPossibleCommitTimestamp;
        private Map<String, String> additionalProperties = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public final Builder from(NessieConfiguration instance) {
            Instant oldestPossibleCommitTimestampValue;
            Instant repositoryCreationTimestampValue;
            String noAncestorHashValue;
            Objects.requireNonNull(instance, "instance");
            String defaultBranchValue = instance.getDefaultBranch();
            if (defaultBranchValue != null) {
                this.defaultBranch(defaultBranchValue);
            }
            this.minSupportedApiVersion(instance.getMinSupportedApiVersion());
            this.maxSupportedApiVersion(instance.getMaxSupportedApiVersion());
            this.actualApiVersion(instance.getActualApiVersion());
            String specVersionValue = instance.getSpecVersion();
            if (specVersionValue != null) {
                this.specVersion(specVersionValue);
            }
            if ((noAncestorHashValue = instance.getNoAncestorHash()) != null) {
                this.noAncestorHash(noAncestorHashValue);
            }
            if ((repositoryCreationTimestampValue = instance.getRepositoryCreationTimestamp()) != null) {
                this.repositoryCreationTimestamp(repositoryCreationTimestampValue);
            }
            if ((oldestPossibleCommitTimestampValue = instance.getOldestPossibleCommitTimestamp()) != null) {
                this.oldestPossibleCommitTimestamp(oldestPossibleCommitTimestampValue);
            }
            this.putAllAdditionalProperties(instance.getAdditionalProperties());
            return this;
        }

        @JsonProperty(value="defaultBranch")
        public final Builder defaultBranch(@Nullable String defaultBranch) {
            this.defaultBranch = defaultBranch;
            return this;
        }

        @JsonProperty(value="minSupportedApiVersion")
        @JsonView(value={Views.V2.class})
        public final Builder minSupportedApiVersion(int minSupportedApiVersion) {
            this.minSupportedApiVersion = minSupportedApiVersion;
            this.optBits |= 1L;
            return this;
        }

        @JsonProperty(value="maxSupportedApiVersion")
        public final Builder maxSupportedApiVersion(int maxSupportedApiVersion) {
            this.maxSupportedApiVersion = maxSupportedApiVersion;
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @JsonProperty(value="actualApiVersion")
        @JsonView(value={Views.V2.class})
        public final Builder actualApiVersion(int actualApiVersion) {
            this.actualApiVersion = actualApiVersion;
            this.optBits |= 2L;
            return this;
        }

        @JsonProperty(value="specVersion")
        @JsonView(value={Views.V2.class})
        public final Builder specVersion(@Nullable String specVersion) {
            this.specVersion = specVersion;
            return this;
        }

        @JsonProperty(value="noAncestorHash")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public final Builder noAncestorHash(@Nullable String noAncestorHash) {
            this.noAncestorHash = noAncestorHash;
            return this;
        }

        @JsonProperty(value="repositoryCreationTimestamp")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public final Builder repositoryCreationTimestamp(@Nullable Instant repositoryCreationTimestamp) {
            this.repositoryCreationTimestamp = repositoryCreationTimestamp;
            return this;
        }

        @JsonProperty(value="oldestPossibleCommitTimestamp")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public final Builder oldestPossibleCommitTimestamp(@Nullable Instant oldestPossibleCommitTimestamp) {
            this.oldestPossibleCommitTimestamp = oldestPossibleCommitTimestamp;
            return this;
        }

        public final Builder putAdditionalProperties(String key, String value) {
            this.additionalProperties.put(Objects.requireNonNull(key, "additionalProperties key"), value == null ? Objects.requireNonNull(value, "additionalProperties value for key: " + key) : value);
            return this;
        }

        public final Builder putAdditionalProperties(Map.Entry<String, ? extends String> entry) {
            String v;
            String k = entry.getKey();
            this.additionalProperties.put(Objects.requireNonNull(k, "additionalProperties key"), (v = entry.getValue()) == null ? Objects.requireNonNull(v, "additionalProperties value for key: " + k) : v);
            return this;
        }

        @JsonProperty(value="additionalProperties")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public final Builder additionalProperties(Map<String, ? extends String> entries) {
            this.additionalProperties.clear();
            return this.putAllAdditionalProperties(entries);
        }

        public final Builder putAllAdditionalProperties(Map<String, ? extends String> entries) {
            for (Map.Entry<String, ? extends String> e : entries.entrySet()) {
                String v;
                String k = e.getKey();
                this.additionalProperties.put(Objects.requireNonNull(k, "additionalProperties key"), (v = e.getValue()) == null ? Objects.requireNonNull(v, "additionalProperties value for key: " + k) : v);
            }
            return this;
        }

        public ImmutableNessieConfiguration build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableNessieConfiguration(this);
        }

        private boolean minSupportedApiVersionIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean actualApiVersionIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("maxSupportedApiVersion");
            }
            return "Cannot build NessieConfiguration, some of required attributes are not set " + attributes;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    @Deprecated
    @JsonDeserialize
    @JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE)
    @Generated(from="NessieConfiguration", generator="Immutables")
    static final class Json
    extends NessieConfiguration {
        @javax.annotation.Nullable
        String defaultBranch;
        int minSupportedApiVersion;
        boolean minSupportedApiVersionIsSet;
        int maxSupportedApiVersion;
        boolean maxSupportedApiVersionIsSet;
        int actualApiVersion;
        boolean actualApiVersionIsSet;
        @javax.annotation.Nullable
        String specVersion;
        @javax.annotation.Nullable
        String noAncestorHash;
        @javax.annotation.Nullable
        Instant repositoryCreationTimestamp;
        @javax.annotation.Nullable
        Instant oldestPossibleCommitTimestamp;
        @javax.annotation.Nullable
        Map<String, String> additionalProperties = Collections.emptyMap();

        Json() {
        }

        @JsonProperty(value="defaultBranch")
        public void setDefaultBranch(@Nullable String defaultBranch) {
            this.defaultBranch = defaultBranch;
        }

        @JsonProperty(value="minSupportedApiVersion")
        @JsonView(value={Views.V2.class})
        public void setMinSupportedApiVersion(int minSupportedApiVersion) {
            this.minSupportedApiVersion = minSupportedApiVersion;
            this.minSupportedApiVersionIsSet = true;
        }

        @JsonProperty(value="maxSupportedApiVersion")
        public void setMaxSupportedApiVersion(int maxSupportedApiVersion) {
            this.maxSupportedApiVersion = maxSupportedApiVersion;
            this.maxSupportedApiVersionIsSet = true;
        }

        @JsonProperty(value="actualApiVersion")
        @JsonView(value={Views.V2.class})
        public void setActualApiVersion(int actualApiVersion) {
            this.actualApiVersion = actualApiVersion;
            this.actualApiVersionIsSet = true;
        }

        @JsonProperty(value="specVersion")
        @JsonView(value={Views.V2.class})
        public void setSpecVersion(@Nullable String specVersion) {
            this.specVersion = specVersion;
        }

        @JsonProperty(value="noAncestorHash")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        public void setNoAncestorHash(@Nullable String noAncestorHash) {
            this.noAncestorHash = noAncestorHash;
        }

        @JsonProperty(value="repositoryCreationTimestamp")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public void setRepositoryCreationTimestamp(@Nullable Instant repositoryCreationTimestamp) {
            this.repositoryCreationTimestamp = repositoryCreationTimestamp;
        }

        @JsonProperty(value="oldestPossibleCommitTimestamp")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_NULL)
        @JsonSerialize(using=CommitMeta.InstantSerializer.class)
        @JsonDeserialize(using=CommitMeta.InstantDeserializer.class)
        public void setOldestPossibleCommitTimestamp(@Nullable Instant oldestPossibleCommitTimestamp) {
            this.oldestPossibleCommitTimestamp = oldestPossibleCommitTimestamp;
        }

        @JsonProperty(value="additionalProperties")
        @JsonView(value={Views.V2.class})
        @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
        public void setAdditionalProperties(Map<String, String> additionalProperties) {
            this.additionalProperties = additionalProperties;
        }

        @Override
        public String getDefaultBranch() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMinSupportedApiVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getMaxSupportedApiVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getActualApiVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getSpecVersion() {
            throw new UnsupportedOperationException();
        }

        @Override
        public String getNoAncestorHash() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getRepositoryCreationTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Instant getOldestPossibleCommitTimestamp() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Map<String, String> getAdditionalProperties() {
            throw new UnsupportedOperationException();
        }
    }

    @Generated(from="NessieConfiguration", generator="Immutables")
    private final class InitShim {
        private byte minSupportedApiVersionBuildStage = 0;
        private int minSupportedApiVersion;
        private byte actualApiVersionBuildStage = 0;
        private int actualApiVersion;

        private InitShim() {
        }

        int getMinSupportedApiVersion() {
            if (this.minSupportedApiVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minSupportedApiVersionBuildStage == 0) {
                this.minSupportedApiVersionBuildStage = (byte)-1;
                this.minSupportedApiVersion = ImmutableNessieConfiguration.super.getMinSupportedApiVersion();
                this.minSupportedApiVersionBuildStage = 1;
            }
            return this.minSupportedApiVersion;
        }

        void minSupportedApiVersion(int minSupportedApiVersion) {
            this.minSupportedApiVersion = minSupportedApiVersion;
            this.minSupportedApiVersionBuildStage = 1;
        }

        int getActualApiVersion() {
            if (this.actualApiVersionBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.actualApiVersionBuildStage == 0) {
                this.actualApiVersionBuildStage = (byte)-1;
                this.actualApiVersion = ImmutableNessieConfiguration.super.getActualApiVersion();
                this.actualApiVersionBuildStage = 1;
            }
            return this.actualApiVersion;
        }

        void actualApiVersion(int actualApiVersion) {
            this.actualApiVersion = actualApiVersion;
            this.actualApiVersionBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.minSupportedApiVersionBuildStage == -1) {
                attributes.add("minSupportedApiVersion");
            }
            if (this.actualApiVersionBuildStage == -1) {
                attributes.add("actualApiVersion");
            }
            return "Cannot build NessieConfiguration, attribute initializers form cycle " + attributes;
        }
    }
}

