/*
 * Decompiled with CFR 0.152.
 */
package io.trino.orc.writer;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.slice.SizeOf;
import io.airlift.slice.Slice;
import io.trino.orc.checkpoint.BooleanStreamCheckpoint;
import io.trino.orc.checkpoint.DecimalStreamCheckpoint;
import io.trino.orc.checkpoint.LongStreamCheckpoint;
import io.trino.orc.metadata.ColumnEncoding;
import io.trino.orc.metadata.CompressedMetadataWriter;
import io.trino.orc.metadata.CompressionKind;
import io.trino.orc.metadata.OrcColumnId;
import io.trino.orc.metadata.RowGroupIndex;
import io.trino.orc.metadata.Stream;
import io.trino.orc.metadata.statistics.ColumnStatistics;
import io.trino.orc.metadata.statistics.LongDecimalStatisticsBuilder;
import io.trino.orc.metadata.statistics.ShortDecimalStatisticsBuilder;
import io.trino.orc.stream.DecimalOutputStream;
import io.trino.orc.stream.LongOutputStream;
import io.trino.orc.stream.LongOutputStreamV2;
import io.trino.orc.stream.PresentOutputStream;
import io.trino.orc.stream.StreamDataOutput;
import io.trino.orc.writer.ColumnWriter;
import io.trino.spi.block.Block;
import io.trino.spi.type.DecimalType;
import io.trino.spi.type.Int128;
import io.trino.spi.type.Type;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class DecimalColumnWriter
implements ColumnWriter {
    private static final int INSTANCE_SIZE = SizeOf.instanceSize(DecimalColumnWriter.class);
    private final OrcColumnId columnId;
    private final DecimalType type;
    private final ColumnEncoding columnEncoding;
    private final boolean compressed;
    private final DecimalOutputStream dataStream;
    private final LongOutputStream scaleStream;
    private final PresentOutputStream presentStream;
    private final List<ColumnStatistics> rowGroupColumnStatistics = new ArrayList<ColumnStatistics>();
    private ShortDecimalStatisticsBuilder shortDecimalStatisticsBuilder;
    private LongDecimalStatisticsBuilder longDecimalStatisticsBuilder;
    private boolean closed;

    public DecimalColumnWriter(OrcColumnId columnId, Type type, CompressionKind compression, int bufferSize) {
        this.columnId = Objects.requireNonNull(columnId, "columnId is null");
        this.type = (DecimalType)Objects.requireNonNull(type, "type is null");
        this.compressed = Objects.requireNonNull(compression, "compression is null") != CompressionKind.NONE;
        this.columnEncoding = new ColumnEncoding(ColumnEncoding.ColumnEncodingKind.DIRECT_V2, 0);
        this.dataStream = new DecimalOutputStream(compression, bufferSize);
        this.scaleStream = new LongOutputStreamV2(compression, bufferSize, true, Stream.StreamKind.SECONDARY);
        this.presentStream = new PresentOutputStream(compression, bufferSize);
        if (this.type.isShort()) {
            this.shortDecimalStatisticsBuilder = new ShortDecimalStatisticsBuilder(this.type.getScale());
        } else {
            this.longDecimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
        }
    }

    @Override
    public Map<OrcColumnId, ColumnEncoding> getColumnEncodings() {
        return ImmutableMap.of((Object)this.columnId, (Object)this.columnEncoding);
    }

    @Override
    public void beginRowGroup() {
        this.presentStream.recordCheckpoint();
        this.dataStream.recordCheckpoint();
        this.scaleStream.recordCheckpoint();
    }

    @Override
    public void writeBlock(Block block) {
        int position;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        Preconditions.checkArgument((block.getPositionCount() > 0 ? 1 : 0) != 0, (Object)"Block is empty");
        for (position = 0; position < block.getPositionCount(); ++position) {
            this.presentStream.writeBoolean(!block.isNull(position));
        }
        if (this.type.isShort()) {
            for (position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                long value = this.type.getLong(block, position);
                this.dataStream.writeUnscaledValue(value);
                this.shortDecimalStatisticsBuilder.addValue(value);
            }
        } else {
            for (position = 0; position < block.getPositionCount(); ++position) {
                if (block.isNull(position)) continue;
                Int128 value = (Int128)this.type.getObject(block, position);
                this.dataStream.writeUnscaledValue(value);
                this.longDecimalStatisticsBuilder.addValue(new BigDecimal(value.toBigInteger(), this.type.getScale()));
            }
        }
        for (position = 0; position < block.getPositionCount(); ++position) {
            if (block.isNull(position)) continue;
            this.scaleStream.writeLong(this.type.getScale());
        }
    }

    @Override
    public Map<OrcColumnId, ColumnStatistics> finishRowGroup() {
        ColumnStatistics statistics;
        Preconditions.checkState((!this.closed ? 1 : 0) != 0);
        if (this.type.isShort()) {
            statistics = this.shortDecimalStatisticsBuilder.buildColumnStatistics();
            this.shortDecimalStatisticsBuilder = new ShortDecimalStatisticsBuilder(this.type.getScale());
        } else {
            statistics = this.longDecimalStatisticsBuilder.buildColumnStatistics();
            this.longDecimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
        }
        this.rowGroupColumnStatistics.add(statistics);
        return ImmutableMap.of((Object)this.columnId, (Object)statistics);
    }

    @Override
    public void close() {
        this.closed = true;
        this.dataStream.close();
        this.scaleStream.close();
        this.presentStream.close();
    }

    @Override
    public Map<OrcColumnId, ColumnStatistics> getColumnStripeStatistics() {
        Preconditions.checkState((boolean)this.closed);
        return ImmutableMap.of((Object)this.columnId, (Object)ColumnStatistics.mergeColumnStatistics(this.rowGroupColumnStatistics));
    }

    @Override
    public List<StreamDataOutput> getIndexStreams(CompressedMetadataWriter metadataWriter) throws IOException {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder rowGroupIndexes = ImmutableList.builder();
        List<DecimalStreamCheckpoint> dataCheckpoints = this.dataStream.getCheckpoints();
        List scaleCheckpoints = this.scaleStream.getCheckpoints();
        Optional<List<BooleanStreamCheckpoint>> presentCheckpoints = this.presentStream.getCheckpoints();
        int i = 0;
        while (i < this.rowGroupColumnStatistics.size()) {
            int groupId = i++;
            ColumnStatistics columnStatistics = this.rowGroupColumnStatistics.get(groupId);
            DecimalStreamCheckpoint dataCheckpoint = dataCheckpoints.get(groupId);
            LongStreamCheckpoint scaleCheckpoint = (LongStreamCheckpoint)scaleCheckpoints.get(groupId);
            Optional<BooleanStreamCheckpoint> presentCheckpoint = presentCheckpoints.map(checkpoints -> (BooleanStreamCheckpoint)checkpoints.get(groupId));
            List<Integer> positions = DecimalColumnWriter.createDecimalColumnPositionList(this.compressed, dataCheckpoint, scaleCheckpoint, presentCheckpoint);
            rowGroupIndexes.add((Object)new RowGroupIndex(positions, columnStatistics));
        }
        Slice slice = metadataWriter.writeRowIndexes((List<RowGroupIndex>)rowGroupIndexes.build());
        Stream stream = new Stream(this.columnId, Stream.StreamKind.ROW_INDEX, slice.length(), false);
        return ImmutableList.of((Object)new StreamDataOutput(slice, stream));
    }

    @Override
    public List<StreamDataOutput> getBloomFilters(CompressedMetadataWriter metadataWriter) {
        return ImmutableList.of();
    }

    private static List<Integer> createDecimalColumnPositionList(boolean compressed, DecimalStreamCheckpoint dataCheckpoint, LongStreamCheckpoint scaleCheckpoint, Optional<BooleanStreamCheckpoint> presentCheckpoint) {
        ImmutableList.Builder positionList = ImmutableList.builder();
        presentCheckpoint.ifPresent(booleanStreamCheckpoint -> positionList.addAll(booleanStreamCheckpoint.toPositionList(compressed)));
        positionList.addAll(dataCheckpoint.toPositionList(compressed));
        positionList.addAll(scaleCheckpoint.toPositionList(compressed));
        return positionList.build();
    }

    @Override
    public List<StreamDataOutput> getDataStreams() {
        Preconditions.checkState((boolean)this.closed);
        ImmutableList.Builder outputDataStreams = ImmutableList.builder();
        this.presentStream.getStreamDataOutput(this.columnId).ifPresent(arg_0 -> ((ImmutableList.Builder)outputDataStreams).add(arg_0));
        outputDataStreams.add((Object)this.dataStream.getStreamDataOutput(this.columnId));
        outputDataStreams.add((Object)this.scaleStream.getStreamDataOutput(this.columnId));
        return outputDataStreams.build();
    }

    @Override
    public long getBufferedBytes() {
        return this.dataStream.getBufferedBytes() + this.scaleStream.getBufferedBytes() + this.presentStream.getBufferedBytes();
    }

    @Override
    public long getRetainedBytes() {
        long retainedBytes = (long)INSTANCE_SIZE + this.dataStream.getRetainedBytes() + this.scaleStream.getRetainedBytes() + this.presentStream.getRetainedBytes();
        for (ColumnStatistics statistics : this.rowGroupColumnStatistics) {
            retainedBytes += statistics.getRetainedSizeInBytes();
        }
        return retainedBytes;
    }

    @Override
    public void reset() {
        this.closed = false;
        this.dataStream.reset();
        this.scaleStream.reset();
        this.presentStream.reset();
        this.rowGroupColumnStatistics.clear();
        this.shortDecimalStatisticsBuilder = new ShortDecimalStatisticsBuilder(this.type.getScale());
        this.longDecimalStatisticsBuilder = new LongDecimalStatisticsBuilder();
    }
}

