/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.tree;

import com.google.common.base.MoreObjects;
import com.google.common.collect.ImmutableList;
import io.trino.sql.tree.AstVisitor;
import io.trino.sql.tree.Node;
import io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public final class EmptyTableTreatment
extends Node {
    private final Treatment treatment;

    public EmptyTableTreatment(NodeLocation location, Treatment treatment) {
        super(Optional.of(location));
        this.treatment = Objects.requireNonNull(treatment, "treatment is null");
    }

    public Treatment getTreatment() {
        return this.treatment;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitEmptyTableTreatment(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        return this.treatment == ((EmptyTableTreatment)obj).treatment;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.treatment});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("treatment", (Object)this.treatment).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!EmptyTableTreatment.sameClass(this, other)) {
            return false;
        }
        return this.treatment == ((EmptyTableTreatment)other).treatment;
    }

    public static enum Treatment {
        KEEP,
        PRUNE;

    }
}

