/*
 * Decompiled with CFR 0.152.
 */
package io.trino.sql.jsonpath.tree;

import com.google.common.base.Preconditions;
import io.trino.sql.jsonpath.tree.JsonPathTreeVisitor;
import io.trino.sql.jsonpath.tree.NamedVariable;
import io.trino.sql.jsonpath.tree.PathNode;
import io.trino.sql.jsonpath.tree.Predicate;
import io.trino.sql.jsonpath.tree.SqlValueLiteral;
import io.trino.sql.tree.StringLiteral;
import java.util.Objects;

public class StartsWithPredicate
extends Predicate {
    private final PathNode whole;
    private final PathNode initial;

    public StartsWithPredicate(PathNode whole, PathNode initial) {
        Objects.requireNonNull(whole, "whole is null");
        Objects.requireNonNull(initial, "initial is null");
        Preconditions.checkArgument((initial instanceof NamedVariable || initial instanceof SqlValueLiteral && ((SqlValueLiteral)initial).getValue() instanceof StringLiteral ? 1 : 0) != 0, (Object)"initial must be a named variable or a string literal");
        this.whole = whole;
        this.initial = initial;
    }

    @Override
    public <R, C> R accept(JsonPathTreeVisitor<R, C> visitor, C context) {
        return visitor.visitStartsWithPredicate(this, context);
    }

    public PathNode getWhole() {
        return this.whole;
    }

    public PathNode getInitial() {
        return this.initial;
    }
}

