/*
 * Decompiled with CFR 0.152.
 */
package io.airlift.configuration;

import com.google.inject.Binder;
import com.google.inject.Module;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.configuration.ConfigurationAwareModule;
import io.airlift.configuration.ConfigurationFactory;
import io.airlift.configuration.ConfigurationProvider;
import java.lang.annotation.Annotation;
import java.util.stream.Stream;

public class ConfigurationModule
implements Module {
    private final ConfigurationFactory configurationFactory;

    public ConfigurationModule(ConfigurationFactory configurationFactory) {
        this.configurationFactory = configurationFactory;
    }

    public void configure(Binder binder) {
        binder.disableCircularProxies();
        binder.bind(ConfigurationFactory.class).toInstance((Object)this.configurationFactory);
        this.configurationFactory.getConfigurationProviders().forEach(configurationProvider -> ConfigurationModule.bindConfigurationProvider(binder, configurationProvider));
    }

    @Deprecated
    public static ConfigurationAwareModule installModules(final Module ... modules) {
        return new AbstractConfigurationAwareModule(){

            @Override
            protected void setup(Binder binder) {
                Stream.of(modules).forEach(this::install);
            }
        };
    }

    private static <T> void bindConfigurationProvider(Binder binder, ConfigurationProvider<T> configurationProvider) {
        binder.bind(configurationProvider.getConfigurationBinding().getKey()).toProvider(configurationProvider);
    }

    @Deprecated
    public static AnnotatedBindingBuilder bindConfig(Binder binder) {
        return new AnnotatedBindingBuilder(binder.skipSources(new Class[]{ConfigurationModule.class}));
    }

    public static class AnnotatedBindingBuilder
    extends PrefixBindingBuilder {
        public AnnotatedBindingBuilder(Binder binder) {
            super(binder, null, null);
        }

        public PrefixBindingBuilder annotatedWith(Class<? extends Annotation> annotationType) {
            return new PrefixBindingBuilder(this.binder, annotationType, null);
        }

        public PrefixBindingBuilder annotatedWith(Annotation annotation) {
            return new PrefixBindingBuilder(this.binder, null, annotation);
        }
    }

    public static class ConfigBindingBuilder {
        protected final Binder binder;
        protected final Class<? extends Annotation> annotationType;
        protected final Annotation annotation;
        protected final String prefix;

        public ConfigBindingBuilder(Binder binder, Class<? extends Annotation> annotationType, Annotation annotation, String prefix) {
            this.binder = binder;
            this.annotationType = annotationType;
            this.annotation = annotation;
            this.prefix = prefix;
        }

        public <T> void to(Class<T> configClass) {
            if (this.annotationType != null) {
                ConfigBinder.configBinder(this.binder).bindConfig(configClass, this.annotationType, this.prefix);
            } else if (this.annotation != null) {
                ConfigBinder.configBinder(this.binder).bindConfig(configClass, this.annotation, this.prefix);
            } else {
                ConfigBinder.configBinder(this.binder).bindConfig(configClass, this.prefix);
            }
        }
    }

    public static class PrefixBindingBuilder
    extends ConfigBindingBuilder {
        public PrefixBindingBuilder(Binder binder, Class<? extends Annotation> annotationType, Annotation annotation) {
            super(binder, annotationType, annotation, null);
        }

        public ConfigBindingBuilder prefixedWith(String prefix) {
            return new ConfigBindingBuilder(this.binder, this.annotationType, this.annotation, prefix);
        }
    }
}

