/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.rel.metadata;

import com.linkedin.coral.calcite.$internal.com.google.common.cache.CacheBuilder;
import com.linkedin.coral.calcite.$internal.com.google.common.cache.CacheLoader;
import com.linkedin.coral.calcite.$internal.com.google.common.cache.LoadingCache;
import com.linkedin.coral.calcite.$internal.com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.concurrent.ExecutionException;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.metadata.Metadata;
import org.apache.calcite.rel.metadata.MetadataFactory;
import org.apache.calcite.rel.metadata.RelMetadataProvider;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.metadata.UnboundMetadata;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;

public class MetadataFactoryImpl
implements MetadataFactory {
    public static final UnboundMetadata<Metadata> DUMMY = (rel, mq) -> null;
    private final LoadingCache<Pair<Class<RelNode>, Class<Metadata>>, UnboundMetadata<Metadata>> cache;

    public MetadataFactoryImpl(RelMetadataProvider provider) {
        this.cache = CacheBuilder.newBuilder().build(MetadataFactoryImpl.loader(provider));
    }

    private static CacheLoader<Pair<Class<RelNode>, Class<Metadata>>, UnboundMetadata<Metadata>> loader(RelMetadataProvider provider) {
        return CacheLoader.from(key -> {
            UnboundMetadata function = provider.apply((Class)key.left, (Class)key.right);
            return function != null ? function : DUMMY;
        });
    }

    @Override
    public <M extends Metadata> M query(RelNode rel, RelMetadataQuery mq, Class<M> metadataClazz) {
        try {
            Pair<Class<?>, Class<M>> key = Pair.of(rel.getClass(), metadataClazz);
            Metadata apply = this.cache.get(key).bind(rel, mq);
            return (M)((Metadata)metadataClazz.cast(apply));
        }
        catch (UncheckedExecutionException | ExecutionException e) {
            Util.throwIfUnchecked(e.getCause());
            throw new RuntimeException(e.getCause());
        }
    }
}

