/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.plan.volcano;

import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.ImmutableMap;
import com.linkedin.coral.calcite.$internal.com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.calcite.plan.RelOptListener;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperand;
import org.apache.calcite.plan.RelOptRuleOperandChildPolicy;
import org.apache.calcite.plan.volcano.RelSubset;
import org.apache.calcite.plan.volcano.VolcanoPlanner;
import org.apache.calcite.rel.RelNode;

public class VolcanoRuleCall
extends RelOptRuleCall {
    protected final VolcanoPlanner volcanoPlanner;
    private List<RelNode> generatedRelList;

    protected VolcanoRuleCall(VolcanoPlanner planner, RelOptRuleOperand operand, RelNode[] rels, Map<RelNode, List<RelNode>> nodeInputs) {
        super(planner, operand, rels, nodeInputs);
        this.volcanoPlanner = planner;
    }

    VolcanoRuleCall(VolcanoPlanner planner, RelOptRuleOperand operand) {
        this(planner, operand, new RelNode[operand.getRule().operands.size()], ImmutableMap.of());
    }

    @Override
    public void transformTo(RelNode rel, Map<RelNode, RelNode> equiv) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Transform to: rel#{} via {}{}", rel.getId(), this.getRule(), equiv.isEmpty() ? "" : " with equivalences " + equiv);
            if (this.generatedRelList != null) {
                this.generatedRelList.add(rel);
            }
        }
        try {
            Object event;
            if (LOGGER.isTraceEnabled()) {
                String relDesc = "rel#" + rel.getId() + ":" + rel.getRelTypeName();
                LOGGER.trace("call#{}: Rule {} arguments {} created {}", this.id, this.getRule(), Arrays.toString(this.rels), relDesc);
            }
            if (this.volcanoPlanner.listener != null) {
                event = new RelOptListener.RuleProductionEvent(this.volcanoPlanner, rel, this, true);
                this.volcanoPlanner.listener.ruleProductionSucceeded((RelOptListener.RuleProductionEvent)event);
            }
            for (Map.Entry<RelNode, RelNode> entry : equiv.entrySet()) {
                this.volcanoPlanner.ensureRegistered(entry.getKey(), entry.getValue(), this);
            }
            this.volcanoPlanner.ensureRegistered(rel, this.rels[0], this);
            this.rels[0].getCluster().invalidateMetadataQuery();
            if (this.volcanoPlanner.listener != null) {
                event = new RelOptListener.RuleProductionEvent(this.volcanoPlanner, rel, this, false);
                this.volcanoPlanner.listener.ruleProductionSucceeded((RelOptListener.RuleProductionEvent)event);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error occurred while applying rule " + this.getRule(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void onMatch() {
        assert (this.getRule().matches(this));
        this.volcanoPlanner.checkCancel();
        try {
            if (this.volcanoPlanner.isRuleExcluded(this.getRule())) {
                LOGGER.debug("Rule [{}] not fired due to exclusion filter", (Object)this.getRule());
                return;
            }
            for (int i = 0; i < this.rels.length; ++i) {
                RelNode rel = this.rels[i];
                RelSubset subset = this.volcanoPlanner.getSubset(rel);
                if (subset == null) {
                    LOGGER.debug("Rule [{}] not fired because operand #{} ({}) has no subset", this.getRule(), i, rel);
                    return;
                }
                if (subset.set.equivalentSet != null) {
                    LOGGER.debug("Rule [{}] not fired because operand #{} ({}) belongs to obsolete set", this.getRule(), i, rel);
                    return;
                }
                Double importance = this.volcanoPlanner.relImportances.get(rel);
                if (importance == null || importance != 0.0) continue;
                LOGGER.debug("Rule [{}] not fired because operand #{} ({}) has importance=0", this.getRule(), i, rel);
                return;
            }
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("call#{}: Apply rule [{}] to {}", this.id, this.getRule(), Arrays.toString(this.rels));
            }
            if (this.volcanoPlanner.listener != null) {
                RelOptListener.RuleAttemptedEvent event = new RelOptListener.RuleAttemptedEvent(this.volcanoPlanner, this.rels[0], this, true);
                this.volcanoPlanner.listener.ruleAttempted(event);
            }
            if (LOGGER.isDebugEnabled()) {
                this.generatedRelList = new ArrayList<RelNode>();
            }
            this.volcanoPlanner.ruleCallStack.push(this);
            try {
                this.getRule().onMatch(this);
            }
            finally {
                this.volcanoPlanner.ruleCallStack.pop();
            }
            if (LOGGER.isDebugEnabled()) {
                if (this.generatedRelList.isEmpty()) {
                    LOGGER.debug("call#{} generated 0 successors.", (Object)this.id);
                } else {
                    LOGGER.debug("call#{} generated {} successors: {}", this.id, this.generatedRelList.size(), this.generatedRelList);
                }
                this.generatedRelList = null;
            }
            if (this.volcanoPlanner.listener != null) {
                RelOptListener.RuleAttemptedEvent event = new RelOptListener.RuleAttemptedEvent(this.volcanoPlanner, this.rels[0], this, false);
                this.volcanoPlanner.listener.ruleAttempted(event);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Error while applying rule " + this.getRule() + ", args " + Arrays.toString(this.rels), e);
        }
    }

    void match(RelNode rel) {
        assert (this.getOperand0().matches(rel)) : "precondition";
        boolean solve = false;
        int operandOrdinal = this.getOperand0().solveOrder[0];
        this.rels[operandOrdinal] = rel;
        this.matchRecurse(1);
    }

    private void matchRecurse(int solve) {
        assert (solve > 0);
        assert (solve <= this.rule.operands.size());
        List<RelOptRuleOperand> operands = this.getRule().operands;
        if (solve == operands.size()) {
            if (this.getRule().matches(this)) {
                this.onMatch();
            }
        } else {
            List<RelNode> inputs;
            Collection<RelNode> successors;
            RelOptRuleOperand parentOperand;
            int operandOrdinal = this.operand0.solveOrder[solve];
            int previousOperandOrdinal = this.operand0.solveOrder[solve - 1];
            boolean ascending = operandOrdinal < previousOperandOrdinal;
            RelOptRuleOperand previousOperand = operands.get(previousOperandOrdinal);
            RelOptRuleOperand operand = operands.get(operandOrdinal);
            RelNode previous = this.rels[previousOperandOrdinal];
            if (ascending) {
                assert (previousOperand.getParent() == operand);
                parentOperand = operand;
                RelSubset subset = this.volcanoPlanner.getSubset(previous);
                successors = subset.getParentRels();
            } else {
                parentOperand = previousOperand;
                int parentOrdinal = operand.getParent().ordinalInRule;
                RelNode parentRel = this.rels[parentOrdinal];
                inputs = parentRel.getInputs();
                if (parentOperand.childPolicy == RelOptRuleOperandChildPolicy.UNORDERED) {
                    if (operand.getMatchedClass() == RelSubset.class) {
                        successors = inputs;
                    } else {
                        ArrayList<RelNode> allRelsInAllSubsets = new ArrayList<RelNode>();
                        HashSet<RelNode> duplicates = new HashSet<RelNode>();
                        for (RelNode input : inputs) {
                            if (!duplicates.add(input)) continue;
                            RelSubset inputSubset = (RelSubset)input;
                            for (RelNode rel : inputSubset.getRels()) {
                                if (!duplicates.add(rel)) continue;
                                allRelsInAllSubsets.add(rel);
                            }
                        }
                        successors = allRelsInAllSubsets;
                    }
                } else if (operand.ordinalInParent < inputs.size()) {
                    RelSubset subset = (RelSubset)inputs.get(operand.ordinalInParent);
                    successors = operand.getMatchedClass() == RelSubset.class ? ImmutableList.of(subset) : subset.getRelList();
                } else {
                    successors = ImmutableList.of();
                }
            }
            for (RelNode rel : successors) {
                RelSubset input;
                List<RelNode> inputRels;
                if (!operand.matches(rel) || ascending && operand.childPolicy != RelOptRuleOperandChildPolicy.UNORDERED && (previousOperand.ordinalInParent >= rel.getInputs().size() || !(inputRels = (input = (RelSubset)rel.getInput(previousOperand.ordinalInParent)).getRelList()).contains(previous))) continue;
                switch (parentOperand.childPolicy) {
                    case UNORDERED: {
                        if (ascending) {
                            inputs = Lists.newArrayList(rel.getInputs());
                            inputs.set(previousOperand.ordinalInParent, previous);
                            this.setChildRels(rel, inputs);
                            break;
                        }
                        inputs = this.getChildRels(previous);
                        if (inputs == null) {
                            inputs = Lists.newArrayList(previous.getInputs());
                        }
                        inputs.set(operand.ordinalInParent, rel);
                        this.setChildRels(previous, inputs);
                    }
                }
                this.rels[operandOrdinal] = rel;
                this.matchRecurse(solve + 1);
            }
        }
    }
}

