/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.trino.rel2trino.transformers;

import com.linkedin.coral.common.transformers.SqlCallTransformer;
import java.util.ArrayList;
import org.apache.calcite.rel.rel2sql.SqlImplementor;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlValidatorUtil;

public class SqlSelectAliasAppenderTransformer
extends SqlCallTransformer {
    @Override
    protected boolean condition(SqlCall sqlCall) {
        return sqlCall.getOperator().kind == SqlKind.SELECT && ((SqlSelect)sqlCall).getSelectList() != null && ((SqlSelect)sqlCall).getSelectList().size() != 0;
    }

    @Override
    protected SqlCall transform(SqlCall sqlCall) {
        ArrayList<SqlNode> modifiedSelectList = new ArrayList<SqlNode>();
        for (SqlNode selectNode : ((SqlSelect)sqlCall).getSelectList().getList()) {
            boolean nestedFieldAccess;
            String name = SqlValidatorUtil.getAlias(selectNode, -1);
            boolean bl = nestedFieldAccess = selectNode instanceof SqlIdentifier && ((SqlIdentifier)selectNode).names.size() > 1;
            if (nestedFieldAccess) {
                selectNode = SqlStdOperatorTable.AS.createCall(SqlImplementor.POS, selectNode, new SqlIdentifier(name, SqlImplementor.POS));
            }
            modifiedSelectList.add(selectNode);
        }
        ((SqlSelect)sqlCall).setSelectList(new SqlNodeList(modifiedSelectList, SqlImplementor.POS));
        return sqlCall;
    }
}

