/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.HiveVarchar;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.io.HiveVarcharWritable;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.AbstractPrimitiveJavaObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.objectinspector.primitive.SettableHiveVarcharObjectInspector;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.BaseCharUtils;
import com.linkedin.coral.$internal.org.apache.hadoop.hive.serde2.typeinfo.VarcharTypeInfo;

public class JavaHiveVarcharObjectInspector
extends AbstractPrimitiveJavaObjectInspector
implements SettableHiveVarcharObjectInspector {
    public JavaHiveVarcharObjectInspector() {
    }

    public JavaHiveVarcharObjectInspector(VarcharTypeInfo typeInfo) {
        super(typeInfo);
    }

    @Override
    public HiveVarchar getPrimitiveJavaObject(Object o) {
        if (o == null) {
            return null;
        }
        HiveVarchar value = o instanceof String ? new HiveVarchar((String)o, this.getMaxLength()) : (HiveVarchar)o;
        if (BaseCharUtils.doesPrimitiveMatchTypeParams(value, (VarcharTypeInfo)this.typeInfo)) {
            return value;
        }
        return this.getPrimitiveWithParams(value);
    }

    @Override
    public HiveVarcharWritable getPrimitiveWritableObject(Object o) {
        if (o == null) {
            return null;
        }
        HiveVarchar var = o instanceof String ? new HiveVarchar((String)o, this.getMaxLength()) : (HiveVarchar)o;
        return this.getWritableWithParams(var);
    }

    @Override
    public Object set(Object o, HiveVarchar value) {
        if (BaseCharUtils.doesPrimitiveMatchTypeParams(value, (VarcharTypeInfo)this.typeInfo)) {
            return value;
        }
        return new HiveVarchar(value, this.getMaxLength());
    }

    @Override
    public Object set(Object o, String value) {
        return new HiveVarchar(value, this.getMaxLength());
    }

    @Override
    public Object create(HiveVarchar value) {
        return new HiveVarchar(value, this.getMaxLength());
    }

    public int getMaxLength() {
        VarcharTypeInfo ti = (VarcharTypeInfo)this.typeInfo;
        return ti.getLength();
    }

    private HiveVarchar getPrimitiveWithParams(HiveVarchar val) {
        return new HiveVarchar(val, this.getMaxLength());
    }

    private HiveVarcharWritable getWritableWithParams(HiveVarchar val) {
        HiveVarcharWritable newValue = new HiveVarcharWritable();
        newValue.set(val, this.getMaxLength());
        return newValue;
    }
}

