/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type;

import com.linkedin.coral.$internal.org.apache.hadoop.hive.common.type.UnsignedInt128;
import java.util.Arrays;

public final class SqlMathUtil {
    public static final long NEGATIVE_LONG_MASK = Long.MIN_VALUE;
    public static final long FULLBITS_63 = Long.MAX_VALUE;
    public static final int NEGATIVE_INT_MASK = Integer.MIN_VALUE;
    public static final long LONG_MASK = 0xFFFFFFFFL;
    public static final int FULLBITS_31 = Integer.MAX_VALUE;
    public static final int FULLBITS_32 = -1;
    public static final int MAX_POWER_FIVE_INT31 = 13;
    public static final int[] POWER_FIVES_INT31;
    public static final int MAX_POWER_FIVE_INT63 = 27;
    public static final long[] POWER_FIVES_INT63;
    public static final int MAX_POWER_FIVE_INT128 = 55;
    public static final UnsignedInt128[] POWER_FIVES_INT128;
    public static final UnsignedInt128[] INVERSE_POWER_FIVES_INT128;
    public static final int MAX_POWER_TEN_INT31 = 9;
    public static final int[] POWER_TENS_INT31;
    public static final int[] ROUND_POWER_TENS_INT31;
    public static final int MAX_POWER_TEN_INT128 = 38;
    public static final UnsignedInt128[] POWER_TENS_INT128;
    public static final UnsignedInt128[] ROUND_POWER_TENS_INT128;
    public static final UnsignedInt128[] INVERSE_POWER_TENS_INT128;
    public static final int[] INVERSE_POWER_TENS_INT128_WORD_SHIFTS;
    private static final byte[] BIT_LENGTH;
    private static final long BASE = 0x100000000L;

    public static int setSignBitInt(int val, boolean positive) {
        if (positive) {
            return val & Integer.MAX_VALUE;
        }
        return val | Integer.MIN_VALUE;
    }

    public static long setSignBitLong(long val, boolean positive) {
        if (positive) {
            return val & Long.MAX_VALUE;
        }
        return val | Long.MIN_VALUE;
    }

    public static short bitLengthInWord(int word) {
        if (word < 0) {
            return 32;
        }
        if (word < 65536) {
            if (word < 256) {
                return BIT_LENGTH[word];
            }
            return (short)(BIT_LENGTH[word >>> 8] + 8);
        }
        if (word < 0x1000000) {
            return (short)(BIT_LENGTH[word >>> 16] + 16);
        }
        return (short)(BIT_LENGTH[word >>> 24] + 24);
    }

    public static short bitLength(int v0, int v1, int v2, int v3) {
        if (v3 != 0) {
            return (short)(SqlMathUtil.bitLengthInWord(v3) + 96);
        }
        if (v2 != 0) {
            return (short)(SqlMathUtil.bitLengthInWord(v2) + 64);
        }
        if (v1 != 0) {
            return (short)(SqlMathUtil.bitLengthInWord(v1) + 32);
        }
        return SqlMathUtil.bitLengthInWord(v0);
    }

    public static int compareUnsignedInt(int x, int y) {
        if (x == y) {
            return 0;
        }
        if (x + Integer.MIN_VALUE < y + Integer.MIN_VALUE) {
            return -1;
        }
        return 1;
    }

    public static int compareUnsignedLong(long x, long y) {
        if (x == y) {
            return 0;
        }
        if (x + Long.MIN_VALUE < y + Long.MIN_VALUE) {
            return -1;
        }
        return 1;
    }

    public static long divideUnsignedLong(long dividend, long divisor) {
        if (divisor < 0L) {
            return SqlMathUtil.compareUnsignedLong(dividend, divisor) < 0 ? 0L : 1L;
        }
        if (dividend >= 0L) {
            return dividend / divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        long remainder = dividend - quotient * divisor;
        if (SqlMathUtil.compareUnsignedLong(remainder, divisor) >= 0) {
            return quotient + 1L;
        }
        return quotient;
    }

    public static long remainderUnsignedLong(long dividend, long divisor) {
        if (divisor < 0L) {
            return SqlMathUtil.compareUnsignedLong(dividend, divisor) < 0 ? dividend : dividend - divisor;
        }
        if (dividend >= 0L) {
            return dividend % divisor;
        }
        long quotient = (dividend >>> 1) / divisor << 1;
        long remainder = dividend - quotient * divisor;
        if (SqlMathUtil.compareUnsignedLong(remainder, divisor) >= 0) {
            return remainder - divisor;
        }
        return remainder;
    }

    public static long combineInts(int lo, int hi) {
        return ((long)hi & 0xFFFFFFFFL) << 32 | (long)lo & 0xFFFFFFFFL;
    }

    public static int extractHiInt(long val) {
        return (int)(val >> 32);
    }

    public static int extractLowInt(long val) {
        return (int)val;
    }

    static void throwOverflowException() {
        throw new ArithmeticException("Overflow");
    }

    static void throwZeroDivisionException() {
        throw new ArithmeticException("Divide by zero");
    }

    private static void multiplyMultiPrecision(int[] inOut, int multiplier) {
        long multiplierUnsigned = (long)multiplier & 0xFFFFFFFFL;
        long product = 0L;
        for (int i = 0; i < inOut.length; ++i) {
            product = ((long)inOut[i] & 0xFFFFFFFFL) * multiplierUnsigned + (product >>> 32);
            inOut[i] = (int)product;
        }
        if (product >> 32 != 0L) {
            SqlMathUtil.throwOverflowException();
        }
    }

    private static int divideMultiPrecision(int[] inOut, int divisor) {
        long divisorUnsigned = (long)divisor & 0xFFFFFFFFL;
        long remainder = 0L;
        for (int i = inOut.length - 1; i >= 0; --i) {
            remainder = ((long)inOut[i] & 0xFFFFFFFFL) + (remainder << 32);
            long quotient = remainder / divisorUnsigned;
            inOut[i] = (int)quotient;
            remainder %= divisorUnsigned;
        }
        return (int)remainder;
    }

    private static int arrayValidLength(int[] array) {
        int len;
        for (len = array.length; len > 0 && array[len - 1] == 0; --len) {
        }
        return len <= 0 ? 0 : len;
    }

    public static int[] divideMultiPrecision(int[] dividend, int[] divisor, int[] quotient) {
        int dividendLength = SqlMathUtil.arrayValidLength(dividend);
        int divisorLength = SqlMathUtil.arrayValidLength(divisor);
        Arrays.fill(quotient, 0);
        int[] remainder = new int[dividend.length + 1];
        System.arraycopy(dividend, 0, remainder, 0, dividend.length);
        remainder[remainder.length - 1] = 0;
        if (divisorLength == 0) {
            SqlMathUtil.throwZeroDivisionException();
        }
        if (dividendLength < divisorLength) {
            return remainder;
        }
        if (divisorLength == 1) {
            int rem = SqlMathUtil.divideMultiPrecision(remainder, divisor[0]);
            System.arraycopy(remainder, 0, quotient, 0, quotient.length);
            Arrays.fill(remainder, 0);
            remainder[0] = rem;
            return remainder;
        }
        int d1 = (int)(0x100000000L / (((long)divisor[divisorLength - 1] & 0xFFFFFFFFL) + 1L));
        if (d1 > 1) {
            int[] newDivisor = new int[divisorLength];
            System.arraycopy(divisor, 0, newDivisor, 0, divisorLength);
            SqlMathUtil.multiplyMultiPrecision(newDivisor, d1);
            divisor = newDivisor;
            SqlMathUtil.multiplyMultiPrecision(remainder, d1);
        }
        long dHigh = (long)divisor[divisorLength - 1] & 0xFFFFFFFFL;
        long dLow = (long)divisor[divisorLength - 2] & 0xFFFFFFFFL;
        for (int rIndex = remainder.length - 1; rIndex >= divisorLength; --rIndex) {
            long accum = SqlMathUtil.combineInts(remainder[rIndex - 1], remainder[rIndex]);
            int qhat = dHigh == ((long)remainder[rIndex] & 0xFFFFFFFFL) ? -1 : (int)SqlMathUtil.divideUnsignedLong(accum, dHigh);
            int rhat = (int)(accum - ((long)qhat & 0xFFFFFFFFL) * dHigh);
            while (SqlMathUtil.compareUnsignedLong(dLow * ((long)qhat & 0xFFFFFFFFL), SqlMathUtil.combineInts(remainder[rIndex - 2], rhat)) > 0) {
                --qhat;
                if (((long)rhat & 0xFFFFFFFFL) >= (long)(-((int)dHigh))) break;
                rhat = (int)((long)rhat + dHigh);
            }
            long dwlMulAccum = 0L;
            accum = 0x100000000L;
            int iulRwork = rIndex - divisorLength;
            int dIndex = 0;
            while (dIndex < divisorLength) {
                dwlMulAccum = (long)SqlMathUtil.extractHiInt(dwlMulAccum) & 0xFFFFFFFFL;
                remainder[iulRwork] = SqlMathUtil.extractLowInt(accum += ((long)remainder[iulRwork] & 0xFFFFFFFFL) - ((long)SqlMathUtil.extractLowInt(dwlMulAccum += ((long)qhat & 0xFFFFFFFFL) * ((long)divisor[dIndex] & 0xFFFFFFFFL)) & 0xFFFFFFFFL));
                accum = ((long)SqlMathUtil.extractHiInt(accum) & 0xFFFFFFFFL) + 0x100000000L - 1L;
                ++dIndex;
                ++iulRwork;
            }
            remainder[iulRwork] = SqlMathUtil.extractLowInt(accum += ((long)remainder[iulRwork] & 0xFFFFFFFFL) - dwlMulAccum);
            quotient[rIndex - divisorLength] = qhat;
            if (SqlMathUtil.extractHiInt(accum) != 0) continue;
            quotient[rIndex - divisorLength] = qhat - 1;
            int carry = 0;
            int dIndex2 = 0;
            iulRwork = rIndex - divisorLength;
            while (dIndex2 < divisorLength) {
                long accum2 = ((long)divisor[dIndex2] & 0xFFFFFFFFL) + ((long)remainder[iulRwork] & 0xFFFFFFFFL) + ((long)carry & 0xFFFFFFFFL);
                carry = SqlMathUtil.extractHiInt(accum2);
                remainder[iulRwork] = SqlMathUtil.extractLowInt(accum2);
                ++dIndex2;
                ++iulRwork;
            }
            int n = iulRwork;
            remainder[n] = remainder[n] + carry;
        }
        if (d1 > 1) {
            SqlMathUtil.divideMultiPrecision(remainder, d1);
        }
        return remainder;
    }

    private SqlMathUtil() {
    }

    static {
        int i;
        POWER_FIVES_INT31 = new int[14];
        POWER_FIVES_INT63 = new long[28];
        POWER_FIVES_INT128 = new UnsignedInt128[56];
        INVERSE_POWER_FIVES_INT128 = new UnsignedInt128[56];
        POWER_TENS_INT31 = new int[10];
        ROUND_POWER_TENS_INT31 = new int[10];
        POWER_TENS_INT128 = new UnsignedInt128[39];
        ROUND_POWER_TENS_INT128 = new UnsignedInt128[39];
        INVERSE_POWER_TENS_INT128 = new UnsignedInt128[39];
        INVERSE_POWER_TENS_INT128_WORD_SHIFTS = new int[39];
        BIT_LENGTH = new byte[256];
        SqlMathUtil.BIT_LENGTH[0] = 0;
        for (i = 1; i < 8; ++i) {
            for (int j = 1 << i - 1; j < 1 << i; ++j) {
                SqlMathUtil.BIT_LENGTH[j] = (byte)i;
            }
        }
        SqlMathUtil.POWER_FIVES_INT31[0] = 1;
        for (i = 1; i < POWER_FIVES_INT31.length; ++i) {
            SqlMathUtil.POWER_FIVES_INT31[i] = POWER_FIVES_INT31[i - 1] * 5;
            assert (POWER_FIVES_INT31[i] > 0);
        }
        SqlMathUtil.POWER_FIVES_INT63[0] = 1L;
        for (i = 1; i < POWER_FIVES_INT63.length; ++i) {
            SqlMathUtil.POWER_FIVES_INT63[i] = POWER_FIVES_INT63[i - 1] * 5L;
            assert (POWER_FIVES_INT63[i] > 0L);
        }
        SqlMathUtil.POWER_TENS_INT31[0] = 1;
        SqlMathUtil.ROUND_POWER_TENS_INT31[0] = 0;
        for (i = 1; i < POWER_TENS_INT31.length; ++i) {
            SqlMathUtil.POWER_TENS_INT31[i] = POWER_TENS_INT31[i - 1] * 10;
            assert (POWER_TENS_INT31[i] > 0);
            SqlMathUtil.ROUND_POWER_TENS_INT31[i] = POWER_TENS_INT31[i] >> 1;
        }
        SqlMathUtil.POWER_FIVES_INT128[0] = new UnsignedInt128(1L);
        SqlMathUtil.INVERSE_POWER_FIVES_INT128[0] = new UnsignedInt128(-1, -1, -1, -1);
        for (i = 1; i < POWER_FIVES_INT128.length; ++i) {
            SqlMathUtil.POWER_FIVES_INT128[i] = new UnsignedInt128(POWER_FIVES_INT128[i - 1]);
            POWER_FIVES_INT128[i].multiplyDestructive(5);
            SqlMathUtil.INVERSE_POWER_FIVES_INT128[i] = new UnsignedInt128(INVERSE_POWER_FIVES_INT128[i - 1]);
            INVERSE_POWER_FIVES_INT128[i].divideDestructive(5);
        }
        SqlMathUtil.POWER_TENS_INT128[0] = new UnsignedInt128(1L);
        SqlMathUtil.ROUND_POWER_TENS_INT128[0] = new UnsignedInt128(0L);
        SqlMathUtil.INVERSE_POWER_TENS_INT128[0] = new UnsignedInt128(-1, -1, -1, -1);
        SqlMathUtil.INVERSE_POWER_TENS_INT128_WORD_SHIFTS[0] = 0;
        int[] inverseTens = new int[8];
        Arrays.fill(inverseTens, -1);
        for (int i2 = 1; i2 < POWER_TENS_INT128.length; ++i2) {
            int divisor = 10;
            SqlMathUtil.POWER_TENS_INT128[i2] = new UnsignedInt128(POWER_TENS_INT128[i2 - 1]);
            POWER_TENS_INT128[i2].multiplyDestructive(10);
            SqlMathUtil.ROUND_POWER_TENS_INT128[i2] = POWER_TENS_INT128[i2].shiftRightConstructive(1, false);
            long remainder = 0L;
            for (int j = inverseTens.length - 1; j >= 0; --j) {
                long quotient = (((long)inverseTens[j] & 0xFFFFFFFFL) + (remainder << 32)) / 10L;
                remainder = (((long)inverseTens[j] & 0xFFFFFFFFL) + (remainder << 32)) % 10L;
                inverseTens[j] = (int)quotient;
            }
            int wordShifts = 0;
            for (int j = inverseTens.length - 1; j >= 4 && inverseTens[j] == 0; --j) {
                ++wordShifts;
            }
            SqlMathUtil.INVERSE_POWER_TENS_INT128_WORD_SHIFTS[i2] = wordShifts;
            SqlMathUtil.INVERSE_POWER_TENS_INT128[i2] = new UnsignedInt128(inverseTens[inverseTens.length - 4 - wordShifts], inverseTens[inverseTens.length - 3 - wordShifts], inverseTens[inverseTens.length - 2 - wordShifts], inverseTens[inverseTens.length - 1 - wordShifts]);
        }
    }
}

