/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.MoreObjects;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Expression;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class FrameBound
extends Node {
    private final Type type;
    private final Optional<Expression> value;

    public FrameBound(Type type) {
        this(Optional.empty(), type);
    }

    public FrameBound(NodeLocation location, Type type) {
        this(Optional.of(location), type);
    }

    public FrameBound(Type type, Expression value) {
        this(Optional.empty(), type, value);
    }

    private FrameBound(Optional<NodeLocation> location, Type type) {
        this(location, type, null);
    }

    public FrameBound(NodeLocation location, Type type, Expression value) {
        this(Optional.of(location), type, value);
    }

    private FrameBound(Optional<NodeLocation> location, Type type, Expression value) {
        super(location);
        this.type = Objects.requireNonNull(type, "type is null");
        this.value = Optional.ofNullable(value);
    }

    public Type getType() {
        return this.type;
    }

    public Optional<Expression> getValue() {
        return this.value;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitFrameBound(this, context);
    }

    public List<Node> getChildren() {
        ImmutableList.Builder nodes = ImmutableList.builder();
        this.value.ifPresent(nodes::add);
        return nodes.build();
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        FrameBound o = (FrameBound)obj;
        return this.type == o.type && Objects.equals(this.value, o.value);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.value});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("type", (Object)this.type).add("value", this.value).toString();
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!FrameBound.sameClass(this, other)) {
            return false;
        }
        FrameBound otherNode = (FrameBound)other;
        return this.type == otherNode.type;
    }

    public static enum Type {
        UNBOUNDED_PRECEDING,
        PRECEDING,
        CURRENT_ROW,
        FOLLOWING,
        UNBOUNDED_FOLLOWING;

    }
}

