/*
 * Decompiled with CFR 0.152.
 */
package com.linkedin.coral.$internal.io.trino.sql.tree;

import com.linkedin.coral.$internal.com.google.common.base.MoreObjects;
import com.linkedin.coral.$internal.com.google.common.collect.ImmutableList;
import com.linkedin.coral.$internal.io.trino.sql.tree.AstVisitor;
import com.linkedin.coral.$internal.io.trino.sql.tree.Node;
import com.linkedin.coral.$internal.io.trino.sql.tree.NodeLocation;
import com.linkedin.coral.$internal.io.trino.sql.tree.QualifiedName;
import com.linkedin.coral.$internal.io.trino.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class DropTable
extends Statement {
    private final QualifiedName tableName;
    private final boolean exists;

    public DropTable(QualifiedName tableName, boolean exists) {
        this(Optional.empty(), tableName, exists);
    }

    public DropTable(NodeLocation location, QualifiedName tableName, boolean exists) {
        this(Optional.of(location), tableName, exists);
    }

    private DropTable(Optional<NodeLocation> location, QualifiedName tableName, boolean exists) {
        super(location);
        this.tableName = tableName;
        this.exists = exists;
    }

    public QualifiedName getTableName() {
        return this.tableName;
    }

    public boolean isExists() {
        return this.exists;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitDropTable(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.tableName, this.exists);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        DropTable o = (DropTable)obj;
        return Objects.equals(this.tableName, o.tableName) && this.exists == o.exists;
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper(this).add("tableName", this.tableName).add("exists", this.exists).toString();
    }
}

