/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.client.rest;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.client.rest.UriBuilder;
import io.confluent.kafka.schemaregistry.client.rest.entities.Config;
import io.confluent.kafka.schemaregistry.client.rest.entities.ErrorMessage;
import io.confluent.kafka.schemaregistry.client.rest.entities.Mode;
import io.confluent.kafka.schemaregistry.client.rest.entities.Schema;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaReference;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaRegistryServerVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.SchemaString;
import io.confluent.kafka.schemaregistry.client.rest.entities.ServerClusterId;
import io.confluent.kafka.schemaregistry.client.rest.entities.SubjectVersion;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.CompatibilityCheckResponse;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ConfigUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.ModeUpdateRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaRequest;
import io.confluent.kafka.schemaregistry.client.rest.entities.requests.RegisterSchemaResponse;
import io.confluent.kafka.schemaregistry.client.rest.exceptions.RestClientException;
import io.confluent.kafka.schemaregistry.client.rest.utils.UrlList;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.basicauth.BasicAuthCredentialProviderFactory;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProvider;
import io.confluent.kafka.schemaregistry.client.security.bearerauth.BearerAuthCredentialProviderFactory;
import io.confluent.kafka.schemaregistry.utils.JacksonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.Proxy;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLSocketFactory;
import org.apache.kafka.common.Configurable;
import org.apache.kafka.common.config.ConfigException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestService
implements Configurable {
    private static final Logger log = LoggerFactory.getLogger(RestService.class);
    private static final TypeReference<RegisterSchemaResponse> REGISTER_RESPONSE_TYPE = new TypeReference<RegisterSchemaResponse>(){};
    private static final TypeReference<Config> GET_CONFIG_RESPONSE_TYPE = new TypeReference<Config>(){};
    private static final TypeReference<Mode> GET_MODE_RESPONSE_TYPE = new TypeReference<Mode>(){};
    private static final TypeReference<List<Schema>> GET_SCHEMAS_RESPONSE_TYPE = new TypeReference<List<Schema>>(){};
    private static final TypeReference<SchemaString> GET_SCHEMA_BY_ID_RESPONSE_TYPE = new TypeReference<SchemaString>(){};
    private static final TypeReference<List<String>> GET_SCHEMA_TYPES_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<JsonNode> GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE = new TypeReference<JsonNode>(){};
    private static final TypeReference<Schema> GET_SCHEMA_BY_VERSION_RESPONSE_TYPE = new TypeReference<Schema>(){};
    private static final TypeReference<List<Integer>> GET_REFERENCED_BY_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final TypeReference<List<Integer>> ALL_VERSIONS_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final TypeReference<List<String>> ALL_CONTEXTS_RESPONSE_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<List<String>> ALL_TOPICS_RESPONSE_TYPE = new TypeReference<List<String>>(){};
    private static final TypeReference<List<SubjectVersion>> GET_VERSIONS_RESPONSE_TYPE = new TypeReference<List<SubjectVersion>>(){};
    private static final TypeReference<CompatibilityCheckResponse> COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE = new TypeReference<CompatibilityCheckResponse>(){};
    private static final TypeReference<Schema> SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE = new TypeReference<Schema>(){};
    private static final TypeReference<ConfigUpdateRequest> UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE = new TypeReference<ConfigUpdateRequest>(){};
    private static final TypeReference<ModeUpdateRequest> UPDATE_MODE_RESPONSE_TYPE_REFERENCE = new TypeReference<ModeUpdateRequest>(){};
    private static final TypeReference<Integer> DELETE_SUBJECT_VERSION_RESPONSE_TYPE = new TypeReference<Integer>(){};
    private static final TypeReference<? extends List<Integer>> DELETE_SUBJECT_RESPONSE_TYPE = new TypeReference<List<Integer>>(){};
    private static final TypeReference<Mode> DELETE_SUBJECT_MODE_RESPONSE_TYPE = new TypeReference<Mode>(){};
    private static final TypeReference<Config> DELETE_SUBJECT_CONFIG_RESPONSE_TYPE = new TypeReference<Config>(){};
    private static final TypeReference<ServerClusterId> GET_CLUSTER_ID_RESPONSE_TYPE = new TypeReference<ServerClusterId>(){};
    private static final TypeReference<SchemaRegistryServerVersion> GET_SR_VERSION_RESPONSE_TYPE = new TypeReference<SchemaRegistryServerVersion>(){};
    private static final int HTTP_CONNECT_TIMEOUT_MS = 60000;
    private static final int HTTP_READ_TIMEOUT_MS = 60000;
    private static final int JSON_PARSE_ERROR_CODE = 50005;
    private static ObjectMapper jsonDeserializer = JacksonMapper.INSTANCE;
    private static final String AUTHORIZATION_HEADER = "Authorization";
    private static final String TARGET_SR_CLUSTER = "target-sr-cluster";
    private static final String TARGET_IDENTITY_POOL_ID = "Confluent-Identity-Pool-Id";
    public static final Map<String, String> DEFAULT_REQUEST_PROPERTIES = Collections.singletonMap("Content-Type", "application/vnd.schemaregistry.v1+json");
    private UrlList baseUrls;
    private SSLSocketFactory sslSocketFactory;
    private HostnameVerifier hostnameVerifier;
    private int httpConnectTimeoutMs = 60000;
    private int httpReadTimeoutMs = 60000;
    private BasicAuthCredentialProvider basicAuthCredentialProvider;
    private BearerAuthCredentialProvider bearerAuthCredentialProvider;
    private Map<String, String> httpHeaders;
    private Proxy proxy;

    public RestService(UrlList baseUrls) {
        this.baseUrls = baseUrls;
    }

    public RestService(List<String> baseUrls) {
        this(new UrlList(baseUrls));
    }

    public RestService(String baseUrlConfig) {
        this(RestService.parseBaseUrl(baseUrlConfig));
    }

    public void configure(Map<String, ?> configs) {
        Integer proxyPort;
        String basicCredentialsSource = (String)configs.get("basic.auth.credentials.source");
        String bearerCredentialsSource = (String)configs.get("bearer.auth.credentials.source");
        if (RestService.isNonEmpty(basicCredentialsSource) && RestService.isNonEmpty(bearerCredentialsSource)) {
            throw new ConfigException(String.format("Only one of '%s' and '%s' may be specified", "basic.auth.credentials.source", "bearer.auth.credentials.source"));
        }
        if (RestService.isNonEmpty(basicCredentialsSource)) {
            BasicAuthCredentialProvider basicAuthCredentialProvider = BasicAuthCredentialProviderFactory.getBasicAuthCredentialProvider(basicCredentialsSource, configs);
            this.setBasicAuthCredentialProvider(basicAuthCredentialProvider);
        } else if (RestService.isNonEmpty(bearerCredentialsSource)) {
            BearerAuthCredentialProvider bearerAuthCredentialProvider = BearerAuthCredentialProviderFactory.getBearerAuthCredentialProvider(bearerCredentialsSource, configs);
            this.setBearerAuthCredentialProvider(bearerAuthCredentialProvider);
        }
        String proxyHost = (String)configs.get("proxy.host");
        Object proxyPortVal = configs.get("proxy.port");
        Integer n = proxyPort = proxyPortVal instanceof String ? Integer.valueOf((String)proxyPortVal) : (Integer)proxyPortVal;
        if (RestService.isValidProxyConfig(proxyHost, proxyPort)) {
            this.setProxy(proxyHost, proxyPort);
        }
    }

    private static boolean isNonEmpty(String s) {
        return s != null && !s.isEmpty();
    }

    private static boolean isValidProxyConfig(String proxyHost, Integer proxyPort) {
        return RestService.isNonEmpty(proxyHost) && proxyPort != null && proxyPort > 0;
    }

    public void setSslSocketFactory(SSLSocketFactory sslSocketFactory) {
        this.sslSocketFactory = sslSocketFactory;
    }

    public void setHostnameVerifier(HostnameVerifier hostnameVerifier) {
        this.hostnameVerifier = hostnameVerifier;
    }

    public void setHttpConnectTimeoutMs(int httpConnectTimeoutMs) {
        this.httpConnectTimeoutMs = httpConnectTimeoutMs;
    }

    public void setHttpReadTimeoutMs(int httpReadTimeoutMs) {
        this.httpReadTimeoutMs = httpReadTimeoutMs;
    }

    private <T> T sendHttpRequest(String requestUrl, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        String requestData = requestBodyData == null ? "null" : new String(requestBodyData, StandardCharsets.UTF_8);
        log.debug(String.format("Sending %s with input %s to %s", method, requestData, requestUrl));
        HttpURLConnection connection = null;
        try {
            ErrorMessage errorMessage;
            InputStream is;
            int responseCode;
            URL url = this.url(requestUrl);
            connection = this.buildConnection(url, method, requestProperties);
            if (requestBodyData != null) {
                connection.setDoOutput(true);
                try (OutputStream os = connection.getOutputStream();){
                    os.write(requestBodyData);
                    os.flush();
                }
                catch (IOException e) {
                    log.error("Failed to send HTTP request to endpoint: " + url, (Throwable)e);
                    throw e;
                }
            }
            if ((responseCode = connection.getResponseCode()) == 200) {
                is = connection.getInputStream();
                Object result = jsonDeserializer.readValue(is, responseFormat);
                is.close();
                Object object = result;
                return (T)object;
            }
            if (responseCode == 204) {
                is = null;
                return (T)is;
            }
            try (InputStream es = connection.getErrorStream();){
                errorMessage = es != null ? (ErrorMessage)jsonDeserializer.readValue(es, ErrorMessage.class) : new ErrorMessage(50005, "Error");
            }
            catch (JsonProcessingException e) {
                errorMessage = new ErrorMessage(50005, e.getMessage());
            }
            throw new RestClientException(errorMessage.getMessage(), responseCode, errorMessage.getErrorCode());
        }
        finally {
            if (connection != null) {
                connection.disconnect();
            }
        }
    }

    private HttpURLConnection buildConnection(URL url, String method, Map<String, String> requestProperties) throws IOException {
        HttpURLConnection connection = null;
        connection = this.proxy == null ? (HttpURLConnection)url.openConnection() : (HttpURLConnection)url.openConnection(this.proxy);
        connection.setConnectTimeout(this.httpConnectTimeoutMs);
        connection.setReadTimeout(this.httpReadTimeoutMs);
        this.setupSsl(connection);
        connection.setRequestMethod(method);
        this.setAuthRequestHeaders(connection);
        this.setCustomHeaders(connection);
        connection.setDoInput(true);
        for (Map.Entry<String, String> entry : requestProperties.entrySet()) {
            connection.setRequestProperty(entry.getKey(), entry.getValue());
        }
        connection.setUseCaches(false);
        return connection;
    }

    private void setupSsl(HttpURLConnection connection) {
        if (connection instanceof HttpsURLConnection && this.sslSocketFactory != null) {
            ((HttpsURLConnection)connection).setSSLSocketFactory(this.sslSocketFactory);
            if (this.hostnameVerifier != null) {
                ((HttpsURLConnection)connection).setHostnameVerifier(this.hostnameVerifier);
            }
        }
    }

    public <T> T httpRequest(String path, String method, byte[] requestBodyData, Map<String, String> requestProperties, TypeReference<T> responseFormat) throws IOException, RestClientException {
        int n = this.baseUrls.size();
        for (int i = 0; i < n; ++i) {
            String baseUrl = this.baseUrls.current();
            String requestUrl = RestService.buildRequestUrl(baseUrl, path);
            try {
                return this.sendHttpRequest(requestUrl, method, requestBodyData, requestProperties, responseFormat);
            }
            catch (IOException e) {
                this.baseUrls.fail(baseUrl);
                if (i != n - 1) continue;
                throw e;
            }
        }
        throw new IOException("Internal HTTP retry error");
    }

    static String buildRequestUrl(String baseUrl, String path) {
        return baseUrl.replaceFirst("/$", "") + "/" + path.replaceFirst("^/", "");
    }

    public Schema lookUpSubjectVersion(String schemaString, String subject) throws IOException, RestClientException {
        return this.lookUpSubjectVersion(schemaString, subject, false);
    }

    public Schema lookUpSubjectVersion(String schemaString, String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        return this.lookUpSubjectVersion(schemaString, subject, false, lookupDeletedSchema);
    }

    public Schema lookUpSubjectVersion(String schemaString, String subject, boolean normalize, boolean lookupDeletedSchema) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.lookUpSubjectVersion(DEFAULT_REQUEST_PROPERTIES, request, subject, normalize, lookupDeletedSchema);
    }

    public Schema lookUpSubjectVersion(String schemaString, String schemaType, List<SchemaReference> references, String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        return this.lookUpSubjectVersion(schemaString, schemaType, references, subject, false, lookupDeletedSchema);
    }

    public Schema lookUpSubjectVersion(String schemaString, String schemaType, List<SchemaReference> references, String subject, boolean normalize, boolean lookupDeletedSchema) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        request.setSchemaType(schemaType);
        request.setReferences(references);
        return this.lookUpSubjectVersion(DEFAULT_REQUEST_PROPERTIES, request, subject, normalize, lookupDeletedSchema);
    }

    public Schema lookUpSubjectVersion(RegisterSchemaRequest registerSchemaRequest, String subject, boolean normalize, boolean lookupDeletedSchema) throws IOException, RestClientException {
        return this.lookUpSubjectVersion(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject, normalize, lookupDeletedSchema);
    }

    public Schema lookUpSubjectVersion(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject, boolean normalize, boolean lookupDeletedSchema) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}").queryParam("normalize", normalize).queryParam("deleted", lookupDeletedSchema);
        String path = builder.build(subject).toString();
        Schema schema = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, SUBJECT_SCHEMA_VERSION_RESPONSE_TYPE_REFERENCE);
        return schema;
    }

    public int registerSchema(String schemaString, String subject) throws IOException, RestClientException {
        return this.registerSchema(schemaString, subject, false);
    }

    public int registerSchema(String schemaString, String subject, boolean normalize) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.registerSchema(request, subject, normalize);
    }

    public int registerSchema(String schemaString, String schemaType, List<SchemaReference> references, String subject) throws IOException, RestClientException {
        return this.registerSchema(schemaString, schemaType, references, subject, false);
    }

    public int registerSchema(String schemaString, String schemaType, List<SchemaReference> references, String subject, boolean normalize) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        request.setSchemaType(schemaType);
        request.setReferences(references);
        return this.registerSchema(request, subject, normalize);
    }

    public int registerSchema(String schemaString, String subject, int version, int id) throws IOException, RestClientException {
        return this.registerSchema(schemaString, subject, version, id, false);
    }

    public int registerSchema(String schemaString, String subject, int version, int id, boolean normalize) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        request.setVersion(version);
        request.setId(id);
        return this.registerSchema(request, subject, normalize);
    }

    public int registerSchema(String schemaString, String schemaType, List<SchemaReference> references, String subject, int version, int id) throws IOException, RestClientException {
        return this.registerSchema(schemaString, schemaType, references, subject, version, id, false);
    }

    public int registerSchema(String schemaString, String schemaType, List<SchemaReference> references, String subject, int version, int id, boolean normalize) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        request.setSchemaType(schemaType);
        request.setReferences(references);
        request.setVersion(version);
        request.setId(id);
        return this.registerSchema(request, subject, normalize);
    }

    public int registerSchema(RegisterSchemaRequest registerSchemaRequest, String subject, boolean normalize) throws IOException, RestClientException {
        return this.registerSchema(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject, normalize);
    }

    public int registerSchema(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject, boolean normalize) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}/versions").queryParam("normalize", normalize);
        String path = builder.build(subject).toString();
        RegisterSchemaResponse response = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, REGISTER_RESPONSE_TYPE);
        return response.getId();
    }

    public List<String> testCompatibility(String schemaString, String subject, boolean verbose) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.testCompatibility(request, subject, null, verbose);
    }

    public List<String> testCompatibility(String schemaString, String subject, String version) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        return this.testCompatibility(request, subject, version, false);
    }

    public List<String> testCompatibility(String schemaString, String schemaType, List<SchemaReference> references, String subject, String version, boolean verbose) throws IOException, RestClientException {
        RegisterSchemaRequest request = new RegisterSchemaRequest();
        request.setSchema(schemaString);
        request.setSchemaType(schemaType);
        request.setReferences(references);
        return this.testCompatibility(request, subject, version, verbose);
    }

    public List<String> testCompatibility(RegisterSchemaRequest registerSchemaRequest, String subject, String version, boolean verbose) throws IOException, RestClientException {
        return this.testCompatibility(DEFAULT_REQUEST_PROPERTIES, registerSchemaRequest, subject, version, verbose);
    }

    public List<String> testCompatibility(Map<String, String> requestProperties, RegisterSchemaRequest registerSchemaRequest, String subject, String version, boolean verbose) throws IOException, RestClientException {
        String path = version != null ? UriBuilder.fromPath("/compatibility/subjects/{subject}/versions/{version}").queryParam("verbose", verbose).build(subject, version).toString() : UriBuilder.fromPath("/compatibility/subjects/{subject}/versions/").queryParam("verbose", verbose).build(subject).toString();
        CompatibilityCheckResponse response = this.httpRequest(path, "POST", registerSchemaRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, COMPATIBILITY_CHECK_RESPONSE_TYPE_REFERENCE);
        if (verbose) {
            return response.getMessages() == null ? Collections.emptyList() : response.getMessages();
        }
        return response.getIsCompatible() ? Collections.emptyList() : Collections.singletonList("Schemas are incompatible");
    }

    public ConfigUpdateRequest updateCompatibility(String compatibility, String subject) throws IOException, RestClientException {
        ConfigUpdateRequest request = new ConfigUpdateRequest();
        request.setCompatibilityLevel(compatibility);
        return this.updateConfig(request, subject);
    }

    public ConfigUpdateRequest updateConfig(ConfigUpdateRequest configUpdateRequest, String subject) throws IOException, RestClientException {
        return this.updateConfig(DEFAULT_REQUEST_PROPERTIES, configUpdateRequest, subject);
    }

    public ConfigUpdateRequest updateConfig(Map<String, String> requestProperties, ConfigUpdateRequest configUpdateRequest, String subject) throws IOException, RestClientException {
        String path = subject != null ? UriBuilder.fromPath("/config/{subject}").build(subject).toString() : "/config";
        ConfigUpdateRequest response = this.httpRequest(path, "PUT", configUpdateRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, UPDATE_CONFIG_RESPONSE_TYPE_REFERENCE);
        return response;
    }

    public Config getConfig(String subject) throws IOException, RestClientException {
        return this.getConfig(DEFAULT_REQUEST_PROPERTIES, subject, false);
    }

    public Config getConfig(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        return this.getConfig(requestProperties, subject, false);
    }

    public Config getConfig(Map<String, String> requestProperties, String subject, boolean defaultToGlobal) throws IOException, RestClientException {
        String path = subject != null ? UriBuilder.fromPath("/config/{subject}").queryParam("defaultToGlobal", defaultToGlobal).build(subject).toString() : "/config";
        Config config = this.httpRequest(path, "GET", null, requestProperties, GET_CONFIG_RESPONSE_TYPE);
        return config;
    }

    public Config deleteConfig(String subject) throws IOException, RestClientException {
        return this.deleteConfig(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public Config deleteConfig(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        String path = subject != null ? UriBuilder.fromPath("/config/{subject}").build(subject).toString() : "/config";
        Config response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_CONFIG_RESPONSE_TYPE);
        return response;
    }

    public ModeUpdateRequest setMode(String mode) throws IOException, RestClientException {
        return this.setMode(mode, null);
    }

    public ModeUpdateRequest setMode(String mode, String subject) throws IOException, RestClientException {
        return this.setMode(mode, subject, false);
    }

    public ModeUpdateRequest setMode(String mode, String subject, boolean force) throws IOException, RestClientException {
        ModeUpdateRequest request = new ModeUpdateRequest();
        request.setMode(mode);
        return this.setMode(DEFAULT_REQUEST_PROPERTIES, request, subject, force);
    }

    public ModeUpdateRequest setMode(Map<String, String> requestProperties, ModeUpdateRequest modeUpdateRequest, String subject, boolean force) throws IOException, RestClientException {
        String path = subject != null ? UriBuilder.fromPath("/mode/{subject}").queryParam("force", force).build(subject).toString() : UriBuilder.fromPath("/mode").queryParam("force", force).build(new Object[0]).toString();
        ModeUpdateRequest response = this.httpRequest(path, "PUT", modeUpdateRequest.toJson().getBytes(StandardCharsets.UTF_8), requestProperties, UPDATE_MODE_RESPONSE_TYPE_REFERENCE);
        return response;
    }

    public Mode getMode() throws IOException, RestClientException {
        return this.getMode(null, false);
    }

    public Mode getMode(String subject) throws IOException, RestClientException {
        return this.getMode(subject, false);
    }

    public Mode getMode(String subject, boolean defaultToGlobal) throws IOException, RestClientException {
        String path = subject != null ? UriBuilder.fromPath("/mode/{subject}").queryParam("defaultToGlobal", defaultToGlobal).build(subject).toString() : "/mode";
        Mode mode = this.httpRequest(path, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_MODE_RESPONSE_TYPE);
        return mode;
    }

    public Mode deleteSubjectMode(String subject) throws IOException, RestClientException {
        return this.deleteSubjectMode(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public Mode deleteSubjectMode(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/mode/{subject}");
        String path = builder.build(subject).toString();
        Mode response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_MODE_RESPONSE_TYPE);
        return response;
    }

    public List<Schema> getSchemas(String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly) throws IOException, RestClientException {
        return this.getSchemas(DEFAULT_REQUEST_PROPERTIES, subjectPrefix, lookupDeletedSchema, latestOnly, null, null);
    }

    public List<Schema> getSchemas(Map<String, String> requestProperties, String subjectPrefix, boolean lookupDeletedSchema, boolean latestOnly, Integer offset, Integer limit) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/schemas");
        if (subjectPrefix != null) {
            builder.queryParam("subjectPrefix", subjectPrefix);
        }
        builder.queryParam("deleted", lookupDeletedSchema);
        builder.queryParam("latestOnly", latestOnly);
        if (offset != null) {
            builder.queryParam("offset", offset);
        }
        if (limit != null) {
            builder.queryParam("limit", limit);
        }
        String path = builder.build(new Object[0]).toString();
        List<Schema> response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMAS_RESPONSE_TYPE);
        return response;
    }

    public SchemaString getId(int id) throws IOException, RestClientException {
        return this.getId(DEFAULT_REQUEST_PROPERTIES, id, null, false);
    }

    public SchemaString getId(int id, boolean fetchMaxId) throws IOException, RestClientException {
        return this.getId(DEFAULT_REQUEST_PROPERTIES, id, null, fetchMaxId);
    }

    public SchemaString getId(int id, String subject) throws IOException, RestClientException {
        return this.getId(DEFAULT_REQUEST_PROPERTIES, id, subject, false);
    }

    public SchemaString getId(int id, String subject, boolean fetchMaxId) throws IOException, RestClientException {
        return this.getId(DEFAULT_REQUEST_PROPERTIES, id, subject, fetchMaxId);
    }

    public SchemaString getId(Map<String, String> requestProperties, int id) throws IOException, RestClientException {
        return this.getId(requestProperties, id, null, false);
    }

    public SchemaString getId(Map<String, String> requestProperties, int id, String subject) throws IOException, RestClientException {
        return this.getId(requestProperties, id, subject, false);
    }

    public SchemaString getId(Map<String, String> requestProperties, int id, String subject, boolean fetchMaxId) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/schemas/ids/{id}").queryParam("fetchMaxId", fetchMaxId);
        if (subject != null) {
            builder.queryParam("subject", subject);
        }
        String path = builder.build(id).toString();
        SchemaString response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_ID_RESPONSE_TYPE);
        return response;
    }

    public String getOnlySchemaById(int id) throws RestClientException, IOException {
        return this.getOnlySchemaById(DEFAULT_REQUEST_PROPERTIES, id, null);
    }

    public String getOnlySchemaById(Map<String, String> requestProperties, int id, String subject) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/schemas/ids/{id}/schema");
        if (subject != null) {
            builder.queryParam("subject", subject);
        }
        String path = builder.build(id).toString();
        JsonNode response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public List<String> getSchemaTypes() throws IOException, RestClientException {
        return this.getSchemaTypes(DEFAULT_REQUEST_PROPERTIES);
    }

    public List<String> getSchemaTypes(Map<String, String> requestProperties) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/schemas/types");
        String path = builder.toString();
        List<String> response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_TYPES_TYPE);
        return response;
    }

    public Schema getVersion(String subject, int version) throws IOException, RestClientException {
        return this.getVersion(DEFAULT_REQUEST_PROPERTIES, subject, version, false);
    }

    public Schema getVersion(String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        return this.getVersion(DEFAULT_REQUEST_PROPERTIES, subject, version, lookupDeletedSchema);
    }

    public Schema getVersion(Map<String, String> requestProperties, String subject, int version) throws IOException, RestClientException {
        return this.getVersion(requestProperties, subject, version, false);
    }

    public Schema getVersion(Map<String, String> requestProperties, String subject, int version, boolean lookupDeletedSchema) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}/versions/{version}").queryParam("deleted", lookupDeletedSchema);
        String path = builder.build(subject, version).toString();
        Schema response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public Schema getLatestVersion(String subject) throws IOException, RestClientException {
        return this.getLatestVersion(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public Schema getLatestVersion(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}/versions/latest");
        String path = builder.build(subject).toString();
        Schema response = this.httpRequest(path, "GET", null, requestProperties, GET_SCHEMA_BY_VERSION_RESPONSE_TYPE);
        return response;
    }

    public String getVersionSchemaOnly(String subject, int version) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}/versions/{version}/schema");
        String path = builder.build(subject, version).toString();
        JsonNode response = this.httpRequest(path, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public String getLatestVersionSchemaOnly(String subject) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}/versions/latest/schema");
        String path = builder.build(subject).toString();
        JsonNode response = this.httpRequest(path, "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SCHEMA_ONLY_BY_VERSION_RESPONSE_TYPE);
        return response.toString();
    }

    public List<Integer> getReferencedBy(String subject, int version) throws IOException, RestClientException {
        return this.getReferencedBy(DEFAULT_REQUEST_PROPERTIES, subject, version);
    }

    public List<Integer> getReferencedBy(Map<String, String> requestProperties, String subject, int version) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}/versions/{version}/referencedby");
        String path = builder.build(subject, version).toString();
        List<Integer> response = this.httpRequest(path, "GET", null, requestProperties, GET_REFERENCED_BY_RESPONSE_TYPE);
        return response;
    }

    public List<Integer> getAllVersions(String subject) throws IOException, RestClientException {
        return this.getAllVersions(DEFAULT_REQUEST_PROPERTIES, subject);
    }

    public List<Integer> getAllVersions(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        return this.getAllVersions(requestProperties, subject, false, false);
    }

    public List<Integer> getAllVersions(Map<String, String> requestProperties, String subject, boolean lookupDeletedSchema) throws IOException, RestClientException {
        return this.getAllVersions(requestProperties, subject, lookupDeletedSchema, false);
    }

    public List<Integer> getAllVersions(Map<String, String> requestProperties, String subject, boolean lookupDeletedSchema, boolean lookupDeletedOnlySchema) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}/versions");
        builder.queryParam("deleted", lookupDeletedSchema);
        builder.queryParam("deletedOnly", lookupDeletedOnlySchema);
        String path = builder.build(subject).toString();
        List<Integer> response = this.httpRequest(path, "GET", null, requestProperties, ALL_VERSIONS_RESPONSE_TYPE);
        return response;
    }

    public List<Integer> getDeletedOnlyVersions(String subject) throws IOException, RestClientException {
        return this.getAllVersions(DEFAULT_REQUEST_PROPERTIES, subject, false, true);
    }

    public List<String> getAllContexts() throws IOException, RestClientException {
        return this.getAllContexts(DEFAULT_REQUEST_PROPERTIES);
    }

    public List<String> getAllContexts(Map<String, String> requestProperties) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/contexts");
        String path = builder.build(new Object[0]).toString();
        List<String> response = this.httpRequest(path, "GET", null, requestProperties, ALL_CONTEXTS_RESPONSE_TYPE);
        return response;
    }

    public List<String> getAllSubjects() throws IOException, RestClientException {
        return this.getAllSubjects(DEFAULT_REQUEST_PROPERTIES);
    }

    public List<String> getAllSubjects(boolean deletedSubjects) throws IOException, RestClientException {
        return this.getAllSubjects(DEFAULT_REQUEST_PROPERTIES, null, deletedSubjects);
    }

    public List<String> getAllSubjects(String subjectPrefix, boolean deletedSubjects) throws IOException, RestClientException {
        return this.getAllSubjects(DEFAULT_REQUEST_PROPERTIES, subjectPrefix, deletedSubjects);
    }

    public List<String> getAllSubjects(Map<String, String> requestProperties) throws IOException, RestClientException {
        List<String> response = this.httpRequest("/subjects", "GET", null, requestProperties, ALL_TOPICS_RESPONSE_TYPE);
        return response;
    }

    public List<String> getAllSubjects(Map<String, String> requestProperties, String subjectPrefix, boolean deletedSubjects) throws IOException, RestClientException {
        return this.getAllSubjects(requestProperties, subjectPrefix, deletedSubjects, false);
    }

    public List<String> getAllSubjects(Map<String, String> requestProperties, String subjectPrefix, boolean deletedSubjects, boolean deletedOnlySubjects) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects");
        builder.queryParam("deleted", deletedSubjects);
        builder.queryParam("deletedOnly", deletedOnlySubjects);
        if (subjectPrefix != null) {
            builder.queryParam("subjectPrefix", subjectPrefix);
        }
        String path = builder.build(new Object[0]).toString();
        List<String> response = this.httpRequest(path, "GET", null, requestProperties, ALL_TOPICS_RESPONSE_TYPE);
        return response;
    }

    public List<String> getDeletedOnlySubjects(String subjectPrefix) throws IOException, RestClientException {
        return this.getAllSubjects(DEFAULT_REQUEST_PROPERTIES, subjectPrefix, false, true);
    }

    public List<String> getAllSubjectsById(int id) throws IOException, RestClientException {
        return this.getAllSubjectsById(DEFAULT_REQUEST_PROPERTIES, id, null);
    }

    public List<String> getAllSubjectsById(int id, String subject) throws IOException, RestClientException {
        return this.getAllSubjectsById(DEFAULT_REQUEST_PROPERTIES, id, subject);
    }

    public List<String> getAllSubjectsById(int id, String subject, boolean deleted) throws IOException, RestClientException {
        return this.getAllSubjectsById(DEFAULT_REQUEST_PROPERTIES, id, subject, deleted);
    }

    public List<String> getAllSubjectsById(Map<String, String> requestProperties, int id) throws IOException, RestClientException {
        return this.getAllSubjectsById(requestProperties, id, null, false);
    }

    public List<String> getAllSubjectsById(Map<String, String> requestProperties, int id, String subject) throws IOException, RestClientException {
        return this.getAllSubjectsById(requestProperties, id, subject, false);
    }

    public List<String> getAllSubjectsById(Map<String, String> requestProperties, int id, String subject, boolean lookupDeleted) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/schemas/ids/{id}/subjects");
        builder.queryParam("deleted", lookupDeleted);
        if (subject != null) {
            builder.queryParam("subject", subject);
        }
        String path = builder.build(id).toString();
        List<String> response = this.httpRequest(path, "GET", null, requestProperties, ALL_TOPICS_RESPONSE_TYPE);
        return response;
    }

    public List<SubjectVersion> getAllVersionsById(int id) throws IOException, RestClientException {
        return this.getAllVersionsById(DEFAULT_REQUEST_PROPERTIES, id, null);
    }

    public List<SubjectVersion> getAllVersionsById(int id, String subject) throws IOException, RestClientException {
        return this.getAllVersionsById(DEFAULT_REQUEST_PROPERTIES, id, subject);
    }

    public List<SubjectVersion> getAllVersionsById(int id, String subject, boolean deleted) throws IOException, RestClientException {
        return this.getAllVersionsById(DEFAULT_REQUEST_PROPERTIES, id, subject, deleted);
    }

    public List<SubjectVersion> getAllVersionsById(Map<String, String> requestProperties, int id) throws IOException, RestClientException {
        return this.getAllVersionsById(requestProperties, id, null, false);
    }

    public List<SubjectVersion> getAllVersionsById(Map<String, String> requestProperties, int id, String subject) throws IOException, RestClientException {
        return this.getAllVersionsById(requestProperties, id, subject, false);
    }

    public List<SubjectVersion> getAllVersionsById(Map<String, String> requestProperties, int id, String subject, boolean lookupDeleted) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/schemas/ids/{id}/versions");
        builder.queryParam("deleted", lookupDeleted);
        if (subject != null) {
            builder.queryParam("subject", subject);
        }
        String path = builder.build(id).toString();
        List<SubjectVersion> response = this.httpRequest(path, "GET", null, requestProperties, GET_VERSIONS_RESPONSE_TYPE);
        return response;
    }

    public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}/versions/{version}");
        String path = builder.build(subject, version).toString();
        Integer response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_VERSION_RESPONSE_TYPE);
        return response;
    }

    public Integer deleteSchemaVersion(Map<String, String> requestProperties, String subject, String version, boolean permanentDelete) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}/versions/{version}");
        builder.queryParam("permanent", permanentDelete);
        String path = builder.build(subject, version).toString();
        Integer response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_VERSION_RESPONSE_TYPE);
        return response;
    }

    public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}");
        String path = builder.build(subject).toString();
        List<Integer> response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_RESPONSE_TYPE);
        return response;
    }

    public List<Integer> deleteSubject(Map<String, String> requestProperties, String subject, boolean permanentDelete) throws IOException, RestClientException {
        UriBuilder builder = UriBuilder.fromPath("/subjects/{subject}");
        builder.queryParam("permanent", permanentDelete);
        String path = builder.build(subject).toString();
        List<Integer> response = this.httpRequest(path, "DELETE", null, requestProperties, DELETE_SUBJECT_RESPONSE_TYPE);
        return response;
    }

    public ServerClusterId getClusterId() throws IOException, RestClientException {
        return this.getClusterId(DEFAULT_REQUEST_PROPERTIES);
    }

    public ServerClusterId getClusterId(Map<String, String> requestProperties) throws IOException, RestClientException {
        return this.httpRequest("/v1/metadata/id", "GET", null, requestProperties, GET_CLUSTER_ID_RESPONSE_TYPE);
    }

    public SchemaRegistryServerVersion getSchemaRegistryServerVersion() throws IOException, RestClientException {
        return this.httpRequest("/v1/metadata/version", "GET", null, DEFAULT_REQUEST_PROPERTIES, GET_SR_VERSION_RESPONSE_TYPE);
    }

    private static List<String> parseBaseUrl(String baseUrl) {
        List<String> baseUrls = Arrays.asList(baseUrl.split("\\s*,\\s*"));
        if (baseUrls.isEmpty()) {
            throw new IllegalArgumentException("Missing required schema registry url list");
        }
        return baseUrls;
    }

    public UrlList getBaseUrls() {
        return this.baseUrls;
    }

    private void setAuthRequestHeaders(HttpURLConnection connection) {
        String userInfo;
        if (this.basicAuthCredentialProvider != null && (userInfo = this.basicAuthCredentialProvider.getUserInfo(connection.getURL())) != null) {
            String authHeader = Base64.getEncoder().encodeToString(userInfo.getBytes(StandardCharsets.UTF_8));
            connection.setRequestProperty(AUTHORIZATION_HEADER, "Basic " + authHeader);
        }
        if (this.bearerAuthCredentialProvider != null) {
            String targetSchemaRegistry;
            String targetIdentityPoolId;
            String bearerToken = this.bearerAuthCredentialProvider.getBearerToken(connection.getURL());
            if (bearerToken != null) {
                connection.setRequestProperty(AUTHORIZATION_HEADER, "Bearer " + bearerToken);
            }
            if ((targetIdentityPoolId = this.bearerAuthCredentialProvider.getTargetIdentityPoolId()) != null) {
                connection.setRequestProperty(TARGET_IDENTITY_POOL_ID, targetIdentityPoolId);
            }
            if ((targetSchemaRegistry = this.bearerAuthCredentialProvider.getTargetSchemaRegistry()) != null) {
                connection.setRequestProperty(TARGET_SR_CLUSTER, targetSchemaRegistry);
            }
        }
    }

    private void setCustomHeaders(HttpURLConnection connection) {
        if (this.httpHeaders != null) {
            this.httpHeaders.forEach((k, v) -> connection.setRequestProperty((String)k, (String)v));
        }
    }

    public void setBasicAuthCredentialProvider(BasicAuthCredentialProvider basicAuthCredentialProvider) {
        this.basicAuthCredentialProvider = basicAuthCredentialProvider;
    }

    public void setBearerAuthCredentialProvider(BearerAuthCredentialProvider bearerAuthCredentialProvider) {
        this.bearerAuthCredentialProvider = bearerAuthCredentialProvider;
    }

    public void setHttpHeaders(Map<String, String> httpHeaders) {
        this.httpHeaders = httpHeaders;
    }

    public void setProxy(String proxyHost, int proxyPort) {
        this.proxy = new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyHost, proxyPort));
    }

    URL url(String requestUrl) throws MalformedURLException {
        return new URL(requestUrl);
    }
}

