/*
 * Decompiled with CFR 0.152.
 */
package io.trino.plugin.jdbc.expression;

import com.google.common.collect.ImmutableList;
import io.trino.matching.Captures;
import io.trino.matching.Pattern;
import io.trino.matching.Property;
import io.trino.plugin.jdbc.expression.MatchContext;
import io.trino.plugin.jdbc.expression.TypeParameterPattern;
import io.trino.plugin.jdbc.expression.TypePattern;
import io.trino.spi.type.Type;
import io.trino.spi.type.TypeSignatureParameter;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class SimpleTypePattern
implements TypePattern {
    private final String baseName;
    private final List<TypeParameterPattern> parameters;
    private final Pattern<Type> pattern;

    public SimpleTypePattern(String baseName, List<TypeParameterPattern> parameters) {
        this.baseName = Objects.requireNonNull(baseName, "baseName is null");
        this.parameters = ImmutableList.copyOf((Collection)Objects.requireNonNull(parameters, "parameters is null"));
        Pattern pattern = Pattern.typeOf(Type.class).with(SimpleTypePattern.baseName().equalTo((Object)baseName));
        for (int i = 0; i < parameters.size(); ++i) {
            pattern = pattern.with(SimpleTypePattern.parameter(i).matching(parameters.get(i).getPattern()));
        }
        this.pattern = pattern;
    }

    @Override
    public Pattern<Type> getPattern() {
        return this.pattern;
    }

    @Override
    public void resolve(Captures captures, MatchContext matchContext) {
        for (TypeParameterPattern parameter : this.parameters) {
            parameter.resolve(captures, matchContext);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTypePattern that = (SimpleTypePattern)o;
        return Objects.equals(this.baseName, that.baseName) && Objects.equals(this.parameters, that.parameters);
    }

    public int hashCode() {
        return Objects.hash(this.baseName, this.parameters);
    }

    public String toString() {
        if (this.parameters.isEmpty()) {
            return this.baseName;
        }
        return String.format("%s(%s)", this.baseName, this.parameters.stream().map(Object::toString).collect(Collectors.joining(", ")));
    }

    private static Property<Type, ?, String> baseName() {
        return Property.property((String)"baseName", Type::getBaseName);
    }

    private static Property<Type, ?, TypeSignatureParameter> parameter(int i) {
        return Property.property((String)String.format("parameter(%s)", i), type -> (TypeSignatureParameter)type.getTypeSignature().getParameters().get(i));
    }
}

