/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader.flat;

import io.trino.parquet.DictionaryPage;
import io.trino.parquet.reader.SimpleSliceInputStream;
import io.trino.parquet.reader.decoders.RleBitPackingHybridDecoder;
import io.trino.parquet.reader.decoders.ValueDecoder;
import io.trino.parquet.reader.flat.ColumnAdapter;
import io.trino.spi.block.Block;
import jakarta.annotation.Nullable;
import java.util.Objects;

public final class DictionaryDecoder<T>
implements ValueDecoder<T> {
    private final T dictionary;
    private final ColumnAdapter<T> columnAdapter;
    private final int dictionarySize;
    private final boolean isNonNull;
    private final long retainedSizeInBytes;
    private ValueDecoder<int[]> dictionaryIdsReader;
    @Nullable
    private Block dictionaryBlock;

    public DictionaryDecoder(T dictionary, ColumnAdapter<T> columnAdapter, int dictionarySize, boolean isNonNull) {
        this.columnAdapter = Objects.requireNonNull(columnAdapter, "columnAdapter is null");
        this.dictionary = Objects.requireNonNull(dictionary, "dictionary is null");
        this.dictionarySize = dictionarySize;
        this.isNonNull = isNonNull;
        this.retainedSizeInBytes = columnAdapter.getSizeInBytes(dictionary);
    }

    @Override
    public void init(SimpleSliceInputStream input) {
        byte bitWidth = input.readByte();
        this.dictionaryIdsReader = new RleBitPackingHybridDecoder(bitWidth);
        this.dictionaryIdsReader.init(input);
    }

    @Override
    public void read(T values, int offset, int length) {
        int[] ids = new int[length];
        this.dictionaryIdsReader.read(ids, 0, length);
        this.columnAdapter.decodeDictionaryIds(values, offset, length, ids, this.dictionary);
    }

    @Override
    public void skip(int n) {
        this.dictionaryIdsReader.skip(n);
    }

    public long getRetainedSizeInBytes() {
        return this.retainedSizeInBytes;
    }

    public void readDictionaryIds(int[] ids, int offset, int length) {
        this.dictionaryIdsReader.read(ids, offset, length);
    }

    public Block getDictionaryBlock() {
        if (this.dictionaryBlock == null) {
            this.dictionaryBlock = this.isNonNull ? this.columnAdapter.createNonNullBlock(this.dictionary) : this.columnAdapter.createNullableDictionaryBlock(this.dictionary, this.dictionarySize);
        }
        return this.dictionaryBlock;
    }

    public int getDictionarySize() {
        return this.dictionarySize;
    }

    public static <BufferType> DictionaryDecoder<BufferType> getDictionaryDecoder(DictionaryPage dictionaryPage, ColumnAdapter<BufferType> columnAdapter, ValueDecoder<BufferType> plainValuesDecoder, boolean isNonNull) {
        int size = dictionaryPage.getDictionarySize();
        BufferType dictionary = columnAdapter.createBuffer(size + (isNonNull ? 0 : 1));
        plainValuesDecoder.init(new SimpleSliceInputStream(dictionaryPage.getSlice()));
        plainValuesDecoder.read(dictionary, 0, size);
        return new DictionaryDecoder<BufferType>(dictionary, columnAdapter, size, isNonNull);
    }

    public static interface DictionaryDecoderProvider<T> {
        public DictionaryDecoder<T> create(DictionaryPage var1, boolean var2);
    }
}

