/*
 * Decompiled with CFR 0.152.
 */
package io.trino.parquet.reader;

import com.google.common.base.Preconditions;
import io.trino.spi.block.Block;
import io.trino.spi.block.LazyBlock;
import io.trino.spi.block.LazyBlockLoader;
import java.io.IOException;
import java.util.Objects;
import java.util.function.Function;

public class ParquetBlockFactory {
    private final Function<Exception, RuntimeException> exceptionTransform;
    private int currentPageId;

    public ParquetBlockFactory(Function<Exception, RuntimeException> exceptionTransform) {
        this.exceptionTransform = Objects.requireNonNull(exceptionTransform, "exceptionTransform is null");
    }

    public void nextPage() {
        ++this.currentPageId;
    }

    public Block createBlock(int positionCount, ParquetBlockReader reader) {
        return new LazyBlock(positionCount, (LazyBlockLoader)new ParquetBlockLoader(reader));
    }

    private final class ParquetBlockLoader
    implements LazyBlockLoader {
        private final int expectedPageId;
        private final ParquetBlockReader blockReader;
        private boolean loaded;

        public ParquetBlockLoader(ParquetBlockReader blockReader) {
            this.expectedPageId = ParquetBlockFactory.this.currentPageId;
            this.blockReader = Objects.requireNonNull(blockReader, "blockReader is null");
        }

        public Block load() {
            Preconditions.checkState((!this.loaded ? 1 : 0) != 0, (Object)"Already loaded");
            Preconditions.checkState((ParquetBlockFactory.this.currentPageId == this.expectedPageId ? 1 : 0) != 0, (Object)"Parquet reader has been advanced beyond block");
            this.loaded = true;
            try {
                return this.blockReader.readBlock();
            }
            catch (IOException | RuntimeException e) {
                throw ParquetBlockFactory.this.exceptionTransform.apply(e);
            }
        }
    }

    public static interface ParquetBlockReader {
        public Block readBlock() throws IOException;
    }
}

