/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi.store;

import com.google.common.base.Preconditions;

public class ColumnIndexUtils {
    public static final String MAP_KEY_SEPARATOR = ".";
    public static final String MAP_KEY_NAME_START_OFFSET = "startOffset";
    public static final String MAP_KEY_NAME_SIZE = "size";

    private ColumnIndexUtils() {
    }

    public static String[] parseIndexMapKeys(String key, String segmentDir) {
        int lastSeparatorPos = key.lastIndexOf(MAP_KEY_SEPARATOR);
        Preconditions.checkState((lastSeparatorPos != -1 ? 1 : 0) != 0, (Object)("Key separator not found: " + key + ", segment: " + segmentDir));
        String propertyName = key.substring(lastSeparatorPos + 1);
        int indexSeparatorPos = key.lastIndexOf(MAP_KEY_SEPARATOR, lastSeparatorPos - 1);
        Preconditions.checkState((indexSeparatorPos != -1 ? 1 : 0) != 0, (Object)("Index separator not found: " + key + " , segment: " + segmentDir));
        String indexName = key.substring(indexSeparatorPos + 1, lastSeparatorPos);
        String columnName = key.substring(0, indexSeparatorPos);
        return new String[]{columnName, indexName, propertyName};
    }
}

