/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.segment.spi;

import java.util.Arrays;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang.StringUtils;

public enum AggregationFunctionType {
    COUNT("count"),
    MIN("min"),
    MAX("max"),
    SUM("sum"),
    SUMPRECISION("sumPrecision"),
    AVG("avg"),
    MODE("mode"),
    FIRSTWITHTIME("firstWithTime"),
    LASTWITHTIME("lastWithTime"),
    MINMAXRANGE("minMaxRange"),
    DISTINCTCOUNT("distinctCount"),
    DISTINCTCOUNTBITMAP("distinctCountBitmap"),
    SEGMENTPARTITIONEDDISTINCTCOUNT("segmentPartitionedDistinctCount"),
    DISTINCTCOUNTHLL("distinctCountHLL"),
    DISTINCTCOUNTRAWHLL("distinctCountRawHLL"),
    DISTINCTCOUNTSMARTHLL("distinctCountSmartHLL"),
    FASTHLL("fastHLL"),
    DISTINCTCOUNTTHETASKETCH("distinctCountThetaSketch"),
    DISTINCTCOUNTRAWTHETASKETCH("distinctCountRawThetaSketch"),
    PERCENTILE("percentile"),
    PERCENTILEEST("percentileEst"),
    PERCENTILERAWEST("percentileRawEst"),
    PERCENTILETDIGEST("percentileTDigest"),
    PERCENTILERAWTDIGEST("percentileRawTDigest"),
    PERCENTILESMARTTDIGEST("percentileSmartTDigest"),
    IDSET("idSet"),
    HISTOGRAM("histogram"),
    COVARPOP("covarPop"),
    COVARSAMP("covarSamp"),
    VARPOP("varPop"),
    VARSAMP("varSamp"),
    STDDEVPOP("stdDevPop"),
    STDDEVSAMP("stdDevSamp"),
    SKEWNESS("skewness"),
    KURTOSIS("kurtosis"),
    STUNION("STUnion"),
    COUNTMV("countMV"),
    MINMV("minMV"),
    MAXMV("maxMV"),
    SUMMV("sumMV"),
    AVGMV("avgMV"),
    MINMAXRANGEMV("minMaxRangeMV"),
    DISTINCTCOUNTMV("distinctCountMV"),
    DISTINCTCOUNTBITMAPMV("distinctCountBitmapMV"),
    DISTINCTCOUNTHLLMV("distinctCountHLLMV"),
    DISTINCTCOUNTRAWHLLMV("distinctCountRawHLLMV"),
    PERCENTILEMV("percentileMV"),
    PERCENTILEESTMV("percentileEstMV"),
    PERCENTILERAWESTMV("percentileRawEstMV"),
    PERCENTILETDIGESTMV("percentileTDigestMV"),
    PERCENTILERAWTDIGESTMV("percentileRawTDigestMV"),
    DISTINCT("distinct"),
    BOOLAND("boolAnd"),
    BOOLOR("boolOr");

    private static final Set<String> NAMES;
    private final String _name;

    private AggregationFunctionType(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public static boolean isAggregationFunction(String functionName) {
        if (NAMES.contains(functionName)) {
            return true;
        }
        if (functionName.regionMatches(true, 0, "percentile", 0, 10)) {
            try {
                AggregationFunctionType.getAggregationFunctionType(functionName);
                return true;
            }
            catch (Exception ignore) {
                return false;
            }
        }
        String upperCaseFunctionName = StringUtils.remove((String)functionName, (char)'_').toUpperCase();
        return NAMES.contains(upperCaseFunctionName);
    }

    public static AggregationFunctionType getAggregationFunctionType(String functionName) {
        if (functionName.regionMatches(true, 0, "percentile", 0, 10)) {
            String remainingFunctionName = StringUtils.remove((String)functionName, (char)'_').substring(10).toUpperCase();
            if (remainingFunctionName.isEmpty() || remainingFunctionName.matches("\\d+")) {
                return PERCENTILE;
            }
            if (remainingFunctionName.equals("EST") || remainingFunctionName.matches("EST\\d+")) {
                return PERCENTILEEST;
            }
            if (remainingFunctionName.equals("RAWEST") || remainingFunctionName.matches("RAWEST\\d+")) {
                return PERCENTILERAWEST;
            }
            if (remainingFunctionName.equals("TDIGEST") || remainingFunctionName.matches("TDIGEST\\d+")) {
                return PERCENTILETDIGEST;
            }
            if (remainingFunctionName.equals("RAWTDIGEST") || remainingFunctionName.matches("RAWTDIGEST\\d+")) {
                return PERCENTILERAWTDIGEST;
            }
            if (remainingFunctionName.equals("MV") || remainingFunctionName.matches("\\d+MV")) {
                return PERCENTILEMV;
            }
            if (remainingFunctionName.equals("ESTMV") || remainingFunctionName.matches("EST\\d+MV")) {
                return PERCENTILEESTMV;
            }
            if (remainingFunctionName.equals("RAWESTMV") || remainingFunctionName.matches("RAWEST\\d+MV")) {
                return PERCENTILERAWESTMV;
            }
            if (remainingFunctionName.equals("TDIGESTMV") || remainingFunctionName.matches("TDIGEST\\d+MV")) {
                return PERCENTILETDIGESTMV;
            }
            if (remainingFunctionName.equals("RAWTDIGESTMV") || remainingFunctionName.matches("RAWTDIGEST\\d+MV")) {
                return PERCENTILERAWTDIGESTMV;
            }
            throw new IllegalArgumentException("Invalid aggregation function name: " + functionName);
        }
        try {
            return AggregationFunctionType.valueOf(StringUtils.remove((String)functionName, (char)'_').toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException("Invalid aggregation function name: " + functionName);
        }
    }

    static {
        NAMES = Arrays.stream(AggregationFunctionType.values()).flatMap(func -> Stream.of(func.name(), func.getName(), func.getName().toLowerCase())).collect(Collectors.toSet());
    }
}

