/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.server.access;

import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.pinot.core.auth.BasicAuthPrincipal;
import org.apache.pinot.core.auth.BasicAuthUtils;
import org.apache.pinot.server.access.AccessControl;
import org.apache.pinot.server.access.AccessControlFactory;
import org.apache.pinot.server.access.GrpcRequesterIdentity;
import org.apache.pinot.server.access.HttpRequesterIdentity;
import org.apache.pinot.server.access.RequesterIdentity;
import org.apache.pinot.spi.env.PinotConfiguration;
import org.apache.pinot.spi.utils.builder.TableNameBuilder;

public class BasicAuthAccessFactory
implements AccessControlFactory {
    private static final String PREFIX = "principals";
    private static final String AUTHORIZATION_KEY = "authorization";
    private AccessControl _accessControl;

    @Override
    public void init(PinotConfiguration configuration) {
        this._accessControl = new BasicAuthAccessControl(BasicAuthUtils.extractBasicAuthPrincipals(configuration, PREFIX));
    }

    @Override
    public AccessControl create() {
        return this._accessControl;
    }

    private static class BasicAuthAccessControl
    implements AccessControl {
        private final Map<String, BasicAuthPrincipal> _token2principal;

        public BasicAuthAccessControl(Collection<BasicAuthPrincipal> principals) {
            this._token2principal = principals.stream().collect(Collectors.toMap(BasicAuthPrincipal::getToken, p -> p));
        }

        @Override
        public boolean isAuthorizedChannel(ChannelHandlerContext channelHandlerContext) {
            return true;
        }

        @Override
        public boolean hasDataAccess(RequesterIdentity requesterIdentity, String tableName) {
            Collection<String> tokens = this.getTokens(requesterIdentity);
            return tokens.stream().map(BasicAuthUtils::normalizeBase64Token).map(this._token2principal::get).filter(Objects::nonNull).findFirst().map(principal -> StringUtils.isEmpty((String)tableName) || principal.hasTable(TableNameBuilder.extractRawTableName((String)tableName))).orElse(false);
        }

        private Collection<String> getTokens(RequesterIdentity requesterIdentity) {
            if (requesterIdentity instanceof GrpcRequesterIdentity) {
                GrpcRequesterIdentity identity = (GrpcRequesterIdentity)requesterIdentity;
                return identity.getGrpcMetadata().get((Object)BasicAuthAccessFactory.AUTHORIZATION_KEY);
            }
            if (requesterIdentity instanceof HttpRequesterIdentity) {
                HttpRequesterIdentity identity = (HttpRequesterIdentity)requesterIdentity;
                return identity.getHttpHeaders().get((Object)BasicAuthAccessFactory.AUTHORIZATION_KEY);
            }
            throw new UnsupportedOperationException("GrpcRequesterIdentity or HttpRequesterIdentity is required");
        }
    }
}

