/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport.server.routing.stats;

import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.pinot.common.utils.ExponentialMovingAverage;

public class ServerRoutingStatsEntry {
    String _serverInstanceId;
    private final ReentrantReadWriteLock _serverLock;
    private volatile int _numInFlightRequests;
    private final ExponentialMovingAverage _inFlighRequestsEMA;
    private final ExponentialMovingAverage _latencyMsEMA;
    private final int _hybridScoreExponent;

    public ServerRoutingStatsEntry(String serverInstanceId, double alphaEMA, long autoDecayWindowMsEMA, long warmupDurationMsEMA, double avgInitializationValEMA, int scoreExponent, ScheduledExecutorService periodicTaskExecutor) {
        this._serverInstanceId = serverInstanceId;
        this._serverLock = new ReentrantReadWriteLock();
        this._inFlighRequestsEMA = new ExponentialMovingAverage(alphaEMA, autoDecayWindowMsEMA, warmupDurationMsEMA, avgInitializationValEMA, periodicTaskExecutor);
        this._latencyMsEMA = new ExponentialMovingAverage(alphaEMA, autoDecayWindowMsEMA, warmupDurationMsEMA, avgInitializationValEMA, periodicTaskExecutor);
        this._hybridScoreExponent = scoreExponent;
    }

    public ReentrantReadWriteLock.ReadLock getServerReadLock() {
        return this._serverLock.readLock();
    }

    public ReentrantReadWriteLock.WriteLock getServerWriteLock() {
        return this._serverLock.writeLock();
    }

    public Integer getNumInFlightRequests() {
        return this._numInFlightRequests;
    }

    public Double getInFlightRequestsEMA() {
        return this._inFlighRequestsEMA.getAverage();
    }

    public Double getLatencyEMA() {
        return this._latencyMsEMA.getAverage();
    }

    public double computeHybridScore() {
        double estimatedQSize = (double)this._numInFlightRequests + this._inFlighRequestsEMA.getAverage();
        return Math.pow(estimatedQSize, this._hybridScoreExponent) * this._latencyMsEMA.getAverage();
    }

    public void updateNumInFlightRequestsForQuerySubmission() {
        ++this._numInFlightRequests;
        this._inFlighRequestsEMA.compute((double)this._numInFlightRequests);
    }

    public void updateNumInFlightRequestsForResponseArrival() {
        --this._numInFlightRequests;
    }

    public void updateLatency(double latencyMs) {
        this._latencyMsEMA.compute(latencyMs);
    }
}

