/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.transport;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeoutException;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.pinot.common.config.NettyConfig;
import org.apache.pinot.common.config.TlsConfig;
import org.apache.pinot.common.datatable.DataTable;
import org.apache.pinot.common.metrics.AbstractMetrics;
import org.apache.pinot.common.metrics.BrokerMeter;
import org.apache.pinot.common.metrics.BrokerMetrics;
import org.apache.pinot.common.request.BrokerRequest;
import org.apache.pinot.common.request.InstanceRequest;
import org.apache.pinot.core.transport.AsyncQueryResponse;
import org.apache.pinot.core.transport.ServerChannels;
import org.apache.pinot.core.transport.ServerInstance;
import org.apache.pinot.core.transport.ServerRoutingInstance;
import org.apache.pinot.core.transport.server.routing.stats.ServerRoutingStatsManager;
import org.apache.pinot.spi.config.table.TableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public class QueryRouter {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryRouter.class);
    private final String _brokerId;
    private final BrokerMetrics _brokerMetrics;
    private final ServerChannels _serverChannels;
    private final ServerChannels _serverChannelsTls;
    private final ConcurrentHashMap<Long, AsyncQueryResponse> _asyncQueryResponseMap = new ConcurrentHashMap();
    private final ServerRoutingStatsManager _serverRoutingStatsManager;

    public QueryRouter(String brokerId, BrokerMetrics brokerMetrics, ServerRoutingStatsManager serverRoutingStatsManager) {
        this(brokerId, brokerMetrics, null, null, serverRoutingStatsManager);
    }

    public QueryRouter(String brokerId, BrokerMetrics brokerMetrics, @Nullable NettyConfig nettyConfig, @Nullable TlsConfig tlsConfig, ServerRoutingStatsManager serverRoutingStatsManager) {
        this._brokerId = brokerId;
        this._brokerMetrics = brokerMetrics;
        this._serverChannels = new ServerChannels(this, brokerMetrics, nettyConfig, null);
        this._serverChannelsTls = tlsConfig != null ? new ServerChannels(this, brokerMetrics, nettyConfig, tlsConfig) : null;
        this._serverRoutingStatsManager = serverRoutingStatsManager;
    }

    public AsyncQueryResponse submitQuery(long requestId, String rawTableName, @Nullable BrokerRequest offlineBrokerRequest, @Nullable Map<ServerInstance, List<String>> offlineRoutingTable, @Nullable BrokerRequest realtimeBrokerRequest, @Nullable Map<ServerInstance, List<String>> realtimeRoutingTable, long timeoutMs) {
        InstanceRequest instanceRequest;
        ServerRoutingInstance serverRoutingInstance;
        assert (offlineBrokerRequest != null || realtimeBrokerRequest != null);
        boolean preferTls = this._serverChannelsTls != null;
        HashMap<ServerRoutingInstance, InstanceRequest> requestMap = new HashMap<ServerRoutingInstance, InstanceRequest>();
        if (offlineBrokerRequest != null) {
            assert (offlineRoutingTable != null);
            for (Map.Entry<ServerInstance, List<String>> entry : offlineRoutingTable.entrySet()) {
                serverRoutingInstance = entry.getKey().toServerRoutingInstance(TableType.OFFLINE, preferTls);
                instanceRequest = this.getInstanceRequest(requestId, offlineBrokerRequest, entry.getValue());
                requestMap.put(serverRoutingInstance, instanceRequest);
            }
        }
        if (realtimeBrokerRequest != null) {
            assert (realtimeRoutingTable != null);
            for (Map.Entry<ServerInstance, List<String>> entry : realtimeRoutingTable.entrySet()) {
                serverRoutingInstance = entry.getKey().toServerRoutingInstance(TableType.REALTIME, preferTls);
                instanceRequest = this.getInstanceRequest(requestId, realtimeBrokerRequest, entry.getValue());
                requestMap.put(serverRoutingInstance, instanceRequest);
            }
        }
        AsyncQueryResponse asyncQueryResponse = new AsyncQueryResponse(this, requestId, requestMap.keySet(), System.currentTimeMillis(), timeoutMs, this._serverRoutingStatsManager);
        this._asyncQueryResponseMap.put(requestId, asyncQueryResponse);
        for (Map.Entry entry : requestMap.entrySet()) {
            ServerRoutingInstance serverRoutingInstance2 = (ServerRoutingInstance)entry.getKey();
            ServerChannels serverChannels = serverRoutingInstance2.isTlsEnabled() ? this._serverChannelsTls : this._serverChannels;
            try {
                this._serverRoutingStatsManager.recordStatsAfterQuerySubmission(requestId, serverRoutingInstance2.getInstanceId());
                serverChannels.sendRequest(rawTableName, asyncQueryResponse, serverRoutingInstance2, (InstanceRequest)entry.getValue(), timeoutMs);
                asyncQueryResponse.markRequestSubmitted(serverRoutingInstance2);
            }
            catch (TimeoutException e) {
                if ("Timeout while acquiring channel lock".equals(e.getMessage())) {
                    this._brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.REQUEST_CHANNEL_LOCK_TIMEOUT_EXCEPTIONS, 1L);
                }
                this.markQueryFailed(requestId, serverRoutingInstance2, asyncQueryResponse, e);
                break;
            }
            catch (Exception e) {
                this._brokerMetrics.addMeteredTableValue(rawTableName, (AbstractMetrics.Meter)BrokerMeter.REQUEST_SEND_EXCEPTIONS, 1L);
                this.markQueryFailed(requestId, serverRoutingInstance2, asyncQueryResponse, e);
                break;
            }
        }
        return asyncQueryResponse;
    }

    private void markQueryFailed(long requestId, ServerRoutingInstance serverRoutingInstance, AsyncQueryResponse asyncQueryResponse, Exception e) {
        LOGGER.error("Caught exception while sending request {} to server: {}, marking query failed", new Object[]{requestId, serverRoutingInstance, e});
        asyncQueryResponse.markQueryFailed(serverRoutingInstance, e);
    }

    public boolean connect(ServerInstance serverInstance) {
        try {
            if (this._serverChannelsTls != null) {
                this._serverChannelsTls.connect(serverInstance.toServerRoutingInstance(TableType.OFFLINE, true));
            } else {
                this._serverChannels.connect(serverInstance.toServerRoutingInstance(TableType.OFFLINE, false));
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.debug("Failed to connect to server: {}", (Object)serverInstance, (Object)e);
            return false;
        }
    }

    public void shutDown() {
        this._serverChannels.shutDown();
    }

    void receiveDataTable(ServerRoutingInstance serverRoutingInstance, DataTable dataTable, int responseSize, int deserializationTimeMs) {
        long requestId = Long.parseLong((String)dataTable.getMetadata().get(DataTable.MetadataKey.REQUEST_ID.getName()));
        AsyncQueryResponse asyncQueryResponse = this._asyncQueryResponseMap.get(requestId);
        if (asyncQueryResponse != null) {
            asyncQueryResponse.receiveDataTable(serverRoutingInstance, dataTable, responseSize, deserializationTimeMs);
        }
    }

    void markServerDown(ServerRoutingInstance serverRoutingInstance, Exception exception) {
        for (AsyncQueryResponse asyncQueryResponse : this._asyncQueryResponseMap.values()) {
            asyncQueryResponse.markServerDown(serverRoutingInstance, exception);
        }
    }

    void markQueryDone(long requestId) {
        this._asyncQueryResponseMap.remove(requestId);
    }

    private InstanceRequest getInstanceRequest(long requestId, BrokerRequest brokerRequest, List<String> segments) {
        InstanceRequest instanceRequest = new InstanceRequest();
        instanceRequest.setRequestId(requestId);
        instanceRequest.setQuery(brokerRequest);
        Map queryOptions = brokerRequest.getPinotQuery().getQueryOptions();
        if (queryOptions != null) {
            instanceRequest.setEnableTrace(Boolean.parseBoolean((String)queryOptions.get("trace")));
        }
        instanceRequest.setSearchSegments(segments);
        instanceRequest.setBrokerId(this._brokerId);
        return instanceRequest;
    }
}

