/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.startree;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.common.request.context.ExpressionContext;
import org.apache.pinot.common.request.context.FilterContext;
import org.apache.pinot.common.request.context.predicate.Predicate;
import org.apache.pinot.core.operator.filter.predicate.PredicateEvaluator;
import org.apache.pinot.core.query.aggregation.function.AggregationFunction;
import org.apache.pinot.core.query.aggregation.function.AggregationFunctionUtils;
import org.apache.pinot.core.startree.CompositePredicateEvaluator;
import org.apache.pinot.segment.spi.IndexSegment;
import org.apache.pinot.segment.spi.datasource.DataSource;
import org.apache.pinot.segment.spi.index.reader.Dictionary;
import org.apache.pinot.segment.spi.index.startree.AggregationFunctionColumnPair;
import org.apache.pinot.segment.spi.index.startree.StarTreeV2Metadata;

public class StarTreeUtils {
    private StarTreeUtils() {
    }

    @Nullable
    public static AggregationFunctionColumnPair[] extractAggregationFunctionPairs(AggregationFunction[] aggregationFunctions) {
        int numAggregationFunctions = aggregationFunctions.length;
        AggregationFunctionColumnPair[] aggregationFunctionColumnPairs = new AggregationFunctionColumnPair[numAggregationFunctions];
        for (int i = 0; i < numAggregationFunctions; ++i) {
            AggregationFunctionColumnPair aggregationFunctionColumnPair = AggregationFunctionUtils.getAggregationFunctionColumnPair(aggregationFunctions[i]);
            if (aggregationFunctionColumnPair == null) {
                return null;
            }
            aggregationFunctionColumnPairs[i] = aggregationFunctionColumnPair;
        }
        return aggregationFunctionColumnPairs;
    }

    @Nullable
    public static Map<String, List<CompositePredicateEvaluator>> extractPredicateEvaluatorsMap(IndexSegment indexSegment, @Nullable FilterContext filter, List<Pair<Predicate, PredicateEvaluator>> predicateEvaluatorMapping) {
        FilterContext filterNode;
        if (filter == null) {
            return Collections.emptyMap();
        }
        HashMap<String, List<CompositePredicateEvaluator>> predicateEvaluatorsMap = new HashMap<String, List<CompositePredicateEvaluator>>();
        ArrayDeque<FilterContext> queue = new ArrayDeque<FilterContext>();
        queue.add(filter);
        block6: while ((filterNode = (FilterContext)queue.poll()) != null) {
            switch (filterNode.getType()) {
                case AND: {
                    queue.addAll(filterNode.getChildren());
                    continue block6;
                }
                case OR: {
                    Pair<String, List<PredicateEvaluator>> pair = StarTreeUtils.isOrClauseValidForStarTree(indexSegment, filterNode, predicateEvaluatorMapping);
                    if (pair == null) {
                        return null;
                    }
                    List predicateEvaluators = (List)pair.getRight();
                    if (predicateEvaluators.isEmpty()) continue block6;
                    predicateEvaluatorsMap.computeIfAbsent((String)pair.getLeft(), k -> new ArrayList()).add(new CompositePredicateEvaluator(predicateEvaluators));
                    continue block6;
                }
                case NOT: {
                    return null;
                }
                case PREDICATE: {
                    Predicate predicate = filterNode.getPredicate();
                    PredicateEvaluator predicateEvaluator = StarTreeUtils.getPredicateEvaluator(indexSegment, predicate, predicateEvaluatorMapping);
                    if (predicateEvaluator == null) {
                        return null;
                    }
                    if (predicateEvaluator.isAlwaysTrue()) continue block6;
                    predicateEvaluatorsMap.computeIfAbsent(predicate.getLhs().getIdentifier(), k -> new ArrayList()).add(new CompositePredicateEvaluator(Collections.singletonList(predicateEvaluator)));
                    continue block6;
                }
            }
            throw new IllegalStateException();
        }
        return predicateEvaluatorsMap;
    }

    public static boolean isFitForStarTree(StarTreeV2Metadata starTreeV2Metadata, AggregationFunctionColumnPair[] aggregationFunctionColumnPairs, @Nullable ExpressionContext[] groupByExpressions, Set<String> predicateColumns) {
        for (AggregationFunctionColumnPair aggregationFunctionColumnPair : aggregationFunctionColumnPairs) {
            if (starTreeV2Metadata.containsFunctionColumnPair(aggregationFunctionColumnPair)) continue;
            return false;
        }
        HashSet starTreeDimensions = new HashSet(starTreeV2Metadata.getDimensionsSplitOrder());
        if (groupByExpressions != null) {
            HashSet groupByColumns = new HashSet();
            for (ExpressionContext groupByExpression : groupByExpressions) {
                groupByExpression.getColumns(groupByColumns);
            }
            if (!starTreeDimensions.containsAll(groupByColumns)) {
                return false;
            }
        }
        return starTreeDimensions.containsAll(predicateColumns);
    }

    @Nullable
    private static Pair<String, List<PredicateEvaluator>> isOrClauseValidForStarTree(IndexSegment indexSegment, FilterContext filter, List<Pair<Predicate, PredicateEvaluator>> predicateEvaluatorMapping) {
        assert (filter.getType() == FilterContext.Type.OR);
        ArrayList<Predicate> predicates = new ArrayList<Predicate>();
        if (!StarTreeUtils.extractOrClausePredicates(filter, predicates)) {
            return null;
        }
        String identifier = null;
        ArrayList<PredicateEvaluator> predicateEvaluators = new ArrayList<PredicateEvaluator>();
        for (Predicate predicate : predicates) {
            PredicateEvaluator predicateEvaluator = StarTreeUtils.getPredicateEvaluator(indexSegment, predicate, predicateEvaluatorMapping);
            if (predicateEvaluator == null) {
                return null;
            }
            if (predicateEvaluator.isAlwaysTrue()) {
                return Pair.of(null, Collections.emptyList());
            }
            if (predicateEvaluator.isAlwaysFalse()) continue;
            String predicateIdentifier = predicate.getLhs().getIdentifier();
            if (identifier == null) {
                identifier = predicateIdentifier;
            } else if (!identifier.equals(predicateIdentifier)) {
                return null;
            }
            predicateEvaluators.add(predicateEvaluator);
        }
        return Pair.of(identifier, predicateEvaluators);
    }

    private static boolean extractOrClausePredicates(FilterContext filter, List<Predicate> predicates) {
        assert (filter.getType() == FilterContext.Type.OR);
        block5: for (FilterContext child : filter.getChildren()) {
            switch (child.getType()) {
                case AND: 
                case NOT: {
                    return false;
                }
                case OR: {
                    if (!StarTreeUtils.extractOrClausePredicates(child, predicates)) {
                        return false;
                    }
                    predicates.add(child.getPredicate());
                    continue block5;
                }
                case PREDICATE: {
                    predicates.add(child.getPredicate());
                    continue block5;
                }
            }
            throw new IllegalStateException();
        }
        return true;
    }

    @Nullable
    private static PredicateEvaluator getPredicateEvaluator(IndexSegment indexSegment, Predicate predicate, List<Pair<Predicate, PredicateEvaluator>> predicatesEvaluatorMapping) {
        ExpressionContext lhs = predicate.getLhs();
        if (lhs.getType() != ExpressionContext.Type.IDENTIFIER) {
            return null;
        }
        String column = lhs.getIdentifier();
        DataSource dataSource = indexSegment.getDataSource(column);
        Dictionary dictionary = dataSource.getDictionary();
        if (dictionary == null) {
            return null;
        }
        switch (predicate.getType()) {
            case REGEXP_LIKE: 
            case TEXT_MATCH: 
            case IS_NULL: 
            case IS_NOT_NULL: {
                return null;
            }
        }
        for (Pair<Predicate, PredicateEvaluator> pair : predicatesEvaluatorMapping) {
            if (!((Predicate)pair.getKey()).equals(predicate)) continue;
            return (PredicateEvaluator)pair.getValue();
        }
        return null;
    }
}

