/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.timehandler;

import com.google.common.base.Preconditions;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.timehandler.EpochTimeHandler;
import org.apache.pinot.core.segment.processing.timehandler.NoOpTimeHandler;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandler;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandlerConfig;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.DateTimeFieldSpec;
import org.apache.pinot.spi.data.Schema;

public class TimeHandlerFactory {
    private TimeHandlerFactory() {
    }

    public static TimeHandler getTimeHandler(SegmentProcessorConfig processorConfig) {
        TimeHandlerConfig timeHandlerConfig = processorConfig.getTimeHandlerConfig();
        TimeHandler.Type type = timeHandlerConfig.getType();
        switch (type) {
            case NO_OP: {
                return new NoOpTimeHandler();
            }
            case EPOCH: {
                TableConfig tableConfig = processorConfig.getTableConfig();
                String timeColumn = tableConfig.getValidationConfig().getTimeColumnName();
                Preconditions.checkState((timeColumn != null ? 1 : 0) != 0, (String)"Time column is not configured for table: %s", (Object)tableConfig.getTableName());
                Schema schema = processorConfig.getSchema();
                DateTimeFieldSpec dateTimeFieldSpec = schema.getSpecForTimeColumn(timeColumn);
                Preconditions.checkState((dateTimeFieldSpec != null ? 1 : 0) != 0, (String)"Time column: %s is not configured as DateTimeField within the schema", (Object)timeColumn);
                return new EpochTimeHandler(dateTimeFieldSpec, timeHandlerConfig.getStartTimeMs(), timeHandlerConfig.getEndTimeMs(), timeHandlerConfig.isNegateWindowFilter(), timeHandlerConfig.getRoundBucketMs(), timeHandlerConfig.getPartitionBucketMs());
            }
        }
        throw new IllegalStateException("Unsupported time handler type: " + type);
    }
}

