/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.reducer;

import java.io.File;
import org.apache.commons.io.FileUtils;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileManager;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileReader;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileRecordReader;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileWriter;
import org.apache.pinot.core.segment.processing.reducer.Reducer;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DedupReducer
implements Reducer {
    private static final Logger LOGGER = LoggerFactory.getLogger(DedupReducer.class);
    private final String _partitionId;
    private final GenericRowFileManager _fileManager;
    private final File _reducerOutputDir;

    public DedupReducer(String partitionId, GenericRowFileManager fileManager, File reducerOutputDir) {
        this._partitionId = partitionId;
        this._fileManager = fileManager;
        this._reducerOutputDir = reducerOutputDir;
    }

    @Override
    public GenericRowFileManager reduce() throws Exception {
        LOGGER.info("Start reducing on partition: {}", (Object)this._partitionId);
        long reduceStartTimeMs = System.currentTimeMillis();
        GenericRowFileReader fileReader = this._fileManager.getFileReader();
        int numRows = fileReader.getNumRows();
        int numSortFields = fileReader.getNumSortFields();
        LOGGER.info("Start sorting on numRows: {}, numSortFields: {}", (Object)numRows, (Object)numSortFields);
        long sortStartTimeMs = System.currentTimeMillis();
        GenericRowFileRecordReader recordReader = fileReader.getRecordReader();
        LOGGER.info("Finish sorting in {}ms", (Object)(System.currentTimeMillis() - sortStartTimeMs));
        File partitionOutputDir = new File(this._reducerOutputDir, this._partitionId);
        FileUtils.forceMkdir((File)partitionOutputDir);
        LOGGER.info("Start creating dedup file under dir: {}", (Object)partitionOutputDir);
        long dedupFileCreationStartTimeMs = System.currentTimeMillis();
        GenericRowFileManager dedupFileManager = new GenericRowFileManager(partitionOutputDir, this._fileManager.getFieldSpecs(), this._fileManager.isIncludeNullFields(), 0);
        GenericRowFileWriter dedupFileWriter = dedupFileManager.getFileWriter();
        GenericRow previousRow = new GenericRow();
        recordReader.read(0, previousRow);
        int previousRowId = 0;
        dedupFileWriter.write(previousRow);
        for (int i = 1; i < numRows; ++i) {
            if (recordReader.compare(previousRowId, i) == 0) continue;
            previousRow.clear();
            recordReader.read(i, previousRow);
            previousRowId = i;
            dedupFileWriter.write(previousRow);
        }
        dedupFileManager.closeFileWriter();
        LOGGER.info("Finish creating dedup file in {}ms", (Object)(System.currentTimeMillis() - dedupFileCreationStartTimeMs));
        this._fileManager.cleanUp();
        LOGGER.info("Finish reducing in {}ms", (Object)(System.currentTimeMillis() - reduceStartTimeMs));
        return dedupFileManager;
    }
}

