/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.partitioner;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerFactory;
import org.apache.pinot.spi.config.table.ColumnPartitionConfig;

@JsonIgnoreProperties(ignoreUnknown=true)
public class PartitionerConfig {
    private static final PartitionerFactory.PartitionerType DEFAULT_PARTITIONER_TYPE = PartitionerFactory.PartitionerType.NO_OP;
    private final PartitionerFactory.PartitionerType _partitionerType;
    private final int _numPartitions;
    private final String _columnName;
    private final String _transformFunction;
    private final ColumnPartitionConfig _columnPartitionConfig;

    @JsonCreator
    private PartitionerConfig(@JsonProperty(value="partitionerType", required=true) PartitionerFactory.PartitionerType partitionerType, @JsonProperty(value="numPartitions") int numPartitions, @JsonProperty(value="columnName") String columnName, @JsonProperty(value="transformFunction") String transformFunction, @JsonProperty(value="columnPartitionConfig") ColumnPartitionConfig columnPartitionConfig) {
        this._partitionerType = partitionerType;
        this._numPartitions = numPartitions;
        this._columnName = columnName;
        this._transformFunction = transformFunction;
        this._columnPartitionConfig = columnPartitionConfig;
    }

    @JsonProperty
    public PartitionerFactory.PartitionerType getPartitionerType() {
        return this._partitionerType;
    }

    @JsonProperty
    public int getNumPartitions() {
        return this._numPartitions;
    }

    @JsonProperty
    public String getColumnName() {
        return this._columnName;
    }

    @JsonProperty
    public String getTransformFunction() {
        return this._transformFunction;
    }

    @JsonProperty
    public ColumnPartitionConfig getColumnPartitionConfig() {
        return this._columnPartitionConfig;
    }

    public String toString() {
        return "PartitioningConfig{_partitionerType=" + this._partitionerType + ", _numPartitions=" + this._numPartitions + ", _columnName='" + this._columnName + "', _transformFunction='" + this._transformFunction + "', _columnPartitionConfig=" + this._columnPartitionConfig + "'}";
    }

    public static class Builder {
        private PartitionerFactory.PartitionerType _partitionerType = DEFAULT_PARTITIONER_TYPE;
        private int _numPartitions;
        private String _columnName;
        private String _transformFunction;
        private ColumnPartitionConfig _columnPartitionConfig;

        public Builder setPartitionerType(PartitionerFactory.PartitionerType partitionerType) {
            this._partitionerType = partitionerType;
            return this;
        }

        public Builder setNumPartitions(int numPartitions) {
            this._numPartitions = numPartitions;
            return this;
        }

        public Builder setColumnName(String columnName) {
            this._columnName = columnName;
            return this;
        }

        public Builder setTransformFunction(String transformFunction) {
            this._transformFunction = transformFunction;
            return this;
        }

        public Builder setColumnPartitionConfig(ColumnPartitionConfig columnPartitionConfig) {
            this._columnPartitionConfig = columnPartitionConfig;
            return this;
        }

        public PartitionerConfig build() {
            return new PartitionerConfig(this._partitionerType, this._numPartitions, this._columnName, this._transformFunction, this._columnPartitionConfig);
        }
    }
}

