/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pinot.core.segment.processing.mapper;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.pinot.core.segment.processing.framework.SegmentProcessorConfig;
import org.apache.pinot.core.segment.processing.genericrow.GenericRowFileManager;
import org.apache.pinot.core.segment.processing.partitioner.Partitioner;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerConfig;
import org.apache.pinot.core.segment.processing.partitioner.PartitionerFactory;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandler;
import org.apache.pinot.core.segment.processing.timehandler.TimeHandlerFactory;
import org.apache.pinot.core.segment.processing.utils.SegmentProcessorUtils;
import org.apache.pinot.segment.local.recordtransformer.CompositeTransformer;
import org.apache.pinot.segment.local.utils.IngestionUtils;
import org.apache.pinot.spi.config.table.TableConfig;
import org.apache.pinot.spi.data.FieldSpec;
import org.apache.pinot.spi.data.Schema;
import org.apache.pinot.spi.data.readers.GenericRow;
import org.apache.pinot.spi.data.readers.RecordReader;
import org.apache.pinot.spi.utils.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SegmentMapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(SegmentMapper.class);
    private final List<RecordReader> _recordReaders;
    private final SegmentProcessorConfig _processorConfig;
    private final File _mapperOutputDir;
    private final List<FieldSpec> _fieldSpecs;
    private final boolean _includeNullFields;
    private final int _numSortFields;
    private final CompositeTransformer _recordTransformer;
    private final TimeHandler _timeHandler;
    private final Partitioner[] _partitioners;
    private final String[] _partitionsBuffer;
    private final Map<String, GenericRowFileManager> _partitionToFileManagerMap = new TreeMap<String, GenericRowFileManager>();

    public SegmentMapper(List<RecordReader> recordReaders, SegmentProcessorConfig processorConfig, File mapperOutputDir) {
        this._recordReaders = recordReaders;
        this._processorConfig = processorConfig;
        this._mapperOutputDir = mapperOutputDir;
        TableConfig tableConfig = processorConfig.getTableConfig();
        Schema schema = processorConfig.getSchema();
        Pair<List<FieldSpec>, Integer> pair = SegmentProcessorUtils.getFieldSpecs(schema, processorConfig.getMergeType(), tableConfig.getIndexingConfig().getSortedColumn());
        this._fieldSpecs = (List)pair.getLeft();
        this._numSortFields = (Integer)pair.getRight();
        this._includeNullFields = tableConfig.getIndexingConfig().isNullHandlingEnabled();
        this._recordTransformer = CompositeTransformer.getDefaultTransformer((TableConfig)tableConfig, (Schema)schema);
        this._timeHandler = TimeHandlerFactory.getTimeHandler(processorConfig);
        List<PartitionerConfig> partitionerConfigs = processorConfig.getPartitionerConfigs();
        int numPartitioners = partitionerConfigs.size();
        this._partitioners = new Partitioner[numPartitioners];
        for (int i = 0; i < numPartitioners; ++i) {
            this._partitioners[i] = PartitionerFactory.getPartitioner(partitionerConfigs.get(i));
        }
        this._partitionsBuffer = new String[numPartitioners + 1];
        LOGGER.info("Initialized mapper with {} record readers, output dir: {}, timeHandler: {}, partitioners: {}", new Object[]{this._recordReaders.size(), this._mapperOutputDir, this._timeHandler.getClass(), Arrays.stream(this._partitioners).map(p -> p.getClass().toString()).collect(Collectors.joining(","))});
    }

    public Map<String, GenericRowFileManager> map() throws Exception {
        Consumer<Object> observer = this._processorConfig.getProgressObserver();
        int totalCount = this._recordReaders.size();
        int count = 1;
        GenericRow reuse = new GenericRow();
        for (RecordReader recordReader : this._recordReaders) {
            observer.accept(String.format("Doing map phase on data from RecordReader (%d out of %d)", count++, totalCount));
            while (recordReader.hasNext()) {
                if ((reuse = recordReader.next(reuse)).getValue("$MULTIPLE_RECORDS_KEY$") != null) {
                    for (GenericRow row : (Collection)reuse.getValue("$MULTIPLE_RECORDS_KEY$")) {
                        GenericRow transformedRow = this._recordTransformer.transform(row);
                        if (transformedRow == null || !IngestionUtils.shouldIngestRow((GenericRow)transformedRow)) continue;
                        this.writeRecord(transformedRow);
                    }
                } else {
                    GenericRow transformedRow = this._recordTransformer.transform(reuse);
                    if (transformedRow != null && IngestionUtils.shouldIngestRow((GenericRow)transformedRow)) {
                        this.writeRecord(transformedRow);
                    }
                }
                reuse.clear();
            }
        }
        for (GenericRowFileManager fileManager : this._partitionToFileManagerMap.values()) {
            fileManager.closeFileWriter();
        }
        return this._partitionToFileManagerMap;
    }

    private void writeRecord(GenericRow row) throws IOException {
        String timePartition = this._timeHandler.handleTime(row);
        if (timePartition == null) {
            return;
        }
        this._partitionsBuffer[0] = timePartition;
        int numPartitioners = this._partitioners.length;
        for (int i = 0; i < numPartitioners; ++i) {
            this._partitionsBuffer[i + 1] = this._partitioners[i].getPartition(row);
        }
        String partition = StringUtil.join((String)"_", (String[])this._partitionsBuffer);
        GenericRowFileManager fileManager = this._partitionToFileManagerMap.get(partition);
        if (fileManager == null) {
            File partitionOutputDir = new File(this._mapperOutputDir, partition);
            FileUtils.forceMkdir((File)partitionOutputDir);
            fileManager = new GenericRowFileManager(partitionOutputDir, this._fieldSpecs, this._includeNullFields, this._numSortFields);
            this._partitionToFileManagerMap.put(partition, fileManager);
        }
        fileManager.getFileWriter().write(row);
    }
}

